/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.license.License;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import de.virtimo.bpc.core.resource.response.ActiveSessions;
import de.virtimo.bpc.core.resource.response.BpcStatusAdminImpl;
import de.virtimo.bpc.core.resource.response.BpcStatusUserImpl;
import de.virtimo.bpc.core.utils.BpcBundleUtil;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcRightRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import de.virtimo.bpc.util.BpcTrustStore;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.karaf.log.core.LogService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.client.Node;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.common.unit.TimeValue;
import org.osgi.framework.BundleContext;

@Path(value="status")
@Tag(name="Status API", description="The Status API allows to retrieve certain status information (e.g. availability, healthiness) of the BPC.\n")
public class StatusEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(StatusEndpoint.class);
    private static final int IDP_HEALTH_CHECK_TIMEOUT_MILLIS = 5000;
    private final BundleContext bundleContext;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private BpcServicesTracker<ReplicationManager> replicationManagerTracker;
    private BpcServicesTracker<DatabaseManager> databaseManagerTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private BpcServicesTracker<OpenSearchBpcPluginManager> openSearchBpcPluginManagerTracker;
    private BpcServicesTracker<LicenseService> licenseServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<LogService> karafLogServiceTracker;

    public StatusEndpoint(BundleContext bundleContext) {
        LOGGER.info("StatusEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(this.bundleContext, OpenSearchService.class);
        this.replicationManagerTracker = new BpcServicesTracker<ReplicationManager>(this.bundleContext, ReplicationManager.class);
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(this.bundleContext, DatabaseManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
        this.openSearchBpcPluginManagerTracker = new BpcServicesTracker<OpenSearchBpcPluginManager>(this.bundleContext, OpenSearchBpcPluginManager.class);
        this.licenseServiceTracker = new BpcServicesTracker<LicenseService>(this.bundleContext, LicenseService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.karafLogServiceTracker = new BpcServicesTracker<LogService>(this.bundleContext, LogService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @GET
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get the status of the local BPC server.", description="Get the status of the local BPC server.")
    @ReturnDescription(value="Depending on the user session more or less data is returned as JSON.")
    public Response getLocalStatus(@Context HttpHeaders httpHeaders, @Context HttpServletRequest servletRequest) {
        LOGGER.debug("getLocalStatus");
        try {
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            ReplicationManager replicationManager = this.replicationManagerTracker.getService();
            DatabaseManager databaseManager = this.databaseManagerTracker.getService();
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
            LicenseService licenseService = this.licenseServiceTracker.getService();
            LogService karafLogService = this.karafLogServiceTracker.getService();
            UserSession userSession = clientSessionManager.getUserSession(servletRequest);
            if (userSession != null && userSession.hasRole("bpcadmin") || CoreModule.isRequestFromOtherBpcServer(httpHeaders, coreBundleConfiguration, openSearchBpcPluginManager)) {
                return Response.ok((Object)new BpcStatusAdminImpl(this.bundleContext, moduleManager, coreBundleConfiguration, licenseService, clientSessionManager, replicationManager, databaseManager, oss, openSearchBpcPluginManager, karafLogService)).build();
            }
            if (userSession != null) {
                return Response.ok((Object)new BpcStatusUserImpl(this.bundleContext, moduleManager, coreBundleConfiguration, licenseService)).build();
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while getting the local server status", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(httpHeaders).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/health")
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="All health status are fine"), @ApiResponse(responseCode="503", description="At least one health status is not fine")})
    @OperationDescription(summary="Retrieve health information.", description="Get the following health infos in one call:\n\n- status of loaded bundles\n- maintenance mode status\n- license status\n- OpenSearch status\n- Identity-Provider status (if endpoint is configured)\n")
    public Response getHealth(@Context HttpHeaders hh) {
        LOGGER.info("getHealth");
        try {
            Response bpcStatusResponse = this.getBpcStatus(hh);
            if (bpcStatusResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                return bpcStatusResponse;
            }
            Response maintenanceStatus = this.getMaintenanceStatus(hh);
            if (maintenanceStatus.getStatus() != Response.Status.OK.getStatusCode()) {
                return maintenanceStatus;
            }
            Response openSearchStatusResponse = this.getOpenSearchStatus();
            if (openSearchStatusResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                return openSearchStatusResponse;
            }
            Response licenseStatusResponse = this.getLicenseStatus(hh);
            if (licenseStatusResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                return licenseStatusResponse;
            }
            Response idpHealthStatusResponse = this.getIdentityProviderHealth(hh);
            if (idpHealthStatusResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while getting the health state", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/bpc")
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Karaf is running and all BPC modules are not in state 'Resolved' and not in state 'Failure`"), @ApiResponse(responseCode="503", description="At least one BPC module is in state 'Resolved' or 'Failure'")})
    @OperationDescription(summary="Get the status of all loaded BPC modules/bundles.", description="Get the status of all loaded BPC modules/bundles.")
    public Response getBpcStatus(@Context HttpHeaders hh) {
        LOGGER.info("getBpcStatus");
        try {
            if (BpcBundleUtil.areAllBpcBundlesInWorkingState(this.bundleContext)) {
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while getting the bpc state", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/maintenance")
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="BPC is not in maintenance mode"), @ApiResponse(responseCode="503", description="BPC is in maintenance mode")})
    @OperationDescription(summary="Get the maintenance mode status.", description="Get the maintenance mode status.")
    public Response getMaintenanceStatus(@Context HttpHeaders hh) {
        LOGGER.info("getMaintenanceStatus");
        try {
            CoreModule coreModule = (CoreModule)this.moduleManagerTracker.getService().getModuleById("_core");
            if (coreModule.isMaintenanceModeEnabled()) {
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while getting the maintenance mode state", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/identity-provider")
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The identity provider is healthy (or the idp health endpoint is not configured)"), @ApiResponse(responseCode="503", description="The identity provider is not healthy")})
    @OperationDescription(summary="Get the health status of the identity provider.", description="Get the health status of the identity provider.\nThe idp health endpoint can be configured by the setting `identityProvider_healthEndpoint`.\nIf the setting is not configured, this endpoint signals success.\n")
    public Response getIdentityProviderHealth(@Context HttpHeaders hh) {
        LOGGER.info("checkIdentityProviderReadiness");
        try {
            CoreModule coreModule = (CoreModule)this.moduleManagerTracker.getService().getModuleById("_core");
            IdentityProviderConfiguration config = coreModule.getCurrentIdentityProviderConfiguration();
            if (config == null) {
                LOGGER.warn("No identity provider configuration found");
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
            String idpHealthEndpoint = config.getIdentityProviderHealthCheckUrl();
            if (idpHealthEndpoint == null || idpHealthEndpoint.isEmpty()) {
                LOGGER.info("No identity provider health endpoint configured. Skipping check...");
                return Response.ok().build();
            }
            HttpRequest req = HttpRequest.newBuilder().uri(new URI(idpHealthEndpoint)).GET().timeout(Duration.ofMillis(5000L)).build();
            HttpClient client = HttpClient.newBuilder().sslContext(BpcTrustStore.getInstance().getBpcSslContext()).build();
            HttpResponse<String> resp = client.send(req, HttpResponse.BodyHandlers.ofString());
            if (resp.statusCode() == 200) {
                return Response.ok().build();
            }
            LOGGER.warn("Identity Provider health check failed: {}", (Object)resp.body());
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while getting the identity provider health state", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/license")
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="BPC license is valid"), @ApiResponse(responseCode="503", description="BPC license is invalid")})
    @OperationDescription(summary="Get the license status.", description="Get the license status.")
    public Response getLicenseStatus(@Context HttpHeaders hh) {
        LOGGER.info("getLicenseStatus");
        try {
            LicenseService licenseService = this.licenseServiceTracker.getService();
            if (!licenseService.isLicenseSet()) {
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
            License license = licenseService.getLicense();
            if (license == null || license.isExpired()) {
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while getting the license state", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/opensearch")
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="503", description="The OpenSearch Service is not healthy due to one of the following reasons:\n\n* No connection to OpenSearch\n* No nodes available\n* Cluster health status is 'red'\n")})
    @OperationDescription(summary="Get the OpenSearch status.", description="Get the OpenSearch status.")
    public Response getOpenSearchStatus() {
        LOGGER.info("getOpenSearchStatus");
        try {
            RestHighLevelClient osClient = this.openSearchServiceTracker.getService().getClient();
            if (osClient == null) {
                LOGGER.warn("No OpenSearch client available");
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
            List<Node> nodes = osClient.getLowLevelClient().getNodes();
            if (nodes == null || nodes.isEmpty()) {
                LOGGER.warn("No OpenSearch nodes found.");
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
            ClusterHealthRequest request = new ClusterHealthRequest();
            request.timeout(TimeValue.timeValueSeconds(30L));
            ClusterHealthResponse healths = osClient.cluster().health(request, RequestOptions.DEFAULT);
            ClusterHealthStatus clusterStatus = healths.getStatus();
            LOGGER.info("Cluster state: {}", (Object)clusterStatus);
            if (clusterStatus == ClusterHealthStatus.RED) {
                LOGGER.warn("OpenSearch cluster in state RED");
                return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
            }
            return Response.ok().build();
        }
        catch (Throwable ex) {
            LOGGER.error("Exception while querying the OpenSearch state", ex);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
    }

    @GET
    @Path(value="/sessions")
    @BpcRightRequired(right="getSessionStatus")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get a list of all sessions.", description="Get a list of all sessions.")
    @ReturnDescription(value="The requested data as JSON.")
    public Response getSessionStatus(@Context HttpHeaders hh) {
        LOGGER.info("getSessionStatus");
        try {
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            ActiveSessions sessions = new ActiveSessions(clientSessionManager.getAllSessions());
            return Response.ok((Object)sessions).build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while getting the session status", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/clustermaster")
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="BPC is the master server"), @ApiResponse(responseCode="503", description="BPC is not the master server")})
    @OperationDescription(summary="To check if this is the BPC master server.", description="To check if this is the BPC master server.")
    public Response getMasterServerStatus(@Context HttpHeaders hh) {
        LOGGER.info("getMasterServerStatus");
        try {
            CoreModule coreModule = (CoreModule)this.moduleManagerTracker.getService().getModuleById("_core");
            if (coreModule.isMasterServer()) {
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while getting the master server status", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

