/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MaskSensitiveData {
    private static final Logger LOGGER = LogManager.getLogger(MaskSensitiveData.class);
    private static final AtomicLong ID_COUNTER = new AtomicLong(System.nanoTime());
    public static final String DO_NOT_DELETE_ID = "doNotDeleteId";
    private static final String PASSWORD_MASK = "******";
    private static final String CLEARED_PASSWORD_VALUE = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Setting> maskSensitiveSettings(Collection<Setting> settings) {
        LOGGER.debug("maskSensitiveSettings");
        long startTimestamp = System.currentTimeMillis();
        try {
            ArrayList<Setting> result = new ArrayList<Setting>();
            for (Setting setting : settings) {
                Setting updatedSetting = null;
                String settingType = setting.getType();
                if (!StringUtil.isNullOrEmpty(settingType)) {
                    switch (settingType.toLowerCase()) {
                        case "text": {
                            Setting setting2 = this.processTextSetting(setting);
                            break;
                        }
                        case "password": {
                            Setting setting2 = this.processPasswordSetting(setting);
                            break;
                        }
                        case "json": {
                            Setting setting2 = this.processJsonSetting(setting);
                            break;
                        }
                        default: {
                            Setting setting2 = updatedSetting = null;
                        }
                    }
                }
                if (updatedSetting != null) {
                    result.add(updatedSetting);
                    continue;
                }
                result.add(setting);
            }
            ArrayList<Setting> arrayList = result;
            return arrayList;
        }
        catch (Exception ex) {
            LOGGER.error("Could not mask the sensitive data of the given settings. Using the unmasked settings.", (Throwable)ex);
        }
        finally {
            LOGGER.debug("maskSensitiveSettings time: {} ms", (Object)(System.currentTimeMillis() - startTimestamp));
        }
        return new ArrayList<Setting>(settings);
    }

    private Setting processTextSetting(Setting setting) {
        LOGGER.debug("processTextSetting setting=...");
        if (setting == null) {
            return null;
        }
        if (!this.isSensitiveField(setting.getName())) {
            return null;
        }
        if (!this.isValueSet(setting.getValue())) {
            return null;
        }
        return new SimpleSettingImpl(setting, PASSWORD_MASK);
    }

    private Setting processPasswordSetting(Setting setting) {
        LOGGER.debug("processPasswordSetting setting=...");
        if (setting == null) {
            return null;
        }
        if (!this.isValueSet(setting.getValue())) {
            return null;
        }
        return new SimpleSettingImpl(setting, PASSWORD_MASK);
    }

    private Setting processJsonSetting(Setting setting) {
        LOGGER.debug("processJsonSetting setting=...");
        if (setting == null) {
            return null;
        }
        if (!(setting instanceof SimpleSettingImpl)) {
            return setting;
        }
        SimpleSettingImpl settingImpl = (SimpleSettingImpl)setting;
        Object enrichedSettingValue = this.recursiveProcessJsonValueObject(setting.getValue(), false, false, true);
        settingImpl.setValue(enrichedSettingValue);
        Object maskedSettingValue = this.recursiveProcessJsonValueObject(enrichedSettingValue, true, false, false);
        return new SimpleSettingImpl(setting, maskedSettingValue);
    }

    private boolean isSensitiveField(String value) {
        if (value == null) {
            return false;
        }
        return value.toLowerCase().contains("password") || value.equalsIgnoreCase("api_key") || value.equalsIgnoreCase("api-key") || value.equalsIgnoreCase("apikey") || value.equalsIgnoreCase("private_key");
    }

    private boolean isValueSet(Object valueObject) {
        if (valueObject == null) {
            return false;
        }
        return !(valueObject instanceof String) || !StringUtil.isNullOrEmpty((String)valueObject);
    }

    private Object recursiveProcessJsonValueObject(Object object, boolean maskSensitiveData, boolean deleteSensitiveData, boolean addUniqueId) {
        if (object instanceof List) {
            ArrayList updatedList = new ArrayList();
            for (Object listEntry : (List)object) {
                Object updatedObject = listEntry instanceof List || listEntry instanceof Map ? this.recursiveProcessJsonValueObject(listEntry, maskSensitiveData, deleteSensitiveData, addUniqueId) : listEntry;
                updatedList.add(updatedObject);
            }
            return updatedList;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            LinkedHashMap<String, Object> updatedMap = new LinkedHashMap<String, Object>();
            for (Object mapKey : map.keySet()) {
                Object updatedObject;
                Object mapValue = map.get(mapKey);
                if (mapValue instanceof List || mapValue instanceof Map) {
                    updatedObject = this.recursiveProcessJsonValueObject(mapValue, maskSensitiveData, deleteSensitiveData, addUniqueId);
                } else if (mapKey instanceof String && this.isSensitiveField((String)mapKey)) {
                    updatedObject = maskSensitiveData ? (this.isValueSet(mapValue) ? PASSWORD_MASK : mapValue) : mapValue;
                    if (deleteSensitiveData && PASSWORD_MASK.equals(updatedObject)) {
                        updatedObject = CLEARED_PASSWORD_VALUE;
                    }
                    if (addUniqueId && updatedMap.get(DO_NOT_DELETE_ID) == null) {
                        updatedMap.put(DO_NOT_DELETE_ID, CLEARED_PASSWORD_VALUE + ID_COUNTER.getAndIncrement());
                    }
                } else {
                    updatedObject = mapValue;
                }
                updatedMap.put((String)mapKey, updatedObject);
            }
            return updatedMap;
        }
        return object;
    }

    public void unmaskSensitiveSettings(Collection<Setting> existingSettings, Collection<Setting> updatedSettings) {
        LOGGER.debug("unmaskSensitiveSettings existingSettings=..., updatedSettings=...");
        if (existingSettings == null || updatedSettings == null) {
            return;
        }
        for (Setting updatedSetting : updatedSettings) {
            Setting existingSetting = this.getSettingByName(updatedSetting.getName(), existingSettings);
            if (existingSetting == null) continue;
            switch (updatedSetting.getType().toLowerCase()) {
                case "text": {
                    this.processUpdatedTextSetting(updatedSetting, existingSetting);
                    break;
                }
                case "password": {
                    this.processUpdatedSensitiveSetting(updatedSetting, existingSetting);
                    break;
                }
                case "json": {
                    this.processUpdatedJsonSetting(updatedSetting, existingSetting);
                }
            }
        }
    }

    private Setting getSettingByName(String name, Collection<Setting> settings) {
        LOGGER.debug("getSettingByName '{}'", (Object)name);
        if (name == null || settings == null) {
            return null;
        }
        for (Setting setting : settings) {
            if (!name.equals(setting.getName())) continue;
            return setting;
        }
        return null;
    }

    private void processUpdatedTextSetting(Setting updatedSetting, Setting existingSetting) {
        LOGGER.debug("processUpdatedTextSetting");
        if (!this.isSensitiveField(updatedSetting.getName())) {
            return;
        }
        if (!(updatedSetting instanceof SimpleSettingImpl)) {
            return;
        }
        SimpleSettingImpl updatedSettingImpl = (SimpleSettingImpl)updatedSetting;
        Object valueObject = updatedSetting.getValue();
        if (!(valueObject instanceof String)) {
            return;
        }
        if (!valueObject.equals(PASSWORD_MASK)) {
            return;
        }
        updatedSettingImpl.setValue(existingSetting.getValue());
    }

    private void processUpdatedSensitiveSetting(Setting updatedSetting, Setting existingSetting) {
        LOGGER.debug("processUpdatedSensitiveSetting updatedSetting=..., existingSetting=...");
        if (!(updatedSetting instanceof SimpleSettingImpl)) {
            return;
        }
        SimpleSettingImpl updatedSettingImpl = (SimpleSettingImpl)updatedSetting;
        Object valueObject = updatedSetting.getValue();
        if (!(valueObject instanceof String)) {
            return;
        }
        if (!valueObject.equals(PASSWORD_MASK)) {
            return;
        }
        updatedSettingImpl.setValue(existingSetting.getValue());
    }

    private void processUpdatedJsonSetting(Setting updatedSetting, Setting existingSetting) {
        LOGGER.debug("processUpdatedJsonSetting");
        if (!(updatedSetting instanceof SimpleSettingImpl)) {
            return;
        }
        SimpleSettingImpl updatedSettingImpl = (SimpleSettingImpl)updatedSetting;
        Object updatedValue = this.recursiveUnmaskSensitiveSettings(updatedSetting.getValue(), existingSetting.getValue());
        updatedSettingImpl.setValue(updatedValue);
    }

    private Object recursiveUnmaskSensitiveSettings(Object object, Object existingObject) {
        if (object instanceof List) {
            List currentList = (List)object;
            ArrayList updatedList = new ArrayList();
            for (Object currentListEntry : currentList) {
                Object updatedObject = currentListEntry instanceof List || currentListEntry instanceof Map ? this.recursiveUnmaskSensitiveSettings(currentListEntry, existingObject) : currentListEntry;
                updatedList.add(updatedObject);
            }
            return updatedList;
        }
        if (object instanceof Map) {
            Map currentMap = (Map)object;
            LinkedHashMap updatedMap = new LinkedHashMap();
            for (Object mapKey : currentMap.keySet()) {
                Object updatedObject;
                Object mapValue = currentMap.get(mapKey);
                if (mapValue instanceof List || mapValue instanceof Map) {
                    updatedObject = this.recursiveUnmaskSensitiveSettings(mapValue, existingObject);
                } else {
                    Object realValue;
                    String doNotDeleteId;
                    Map relatedExistingMap;
                    Object doNotDeleteIdObject;
                    updatedObject = mapValue;
                    if (mapKey instanceof String && this.isSensitiveField((String)mapKey) && PASSWORD_MASK.equals(mapValue) && (doNotDeleteIdObject = currentMap.get(DO_NOT_DELETE_ID)) instanceof String && (relatedExistingMap = this.recursiveFindMapWithDoNotDeleteId(doNotDeleteId = (String)doNotDeleteIdObject, existingObject)) != null && (realValue = relatedExistingMap.get(mapKey)) instanceof String) {
                        updatedObject = realValue;
                    }
                }
                updatedMap.put(mapKey, updatedObject);
            }
            return updatedMap;
        }
        return object;
    }

    private Map recursiveFindMapWithDoNotDeleteId(String doNotDeleteId, Object object) {
        if (object instanceof List) {
            Object listEntry;
            List currentList = (List)object;
            Map foundMap = null;
            Iterator iterator = currentList.iterator();
            while (iterator.hasNext() && (foundMap = (listEntry = iterator.next()) instanceof List || listEntry instanceof Map ? this.recursiveFindMapWithDoNotDeleteId(doNotDeleteId, listEntry) : null) == null) {
            }
            return foundMap;
        }
        if (object instanceof Map) {
            Map currentMap = (Map)object;
            Map foundMap = null;
            for (Object mapKey : currentMap.keySet()) {
                Object mapValue = currentMap.get(mapKey);
                if (mapValue instanceof List || mapValue instanceof Map) {
                    foundMap = this.recursiveFindMapWithDoNotDeleteId(doNotDeleteId, mapValue);
                } else {
                    if (mapKey.equals(DO_NOT_DELETE_ID) && doNotDeleteId.equals(mapValue)) {
                        foundMap = currentMap;
                        break;
                    }
                    foundMap = null;
                }
                if (foundMap == null) continue;
                break;
            }
            return foundMap;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMaskedSensitiveData(Collection<Setting> settings) {
        LOGGER.debug("clearMaskedSensitiveData settings=...");
        long startTimestamp = System.currentTimeMillis();
        try {
            for (Setting setting : settings) {
                String settingType = setting.getType();
                if (StringUtil.isNullOrEmpty(settingType)) continue;
                switch (settingType.toLowerCase()) {
                    case "text": {
                        this.clearMaskedSensitiveDataFromTextSetting(setting);
                        break;
                    }
                    case "password": {
                        this.clearMaskedPasswordFromPasswordSetting(setting);
                        break;
                    }
                    case "json": {
                        this.clearMaskedSensitiveDataFromJsonSetting(setting);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to clear masked sensitive data of the given settings. Using the masked settings.", (Throwable)ex);
        }
        finally {
            LOGGER.debug("clearMaskedSensitiveData time: {} ms", (Object)(System.currentTimeMillis() - startTimestamp));
        }
    }

    private void clearMaskedSensitiveDataFromTextSetting(Setting setting) {
        LOGGER.debug("clearMaskedSensitiveDataFromTextSetting setting=...");
        if (setting == null) {
            return;
        }
        if (!(setting instanceof SimpleSettingImpl)) {
            return;
        }
        SimpleSettingImpl settingImpl = (SimpleSettingImpl)setting;
        if (!this.isSensitiveField(setting.getName())) {
            return;
        }
        if (!PASSWORD_MASK.equals(setting.getValue())) {
            return;
        }
        settingImpl.setValue(CLEARED_PASSWORD_VALUE);
    }

    private void clearMaskedPasswordFromPasswordSetting(Setting setting) {
        LOGGER.debug("clearMaskedPasswordFromPasswordSetting setting=...");
        if (setting == null) {
            return;
        }
        if (!(setting instanceof SimpleSettingImpl)) {
            return;
        }
        SimpleSettingImpl settingImpl = (SimpleSettingImpl)setting;
        if (!PASSWORD_MASK.equals(setting.getValue())) {
            return;
        }
        settingImpl.setValue(CLEARED_PASSWORD_VALUE);
    }

    private void clearMaskedSensitiveDataFromJsonSetting(Setting setting) {
        LOGGER.debug("clearMaskedSensitiveDataFromJsonSetting setting=...");
        if (setting == null) {
            return;
        }
        if (!(setting instanceof SimpleSettingImpl)) {
            return;
        }
        SimpleSettingImpl settingImpl = (SimpleSettingImpl)setting;
        Object enrichedSettingValue = this.recursiveProcessJsonValueObject(setting.getValue(), false, false, true);
        settingImpl.setValue(enrichedSettingValue);
        Object maskedSettingValue = this.recursiveProcessJsonValueObject(enrichedSettingValue, false, true, false);
        settingImpl.setValue(maskedSettingValue);
    }
}

