/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.virtimo.bpc.api.auth.ClientSession;
import de.virtimo.bpc.api.auth.UserSession;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OnlineUser {
    private final String firstName;
    private final String lastName;
    private final String loginName;
    private final String email;
    private final boolean active;
    private final String picture;

    public OnlineUser(String firstName, String lastName, String loginName, String email, boolean active, String picture) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.loginName = loginName;
        this.email = email;
        this.active = active;
        this.picture = picture;
    }

    public OnlineUser(ClientSession clientSession) {
        UserSession userSession = clientSession.getUserSession();
        if (userSession != null) {
            this.firstName = userSession.getFirstName();
            this.lastName = userSession.getLastName();
            this.loginName = userSession.getLoginName();
            this.email = userSession.getEmail();
            this.active = !clientSession.getWebsocketSessions().isEmpty();
            this.picture = OnlineUser.getPicture(userSession);
        } else {
            this.firstName = null;
            this.lastName = null;
            this.loginName = null;
            this.email = null;
            this.active = false;
            this.picture = null;
        }
    }

    @JsonProperty(value="firstName")
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="lastName")
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="loginName")
    public String getLoginName() {
        return this.loginName;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="active")
    public boolean isActive() {
        return this.active;
    }

    @JsonProperty(value="picture")
    public String getPicture() {
        return this.picture;
    }

    @JsonIgnore
    private static String getPicture(@NotNull UserSession userSession) {
        Map<String, Object> customData = userSession.getCustomData();
        Object pictureObj = customData != null ? customData.get("picture") : null;
        return pictureObj != null ? pictureObj.toString() : "";
    }
}

