/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.security.check;

import de.virtimo.bpc.api.AbstractSettingUpdatedEventHandler;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.security.Check;
import de.virtimo.bpc.api.security.CheckResult;
import de.virtimo.bpc.api.security.CheckResultBuilder;
import de.virtimo.bpc.api.security.CheckResultStorageService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.security.check.AbstractBpcSecurityCheck;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Modified;

public class BaseUrlHttpsCheck
extends AbstractBpcSecurityCheck
implements Check {
    private static final Logger LOGGER = LogManager.getLogger(BaseUrlHttpsCheck.class);
    public static final String IDENTIFIER = "BpcBaseUrlHttpsCheck";
    private static final String TAG_CORE_CONFIGURATION = "core-configuration";
    private static final String DETAIL_MESSAGE_HTTP_DISABLED = "bpcBaseUrl is using HTTPS";
    private static final String DETAIL_MESSAGE_HTTP_ENABLED = "bpcBaseUrl is using HTTP without TLS";
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private static final String BASE_URL_HTTPS_CHECK_RESULT_ID = "base-url-https-check-bpc";

    public BaseUrlHttpsCheck(BundleContext bundleContext) {
        super(bundleContext);
        LOGGER.info("BaseUrlHttpsCheck check activated");
    }

    @Override
    protected void coreReady() {
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.eventRegistration.forModuleUpdatedEvents("_core", "bpcBaseUrl", new BpcBaseUrlUpdatedEventHandler());
        this.performCheck();
    }

    @Override
    @Modified
    public void modified(Map<String, Object> properties) {
        LOGGER.info("Base-URL HTTPS check configuration has been modified");
        this.performCheck();
    }

    @Override
    public void shutdownService() {
        super.shutdownService();
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public String getDescription() {
        return "Checks if the bpcBaseUrl is using HTTPS.";
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    private void performCheck() {
        boolean isBaseUrlHttps = this.isHttpsBaseUrl();
        int points = isBaseUrlHttps ? 1 : 0;
        String detailMessage = isBaseUrlHttps ? DETAIL_MESSAGE_HTTP_DISABLED : DETAIL_MESSAGE_HTTP_ENABLED;
        LOGGER.debug("BPC Base Url HTTPS check result - protocol: {}, points: {}", (Object)(isBaseUrlHttps ? "https" : "http"), (Object)points);
        CheckResult checkResult = this.buildCheckResult(points, detailMessage);
        try {
            ((CheckResultStorageService)this.checkResultStorageServiceTracker.getService()).storeCheckResult(checkResult);
        }
        catch (ServiceNotFoundException e) {
            LOGGER.error("CheckResultStorageService not found");
        }
    }

    private boolean isHttpsBaseUrl() {
        String bpcBaseUrl;
        try {
            bpcBaseUrl = (String)BaseUrlHttpsCheck.getCoreModule(this.moduleManagerTracker).getConfiguration().getSetting("bpcBaseUrl").getValue();
        }
        catch (ModuleNotFoundException | ServiceNotFoundException ex) {
            LOGGER.warn("Failed to read the setting 'bpcBaseUrl'. Treating as \"http\".");
            return false;
        }
        try {
            URL url = new URL(bpcBaseUrl);
            return "https".equalsIgnoreCase(url.getProtocol());
        }
        catch (MalformedURLException e) {
            LOGGER.warn("Malformed URL (\"{}\"), failed to parse protocol. (Treat as \"http\")", (Object)bpcBaseUrl);
            return false;
        }
    }

    private static CoreModule getCoreModule(BpcServicesTracker<ModuleManager> moduleManagerTracker) throws ServiceNotFoundException, ModuleNotFoundException {
        return (CoreModule)moduleManagerTracker.getService().getModuleById("_core");
    }

    private CheckResult buildCheckResult(int points, String detailMessage) {
        return new CheckResultBuilder().withCheckId(this.getIdentifier()).withCheckResultId(BASE_URL_HTTPS_CHECK_RESULT_ID).withPoints(points).withDetailMessage(detailMessage).withTags(List.of(TAG_CORE_CONFIGURATION)).build();
    }

    private class BpcBaseUrlUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private BpcBaseUrlUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting setting) {
            LOGGER.info("{}.processSetting setting=...", (Object)this.getClass().getSimpleName());
            BaseUrlHttpsCheck.this.performCheck();
        }
    }
}

