/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.security.check;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.security.Check;
import de.virtimo.bpc.api.security.CheckResult;
import de.virtimo.bpc.api.security.CheckResultBuilder;
import de.virtimo.bpc.api.security.CheckResultStorageService;
import de.virtimo.bpc.core.security.check.AbstractBpcSecurityCheck;
import de.virtimo.bpc.util.BoolUtil;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.annotations.Modified;

public class HttpsCheck
extends AbstractBpcSecurityCheck
implements Check {
    private static final Logger LOGGER = LogManager.getLogger(HttpsCheck.class);
    public static final String IDENTIFIER = "HttpsCheck";
    private static final String TAG_CORE_CONFIGURATION = "core-configuration";
    private static final String DETAIL_MESSAGE_HTTP_DISABLED = "HTTP is disabled";
    private static final String DETAIL_MESSAGE_HTTP_ENABLED = "HTTP (without TLS) is enabled - this should be disabled and users should reach BPC via HTTPS. (Set org.osgi.service.http.enabled to false)";
    private ServiceRegistration<ConfigurationListener> coreConfigurationListenerRegistration;
    private static final String PAX_WEB_HTTP_ENABLED_KEY = "org.osgi.service.http.enabled";
    private static final String ORG_OPS_4_J_PAX_WEB_PID = "org.ops4j.pax.web";
    private static final String HTTPS_CHECK_RESULT_ID = "https-check-bpc";

    public HttpsCheck(BundleContext bundleContext) {
        super(bundleContext);
        LOGGER.info("HttpsCheck check activated");
    }

    @Override
    protected void coreReady() {
        this.coreConfigurationListenerRegistration = this.bundleContext.registerService(ConfigurationListener.class, (Object)new ConfigurationListenerImpl(this), null);
        this.performCheck();
    }

    @Override
    @Modified
    public void modified(Map<String, Object> properties) {
        LOGGER.info("HTTPS check configuration has been modified");
        this.performCheck();
    }

    @Override
    public void shutdownService() {
        super.shutdownService();
        BpcService.unregister(this.bundleContext, this.coreConfigurationListenerRegistration, ConfigurationListener.class);
    }

    @Override
    public String getDescription() {
        return "Checks if HTTP is disabled and only HTTPS is available.";
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    private void performCheck() {
        boolean isHttpDisabled = this.isHttpDisabled();
        int points = isHttpDisabled ? 1 : 0;
        String detailMessage = isHttpDisabled ? DETAIL_MESSAGE_HTTP_DISABLED : DETAIL_MESSAGE_HTTP_ENABLED;
        LOGGER.debug("HTTP check result - disabled: {}, points: {}", (Object)isHttpDisabled, (Object)points);
        CheckResult checkResult = this.buildCheckResult(points, detailMessage);
        try {
            ((CheckResultStorageService)this.checkResultStorageServiceTracker.getService()).storeCheckResult(checkResult);
        }
        catch (ServiceNotFoundException e) {
            LOGGER.error("CheckResultStorageService not found");
        }
    }

    private boolean isHttpDisabled() {
        try {
            boolean isHttpEnabled = BoolUtil.getBoolean(((ConfigurationAdmin)this.configurationAdminTracker.getService()).getConfiguration(ORG_OPS_4_J_PAX_WEB_PID).getProcessedProperties(null).get(PAX_WEB_HTTP_ENABLED_KEY), true);
            return !isHttpEnabled;
        }
        catch (Exception e) {
            LOGGER.error("Failed to read the core configuration.", (Throwable)e);
            return false;
        }
    }

    private CheckResult buildCheckResult(int points, String detailMessage) {
        return new CheckResultBuilder().withCheckId(this.getIdentifier()).withCheckResultId(HTTPS_CHECK_RESULT_ID).withPoints(points).withDetailMessage(detailMessage).withTags(List.of(TAG_CORE_CONFIGURATION)).build();
    }

    private static class ConfigurationListenerImpl
    implements ConfigurationListener {
        private final HttpsCheck check;

        public ConfigurationListenerImpl(HttpsCheck check) {
            this.check = check;
        }

        public void configurationEvent(ConfigurationEvent configurationEvent) {
            LOGGER.debug("configurationEvent: {}", (Object)configurationEvent);
            if (configurationEvent.getType() == 1 && HttpsCheck.ORG_OPS_4_J_PAX_WEB_PID.equals(configurationEvent.getPid())) {
                this.check.performCheck();
            }
        }
    }
}

