/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.security.check;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.security.Check;
import de.virtimo.bpc.api.security.CheckResult;
import de.virtimo.bpc.api.security.CheckResultBuilder;
import de.virtimo.bpc.api.security.CheckResultStorageService;
import de.virtimo.bpc.core.security.check.AbstractBpcSecurityCheck;
import de.virtimo.bpc.util.BoolUtil;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.annotations.Modified;

public class IpPinningCheck
extends AbstractBpcSecurityCheck
implements Check {
    private static final Logger LOGGER = LogManager.getLogger(IpPinningCheck.class);
    public static final String IDENTIFIER = "IpPinningCheck";
    private static final String TAG_CORE_CONFIGURATION = "core-configuration";
    private static final String DETAIL_MESSAGE_ENABLED = "IP pinning is enabled";
    private static final String DETAIL_MESSAGE_DISABLED = "IP pinning is disabled - sessions are not bound to client IP addresses";
    private ServiceRegistration<ConfigurationListener> coreConfigurationListenerRegistration;
    private static final String IP_PINNING_CHECK_RESULT_ID = "ip-pinning-check";

    public IpPinningCheck(BundleContext bundleContext) {
        super(bundleContext);
        LOGGER.info("IpPinningCheck check activated");
    }

    @Override
    protected void coreReady() {
        this.coreConfigurationListenerRegistration = this.bundleContext.registerService(ConfigurationListener.class, (Object)new ConfigurationListenerImpl(this), null);
        this.performCheck();
    }

    @Override
    @Modified
    public void modified(Map<String, Object> properties) {
        LOGGER.info("IP pinning configuration has been modified");
        this.performCheck();
    }

    @Override
    public void shutdownService() {
        super.shutdownService();
        BpcService.unregister(this.bundleContext, this.coreConfigurationListenerRegistration, ConfigurationListener.class);
    }

    @Override
    public String getDescription() {
        return "Checks if IP pinning is enabled for client sessions";
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    private void performCheck() {
        boolean ipPinningEnabled = this.isIpPinningEnabled();
        int points = ipPinningEnabled ? 1 : 0;
        String detailMessage = ipPinningEnabled ? DETAIL_MESSAGE_ENABLED : DETAIL_MESSAGE_DISABLED;
        LOGGER.debug("IP pinning check result - enabled: {}, points: {}", (Object)ipPinningEnabled, (Object)points);
        CheckResult checkResult = this.buildCheckResult(points, detailMessage);
        try {
            ((CheckResultStorageService)this.checkResultStorageServiceTracker.getService()).storeCheckResult(checkResult);
        }
        catch (ServiceNotFoundException e) {
            LOGGER.error("CheckResultStorageService not found");
        }
    }

    private boolean isIpPinningEnabled() {
        try {
            return BoolUtil.getBoolean(((ConfigurationAdmin)this.configurationAdminTracker.getService()).getConfiguration("de.virtimo.bpc.core").getProcessedProperties(null).get("de.virtimo.bpc.core.ipPinningCheck"), false);
        }
        catch (Exception e) {
            LOGGER.error("Failed to read the core configuration.", (Throwable)e);
            return false;
        }
    }

    private CheckResult buildCheckResult(int points, String detailMessage) {
        return new CheckResultBuilder().withCheckId(this.getIdentifier()).withCheckResultId(IP_PINNING_CHECK_RESULT_ID).withPoints(points).withDetailMessage(detailMessage).withTags(List.of(TAG_CORE_CONFIGURATION)).build();
    }

    private static class ConfigurationListenerImpl
    implements ConfigurationListener {
        private final IpPinningCheck check;

        public ConfigurationListenerImpl(IpPinningCheck check) {
            this.check = check;
        }

        public void configurationEvent(ConfigurationEvent configurationEvent) {
            LOGGER.debug("configurationEvent: {}", (Object)configurationEvent);
            if (configurationEvent.getType() == 1 && "de.virtimo.bpc.core".equals(configurationEvent.getPid())) {
                this.check.performCheck();
            }
        }
    }
}

