/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.service;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.EventHandlerEvent;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.Broadcast;
import de.virtimo.bpc.core.opensearch.BroadcastImpl;
import de.virtimo.bpc.util.MapUtil;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class EventManagerImpl
implements EventManager,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(EventManagerImpl.class);
    private final BundleContext bundleContext;
    private final BpcServicesTracker<EventAdmin> eventAdminTracker;
    private String serverUUID;

    public EventManagerImpl(BundleContext bundleContext, String serverUUID) {
        LOGGER.info("EventManagerImpl bundleContext=..., serverUUID={}", (Object)serverUUID);
        this.bundleContext = bundleContext;
        this.serverUUID = serverUUID;
        this.eventAdminTracker = new BpcServicesTracker<EventAdmin>(bundleContext, EventAdmin.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setServerUUID(String serverUUID) {
        this.serverUUID = serverUUID;
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public void fireEvent(String topic, EventHandlerEvent eventHandlerEvent) {
        LOGGER.debug("fireEvent topic={}, eventHandlerEvent={}", (Object)topic, (Object)eventHandlerEvent);
        this.fireEvent(topic, eventHandlerEvent != null ? eventHandlerEvent.asMap() : null);
    }

    @Override
    public void fireEvent(String topic, Map<String, ?> properties) {
        LOGGER.info("fireEvent topic={}, properties=...", (Object)topic);
        try {
            this.eventAdminTracker.getService().postEvent(new Event(topic, properties));
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.warn("No EventAdmin to fire an event!!!");
        }
    }

    @Override
    public void fireEvent(String topic, String propertyName, Object propertyValue) {
        LOGGER.info("fireEvent topic={}, propertyName={}, propertyValue=...", (Object)topic, (Object)propertyName);
        this.fireEvent(topic, MapUtil.mapOf(propertyName, propertyValue));
    }

    @Override
    public void fireMaintenanceModeAcknowledgedEvent(String moduleId, String handler) {
        LOGGER.info("fireMaintenanceModeAcknowledgedEvent moduleId={}, handler={}", (Object)moduleId, (Object)handler);
        this.fireEvent("de/virtimo/bpc/core/maintenanceMode/acknowledged", MapUtil.mapOf("moduleId", moduleId, "handler", handler));
    }

    @Override
    public Broadcast broadcast() throws ServiceNotFoundException {
        return new BroadcastImpl(this, this.serverUUID);
    }
}

