/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.storage;

import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.AbstractServerModeChangedEventHandler;
import de.virtimo.bpc.api.AbstractSettingUpdatedEventHandler;
import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.BackupSettingFactory;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.ItemRestriction;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.JsonGenerationException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.IndexInfo;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcDataFilter;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcDataSort;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.api.service.StorageService;
import de.virtimo.bpc.api.storage.StoreItem;
import de.virtimo.bpc.api.storage.StoreItems;
import de.virtimo.bpc.api.storage.exception.StorageGeneralException;
import de.virtimo.bpc.api.storage.exception.StoreIndexPreparationException;
import de.virtimo.bpc.api.storage.exception.StoreItemExistsAlreadyException;
import de.virtimo.bpc.api.storage.exception.StoreItemJsonException;
import de.virtimo.bpc.api.storage.exception.StoreItemNotFoundException;
import de.virtimo.bpc.api.storage.exception.StoreItemRightsException;
import de.virtimo.bpc.api.storage.exception.StoreItemValidationException;
import de.virtimo.bpc.api.storage.exception.StoreNotFoundException;
import de.virtimo.bpc.core.storage.IfIndexWasMissingCallable;
import de.virtimo.bpc.core.storage.StoragePersistenceHandler;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobScheduleActionEntryDTO;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public class StorageServiceImpl
implements StorageService,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(StorageServiceImpl.class);
    private static final String INDEX_PREFIX = "bpc-store-";
    private static final String BACKUP_JOB_PREFIX = "core:storageservice:";
    public static final String DEFAULT_STORAGE_SERVICE_INDICES_BACKUP_SETTING_NAME = "defaultStorageServiceIndicesBackup";
    private final BundleContext bundleContext;
    private Setting defaultStorageServiceIndicesBackupSetting;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker = null;
    private BpcServicesTracker<BackupManager> backupManagerTracker = null;
    private final EventRegistration eventRegistration;

    public StorageServiceImpl(BundleContext bundleContext, Setting defaultStorageServiceIndicesBackupSetting) {
        this.bundleContext = bundleContext;
        this.defaultStorageServiceIndicesBackupSetting = defaultStorageServiceIndicesBackupSetting;
        if (bundleContext != null) {
            this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
            this.backupManagerTracker = new BpcServicesTracker<BackupManager>(bundleContext, BackupManager.class);
        } else {
            LOGGER.warn("BundleContext is null? Hopefully this is just an integration test.");
        }
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forModuleUpdatedEvents("_core", DEFAULT_STORAGE_SERVICE_INDICES_BACKUP_SETTING_NAME, new DefaultStorageServiceIndicesBackupSettingUpdatedEventHandler());
        this.eventRegistration.forOpenSearchPluginEvents(new IndexDeletedEventHandler());
        this.eventRegistration.forServerModeChangedEvents(new MasterOrSlaveModeChangedEventHandler());
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        BpcServicesTracker.stopAll(this);
        this.eventRegistration.unregisterAllEventHandler();
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public synchronized void restartBackupJobs() {
        LOGGER.info("restartBackupJobs");
        if (this.defaultStorageServiceIndicesBackupSetting != null) {
            try {
                ArrayList<BackupJobScheduleActionEntryDTO> backupJobEntries = new ArrayList<BackupJobScheduleActionEntryDTO>();
                Map<String, IndexInfo> allIndices = this.getOpenSearchService().getIndexInfos();
                for (IndexInfo indexInfo : allIndices.values()) {
                    if (!indexInfo.getIndex().startsWith(INDEX_PREFIX)) continue;
                    BackupSetting backupSetting = BackupSettingFactory.createFrom(this.defaultStorageServiceIndicesBackupSetting, indexInfo.getAliases());
                    BackupJobScheduleActionEntryDTO backupJobEntry = new BackupJobScheduleActionEntryDTO(BACKUP_JOB_PREFIX + backupSetting.getIndicesToBackupNamesAsKey(), BackupSetting.asMap(backupSetting));
                    backupJobEntries.add(backupJobEntry);
                }
                if (!backupJobEntries.isEmpty()) {
                    this.backupManagerTracker.getService().scheduleBackupJobs(backupJobEntries);
                }
            }
            catch (ServiceNotFoundException ex) {
                LOGGER.error("Cannot schedule a storage service backup job without the BackupManager");
            }
            catch (OpenSearchRelatedException e) {
                LOGGER.warn("Ignoring storage service backup exception.", (Throwable)e);
            }
            catch (JsonGenerationException ex) {
                LOGGER.error("Unexpected error while converting a backup setting from JSON.", (Throwable)ex);
            }
        }
    }

    private void scheduleBackupJobForIndexAliases(Set<String> aliases) throws ServiceNotFoundException {
        LOGGER.info("scheduleBackupJobForIndexAliases aliases={}", aliases);
        if (this.defaultStorageServiceIndicesBackupSetting != null) {
            try {
                BackupSetting backupSetting = BackupSettingFactory.createFrom(this.defaultStorageServiceIndicesBackupSetting, aliases);
                BackupJobScheduleActionEntryDTO backupJobEntry = new BackupJobScheduleActionEntryDTO(BACKUP_JOB_PREFIX + backupSetting.getIndicesToBackupNamesAsKey(), BackupSetting.asMap(backupSetting));
                this.backupManagerTracker.getService().scheduleBackupJobs(List.of(backupJobEntry));
            }
            catch (JsonGenerationException ex) {
                LOGGER.error("Unexpected error while converting a backup setting from JSON.", (Throwable)ex);
            }
        }
    }

    private void scheduleBackupJobForIndexAlias(String alias) {
        LOGGER.info("scheduleBackupJobForIndexAlias alias={}", (Object)alias);
        try {
            this.scheduleBackupJobForIndexAliases(SetUtil.setOf(alias));
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.error("Failed to schedule a backup job for the index alias: " + alias + " due to a missing service.", (Throwable)ex);
        }
    }

    @Override
    public String getIndexName(String storeId) {
        return (INDEX_PREFIX + storeId).toLowerCase();
    }

    @Override
    public Set<String> getIndexNames(Set<String> storeIDs) {
        HashSet<String> result = new HashSet<String>();
        if (storeIDs != null) {
            for (String storeID : storeIDs) {
                String indexName = this.getIndexName(storeID);
                result.add(indexName);
            }
        }
        return result;
    }

    public OpenSearchService getOpenSearchService() throws ServiceNotFoundException {
        return this.openSearchServiceTracker.getService();
    }

    @Override
    public StoreItems getItems(String storeId, Integer start, Integer limit, String query, String filtersAsJsonArray, String sort, String timeZoneId, UserSession userSession) throws ServiceNotFoundException, OpenSearchRelatedException, StorageGeneralException, StoreNotFoundException {
        LOGGER.info("getItems storeId={}, start={}, limit={}, query={}, filtersAsJsonArray={}, sort={}, timeZoneId={}, userSession=...", (Object)storeId, (Object)start, (Object)limit, (Object)query, (Object)filtersAsJsonArray, (Object)sort, (Object)timeZoneId);
        List<BpcDataFilter> filters = null;
        if (!StringUtil.isNullOrEmpty(filtersAsJsonArray)) {
            try {
                filters = BpcDataFilter.fromJsonArray(filtersAsJsonArray);
            }
            catch (Exception ex) {
                throw new StorageGeneralException((ErrorCode)BpcErrorCode.STORAGE_JSON_PARSE_EXCEPTION, "Parsing a JSON filters string to a BpcDataFilter list failed.", ex);
            }
        }
        List<BpcDataSort> sorts = null;
        if (!StringUtil.isNullOrEmpty(sort)) {
            try {
                sorts = BpcDataSort.fromJsonArray(sort);
            }
            catch (Exception ex) {
                sorts = BpcDataSort.fromCompactFormat(sort);
            }
        }
        return this.getItems(storeId, start, limit, query, filters, sorts, timeZoneId, userSession);
    }

    @Override
    public StoreItems getItems(String storeId, Integer start, Integer limit, String query, List<BpcDataFilter> filters, List<BpcDataSort> sorts, String timeZoneId, UserSession userSession) throws ServiceNotFoundException, OpenSearchRelatedException, StoreNotFoundException {
        LOGGER.info("getItems storeId={}, start={}, limit={}, query={}, filters={}, sorts={}, timeZoneId={}, userSession=...", (Object)storeId, (Object)start, (Object)limit, (Object)query, filters, sorts, (Object)timeZoneId);
        if (start == null || start < 0) {
            start = 0;
            LOGGER.debug("No 'start' parameter given or out of range. Set start to {}", (Object)start);
        }
        if (limit == null || limit < 0 || limit > 10000) {
            limit = 10000;
            LOGGER.debug("No 'limit' parameter given or out of range. Set limit to {}", (Object)limit);
        }
        String indexName = this.getIndexName(storeId);
        StoragePersistenceHandler persistenceHandler = new StoragePersistenceHandler(this.getOpenSearchService());
        return persistenceHandler.loadStoreItems(indexName, storeId, start, limit, query, filters, sorts, timeZoneId, userSession);
    }

    @Override
    public StoreItem getItem(String storeId, String itemId, UserSession userSession) throws ServiceNotFoundException, OpenSearchRelatedException, StoreNotFoundException, StoreItemNotFoundException, StoreItemRightsException {
        LOGGER.info("getItem storeId={}, itemId={}, userSession=...", (Object)storeId, (Object)itemId);
        StoragePersistenceHandler persistenceHandler = new StoragePersistenceHandler(this.getOpenSearchService());
        String indexName = this.getIndexName(storeId);
        StoreItem storeItem = persistenceHandler.loadStoreItem(indexName, storeId, itemId);
        if (!storeItem.isReadableBy(userSession)) {
            throw new StoreItemRightsException(storeId, itemId);
        }
        return storeItem;
    }

    @Override
    public void createItem(String storeId, StoreItem storeItem, UserSession userSession) throws ServiceNotFoundException, OpenSearchRelatedException, StoreItemExistsAlreadyException, StoreIndexPreparationException, StoreItemJsonException, StoreNotFoundException, StoreItemValidationException {
        LOGGER.info("createItem storeId={}, storeItem={}, userSession=...", (Object)storeId, (Object)storeItem);
        this.validateStoreItemForCreateOrUpdate(storeItem, userSession);
        StoragePersistenceHandler persistenceHandler = new StoragePersistenceHandler(this.getOpenSearchService());
        String indexName = this.getIndexName(storeId);
        try {
            StoreItem existingStoreItem = persistenceHandler.loadStoreItem(indexName, storeId, storeItem.getId());
            if (existingStoreItem != null) {
                throw new StoreItemExistsAlreadyException(storeId, storeItem.getId());
            }
        }
        catch (StoreItemNotFoundException | StoreNotFoundException storageException) {
            // empty catch block
        }
        persistenceHandler.createIndexIfMissing(indexName, new IfIndexWasMissingCallable(){

            @Override
            public void doSomethingWithTheMissingIndex(String indexName) {
                StorageServiceImpl.this.scheduleBackupJobForIndexAlias(indexName);
            }
        });
        persistenceHandler.saveStoreItem(indexName, storeId, storeItem);
    }

    @Override
    public StoreItem updateOrCreateItem(String storeId, StoreItem storeItem, UserSession userSession) throws ServiceNotFoundException, OpenSearchRelatedException, StoreItemRightsException, StoreIndexPreparationException, StoreNotFoundException, StoreItemJsonException, StoreItemValidationException {
        LOGGER.info("updateOrCreateItem storeId={}, storeItem={}, userSession=...", (Object)storeId, (Object)storeItem);
        this.validateStoreItemForCreateOrUpdate(storeItem, userSession);
        StoragePersistenceHandler persistenceHandler = new StoragePersistenceHandler(this.getOpenSearchService());
        String indexName = this.getIndexName(storeId);
        StoreItem existingStoreItem = null;
        try {
            existingStoreItem = persistenceHandler.loadStoreItem(indexName, storeId, storeItem.getId());
            if (!existingStoreItem.isWriteableBy(userSession)) {
                throw new StoreItemRightsException(storeId, storeItem.getId());
            }
        }
        catch (StoreItemNotFoundException | StoreNotFoundException storageException) {
            // empty catch block
        }
        if (!Objects.equals(existingStoreItem, storeItem)) {
            persistenceHandler.createIndexIfMissing(indexName, new IfIndexWasMissingCallable(){

                @Override
                public void doSomethingWithTheMissingIndex(String indexName) {
                    StorageServiceImpl.this.scheduleBackupJobForIndexAlias(indexName);
                }
            });
            persistenceHandler.saveStoreItem(indexName, storeId, storeItem);
        }
        return existingStoreItem;
    }

    @Override
    public StoreItem deleteItem(String storeId, String itemId, UserSession userSession) throws ServiceNotFoundException, OpenSearchRelatedException, StoreNotFoundException, StoreItemNotFoundException, StoreItemRightsException {
        LOGGER.info("deleteItem storeId={}, itemId={}, userSession=...", (Object)storeId, (Object)itemId);
        StoragePersistenceHandler persistenceHandler = new StoragePersistenceHandler(this.getOpenSearchService());
        String indexName = this.getIndexName(storeId);
        StoreItem storeItem = persistenceHandler.loadStoreItem(indexName, storeId, itemId);
        if (!storeItem.isDeletableBy(userSession)) {
            throw new StoreItemRightsException(storeId, itemId);
        }
        persistenceHandler.deleteStoreItem(indexName, storeId, itemId);
        return storeItem;
    }

    private void validateStoreItemForCreateOrUpdate(StoreItem storeItem, UserSession userSession) throws StoreItemValidationException {
        LOGGER.info("validateStoreItem storeItem=...");
        if (StringUtil.isNullOrEmpty(storeItem.getId())) {
            throw new StoreItemValidationException("id");
        }
        if (storeItem.getValue() == null) {
            throw new StoreItemValidationException("value");
        }
        ItemRestriction readRestriction = storeItem.getReadRestriction();
        if (readRestriction == null || !readRestriction.isValid() || !readRestriction.hasAccess(userSession)) {
            throw new StoreItemValidationException("readRestriction");
        }
        ItemRestriction writeRestriction = storeItem.getWriteRestriction();
        if (writeRestriction == null || !writeRestriction.isValid() || !writeRestriction.hasAccess(userSession)) {
            throw new StoreItemValidationException("writeRestriction");
        }
    }

    private class DefaultStorageServiceIndicesBackupSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private DefaultStorageServiceIndicesBackupSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting setting) {
            LOGGER.info("{}.processSetting setting=...", (Object)this.getClass().getSimpleName());
            StorageServiceImpl.this.defaultStorageServiceIndicesBackupSetting = setting;
        }
    }

    private class IndexDeletedEventHandler
    extends AbstractEventHandler {
        private IndexDeletedEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return Arrays.asList(event.getPropertyNames()).contains("IndexDeleted");
        }

        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            Map msg = (Map)event.getProperty("IndexDeleted");
            String aliasOfDeletedBpcIndex = (String)msg.get("aliasOfBpcIndex");
            if (aliasOfDeletedBpcIndex != null && aliasOfDeletedBpcIndex.startsWith(StorageServiceImpl.INDEX_PREFIX)) {
                try {
                    StorageServiceImpl.this.backupManagerTracker.getService().deleteBackupJob(StorageServiceImpl.BACKUP_JOB_PREFIX + aliasOfDeletedBpcIndex);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to process the index deleted event: {}", (Object)event, (Object)ex);
                }
            }
        }
    }

    private class MasterOrSlaveModeChangedEventHandler
    extends AbstractServerModeChangedEventHandler {
        private MasterOrSlaveModeChangedEventHandler() {
        }

        @Override
        public void processThisIsNowTheMasterServer(AbstractServerModeChangedEventHandler.ServerModeOfThisServerChangedEvent serverModeOfThisServerChangedEvent) {
            LOGGER.info("{}.processThisIsNowTheMasterServer serverModeOfThisServerChangedEvent={}", (Object)this.getClass().getSimpleName(), (Object)serverModeOfThisServerChangedEvent);
            StorageServiceImpl.this.restartBackupJobs();
        }

        @Override
        public void processThisIsNowASlaveServer(AbstractServerModeChangedEventHandler.ServerModeOfThisServerChangedEvent serverModeOfThisServerChangedEvent) {
            LOGGER.info("{}.processThisIsNowASlaveServer serverModeOfThisServerChangedEvent={}", (Object)this.getClass().getSimpleName(), (Object)serverModeOfThisServerChangedEvent);
        }
    }
}

