/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.storage.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.StorageService;
import de.virtimo.bpc.api.storage.StoreItem;
import de.virtimo.bpc.api.storage.StoreItems;
import de.virtimo.bpc.api.storage.exception.StoreNotFoundException;
import de.virtimo.bpc.core.storage.StoreItemFactory;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import de.virtimo.bpc.util.TimeZoneUtil;
import de.virtimo.bpc.util.UUIDGenerator;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="storage")
@Tag(name="Storage API", description="Modules can use the Storage API to store custom data in specific storage indices.\nThis API provides additional filtering and read and write restrictions with respect to users, roles and organizations.\n")
public class StorageEndpoints {
    private static final Logger LOGGER = LogManager.getLogger(StorageEndpoints.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<StorageService> storageServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public StorageEndpoints(BundleContext bundleContext) {
        LOGGER.info("StorageEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.storageServiceTracker = new BpcServicesTracker<StorageService>(this.bundleContext, StorageService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @GET
    @Path(value="/store/{storeId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="OpenSearch service not found"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* Given JSON could not be parsed\n* Something went wrong while accessing OpenSearch\n")})
    @OperationDescription(summary="Get store items from the OpenSearch index `bpc-store-<storeId>`.", description="Get store items from the OpenSearch index `bpc-store-<storeId>`.\nReturns an empty response when the store does not exist.\n")
    @ReturnDescription(value="The requested store items as JSON")
    public Response getItems(@Parameter(description="the ID of the store to get the items from") @PathParam(value="storeId") String storeId, @Parameter(description="timezone offset like `GMT+2` (optional). Is used if a date field is accessed in the `filter` with a range operator like \"gt\", \"gte\", \"lt\", \"lte\", \">\", \">=\", \"<\", \"\\<=\". UTC is the default. `timezoneName` is used before `timezoneOffset` if both are set.") @QueryParam(value="timezoneOffset") String timezoneOffset, @Parameter(description="timezone name like `Europe/Berlin` (optional). Is used if a date field is accessed in the `filter` with a range operator like \"gt\", \"gte\", \"lt\", \"lte\", \">\", \">=\", \"<\", \"\\<=\". UTC is the default. `timezoneName` is used before `timezoneOffset` if both are set.") @QueryParam(value="timezoneName") String timezoneName, @Parameter(description="first record to be read (optional, default = 0)") @QueryParam(value="start") @DefaultValue(value="0") Integer start, @Parameter(description="number of records to read (optional, default = 1000, max. 10.000)") @QueryParam(value="limit") @DefaultValue(value="1000") Integer limit, @Parameter(description="simple search (optional). Example `city:berlin`. Additional information of the https://opensearch.org/docs/latest/query-dsl/full-text/query-string/[Lucene Query String Syntax].") @QueryParam(value="query") String query, @Parameter(description="complex filter format like done from the monitor endpoint (optional). Example: `[{\"property\":\"processid\",\"operator\":\"gte\",\"value\":1000,\"source\":\"raw\",\"invert\":false}]`") @QueryParam(value="filter") String filter, @Parameter(description="determination by which field the entries should be sorted (optional). Format: fieldname\\|[ASC\\|DESC]. Example: `processid\\|DESC`. Multiple sorting instructions can be specified comma separated.") @QueryParam(value="sort") String sort, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("getItems storeId={}, timezoneOffset={}, timezoneName={}, start={}, limit={}, query={}, filter={}, sort={}", (Object)storeId, (Object)timezoneOffset, (Object)timezoneName, (Object)start, (Object)limit, (Object)query, (Object)filter, (Object)sort);
        try {
            String timeZoneId = TimeZoneUtil.evalTimeZoneId(timezoneOffset, timezoneName);
            StoreItems storeItems = this.storageServiceTracker.getService().getItems(storeId, start, limit, query, filter, sort, timeZoneId, userSession);
            return Response.ok((Object)storeItems, (String)"application/json").build();
        }
        catch (StoreNotFoundException ex) {
            LOGGER.info("Returning empty store items, because the store with the id '{}' does not exist at the moment (no views created from the frontend).", (Object)storeId);
            StoreItems storeItems = new StoreItems(storeId, start, limit);
            return Response.ok((Object)storeItems, (String)"application/json").build();
        }
        catch (Exception e) {
            LOGGER.error("get store items failed", (Throwable)e);
            return ErrorResponse.forException(e).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/store/{storeId}/{itemId}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="No access rights"), @ApiResponse(responseCode="404", description="Missing resource:\n\n* OpenSearch service not found\n* Store not found\n* Store item not found\n"), @ApiResponse(responseCode="500", description="Something went wrong while accessing OpenSearch")})
    @OperationDescription(summary="Get a specific store item from the OpenSearch index `bpc-store-<storeId>`.", description="Get a specific store item from the OpenSearch index `bpc-store-<storeId>`.")
    @ReturnDescription(value="The requested store item as JSON")
    public Response getItem(@Parameter(description="the ID of the store to get the data from") @PathParam(value="storeId") String storeId, @Parameter(description="the ID of the item") @PathParam(value="itemId") String itemId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("getItem storeId={}, itemId={}", (Object)storeId, (Object)itemId);
        try {
            StoreItem storeItem = this.storageServiceTracker.getService().getItem(storeId, itemId, userSession);
            return Response.ok((Object)storeItem, (String)"application/json").build();
        }
        catch (Exception e) {
            LOGGER.error("get store item failed", (Throwable)e);
            return ErrorResponse.forException(e).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @OperationDescription(summary="Creates a new store item.", description="Creates a new store item.\nWrites the provided store item data to the OpenSearch index `bpc-store-<storeId>`.\nIt uses a new ID for the store item and sets this also in the given store item data.\nNot well known elements on root level are automatically saved to the field 'customFields' to avoid OpenSearch mapping problems.\n\n.all fields example\n[source,json]\n----\n{\n   \"id\": \"1f697af5-c147-3d94-c529-e06f3f15bb87\",\n   \"moduleId\": \"monitor\",\n   \"moduleInstanceId\": \"audit_log\",\n   \"name\": \"data_view\",\n   \"value\": {\n       \"foo\": \"bar\"\n   },\n   \"favorite\": true,\n   \"readRestriction\" : {\n       \"user\": \"hans_schmidt\",\n       \"organisations\": [ \"DEFAULT\" ],\n       \"roles\": [ \"expert\", \"advanced\", \"beginner\" ],\n       \"rights\": [ \"loadModule_monitor\" ]\n   },\n   \"writeRestriction\" : {\n       \"user\": \"hans_schmidt\",\n       \"organisations\": [ \"DEFAULT\" ],\n       \"roles\": [ \"expert\" ],\n       \"rights\": [ \"loadModule_monitor\" ]\n   },\n   \"customFields\": {\n       \"foo\": \"bar\"\n   }\n}\n----\n\n**Fields**\n\n`id` (irrelevant) :: ID of the store item. A new random UUID gets set instead.\n`moduleId` (optional) :: The ID of the module the store item belongs to. Can be used as a filter value while getting items.\n`moduleInstanceId` (optional) :: The ID of the module instance the store item belongs to. Can be used as a filter value while getting items.\n`name` (optional) :: The name of the store item (be creative). Can be used as a filter value while getting items.\n`value` (required) :: The actual value/content/data of the store item.\n`favorite` (optional) :: To flag the store item as a favorite. Defaults to false.\n`readRestriction` (required) :: The read restrictions. Define who can read this item. At least one of the sub elements should be set.\n`readRestriction.user` (optional) :: Only this username has read access to this store item. When set the other fields 'organizations', 'roles' and 'rights' are not saved.\n`readRestriction.organisations` (optional) :: Anyone with one of these organizations has read access to this store item.\n`readRestriction.roles` (optional) :: Anyone with one of these roles has read access to this store item.\n`readRestriction.rights` (optional) :: Anyone with one of these rights has read access to this store item.\n`writeRestriction` (required) :: The write restrictions. Define who can update and delete this item. At least one of the sub elements should be set.\n`writeRestriction.user` (optional) :: Only this username has write access to this store item. When set the other fields 'organizations', 'roles' and 'rights' are not saved.\n`writeRestriction.organisations` (optional) :: Anyone with one of these organizations has write access to this store item.\n`writeRestriction.roles` (optional) :: Anyone with one of these roles has write access to this store item.\n`writeRestriction.rights` (optional) :: Anyone with one of these rights has write access to this store item.\n`customFields` (optional) :: Values that do not fit into the 'value' field.\n")
    @ReturnDescription(value="The ID of the created store item")
    @POST
    @Path(value="/store/{storeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Missing resource:\n\n* OpenSearch service not found\n* Store not found\n"), @ApiResponse(responseCode="406", description="Mandatory fields missing"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* Store could not be created\n* Problem with the given JSON\n* Something went wrong while accessing OpenSearch\n")})
    public Response createItem(@Parameter(description="the ID of the store") @PathParam(value="storeId") String storeId, Map<String, Object> jsonObject, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("createItem storeId={}", (Object)storeId);
        try {
            String itemId = UUIDGenerator.randomUUID();
            StoreItem storeItem = StoreItemFactory.create(itemId, jsonObject);
            this.storageServiceTracker.getService().createItem(storeId, storeItem, userSession);
            return Response.ok((Object)itemId).build();
        }
        catch (Exception ex) {
            LOGGER.error("Creating store item failed", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @OperationDescription(summary="Creates or updates a store item.", description="Creates or updates a store item.\nWrites the provided store item data in the body to the OpenSearch index `bpc-store-<storeId>`.\nAn existing store item gets updated and a not existing one gets created.\nNot well known elements on root level are automatically saved to the field 'customFields' to avoid OpenSearch mapping problems.\n\n.all fields example\n[source,json]\n----\n{\n   \"id\": \"1f697af5-c147-3d94-c529-e06f3f15bb87\",\n   \"moduleId\": \"monitor\",\n   \"moduleInstanceId\": \"audit_log\",\n   \"name\": \"data_view\",\n   \"value\": {\n       \"foo\": \"bar\"\n   },\n   \"favorite\": true,\n   \"readRestriction\" : {\n       \"user\": \"hans_schmidt\",\n       \"organisations\": [ \"DEFAULT\" ],\n       \"roles\": [ \"expert\", \"advanced\", \"beginner\" ],\n       \"rights\": [ \"loadModule_monitor\" ]\n   },\n   \"writeRestriction\" : {\n       \"user\": \"hans_schmidt\",\n       \"organisations\": [ \"DEFAULT\" ],\n       \"roles\": [ \"expert\" ],\n       \"rights\": [ \"loadModule_monitor\" ]\n   },\n   \"customFields\": {\n       \"foo\": \"bar\"\n   }\n}\n----\n\n**Fields**\n\n`id` (irrelevant) :: ID of the store item. The path parameter get set in the given document instead.\n`moduleId` (optional) :: The ID of the module the store item belongs to. Can be used as a filter value while getting items.\n`moduleInstanceId` (optional) :: The ID of the module instance the store item belongs to. Can be used as a filter value while getting items.\n`name` (optional) :: The name of the store item (be creative). Can be used as a filter value while getting items.\n`value` (required) :: The actual value/content/data of the store item.\n`favorite` (optional) :: To flag the store item as a favorite. Defaults to false.\n`readRestriction` (required) :: The read restrictions. Define who can read this item. At least one of the sub elements should be set.\n`readRestriction.user` (optional) :: Only this username has read access to this store item. When set the other fields 'organisations', 'roles' and 'rights' are not saved.\n`readRestriction.organisations` (optional) :: Anyone with one of these organisations has read access to this store item.\n`readRestriction.roles` (optional) :: Anyone with one of these roles has read access to this store item.\n`readRestriction.rights` (optional) :: Anyone with one of these rights has read access to this store item.\n`writeRestriction` (required) :: The write restrictions. Define who can update and delete this item. At least one of the sub elements should be set.\n`writeRestriction.user` (optional) :: Only this username has write access to this store item. When set the other fields 'organisations', 'roles' and 'rights' are not saved.\n`writeRestriction.organisations` (optional) :: Anyone with one of these organisations has write access to this store item.\n`writeRestriction.roles` (optional) :: Anyone with one of these roles has write access to this store item.\n`writeRestriction.rights` (optional) :: Anyone with one of these rights has write access to this store item.\n`customFields` (optional) :: Values that do not fit into the 'value' field.\n")
    @POST
    @Path(value="/store/{storeId}/{itemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Access rights not sufficient to update the store item"), @ApiResponse(responseCode="404", description="Missing resource:\n\n* OpenSearch service not found\n* Store not found\n"), @ApiResponse(responseCode="406", description="Mandatory fields missing"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* Store could not be created\n* Problem with the given JSON\n* Something went wrong while accessing OpenSearch\n")})
    public Response updateOrCreateItem(@Parameter(description="the ID of the store") @PathParam(value="storeId") String storeId, @Parameter(description="the ID of the item") @PathParam(value="itemId") String itemId, Map<String, Object> jsonObject, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("updateOrCreateItem storeId={}, itemId={}", (Object)storeId, (Object)itemId);
        try {
            StoreItem storeItem = StoreItemFactory.create(itemId, jsonObject);
            this.storageServiceTracker.getService().updateOrCreateItem(storeId, storeItem, userSession);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("updating or creating store item failed", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/store/{storeId}/{itemId}")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Access rights not sufficient to delete the store item"), @ApiResponse(responseCode="404", description="Missing resource:\n\n* OpenSearch service not found\n* Store not found\n* Store item not found\n"), @ApiResponse(responseCode="500", description="Something went wrong while accessing OpenSearch")})
    @OperationDescription(summary="Deletes a specific store item from OpenSearch.", description="Deletes a specific store item from the OpenSearch index `bpc-store-<storeId>`.")
    public Response deleteItem(@Parameter(description="the ID of the store") @PathParam(value="storeId") String storeId, @Parameter(description="the ID of the item to delete") @PathParam(value="itemId") String itemId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.info("deleteItem storeId={}, itemId={}", (Object)storeId, (Object)itemId);
        try {
            this.storageServiceTracker.getService().deleteItem(storeId, itemId, userSession);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("delete store item failed", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

