/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.utils;

import de.virtimo.bpc.core.utils.RestWebServiceClientInitException;
import de.virtimo.bpc.util.BpcTrustStore;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestWebServiceClientFactory {
    private static final Logger LOGGER = LogManager.getLogger(RestWebServiceClientFactory.class);

    public static Client newClient(boolean allowUntrustedConnections) throws RestWebServiceClientInitException {
        LOGGER.info("newClient allowUntrustedConnections={}", (Object)allowUntrustedConnections);
        try {
            if (allowUntrustedConnections) {
                X509TrustManager trustAllCertsTrustManager = BpcTrustStore.getInstance().getTrustAllCertsTrustManager();
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{trustAllCertsTrustManager}, new SecureRandom());
                HostnameVerifier allowAll = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
                return ClientBuilder.newBuilder().sslContext(sslContext).hostnameVerifier(allowAll).build();
            }
            X509TrustManager bpcTrustManager = BpcTrustStore.getInstance().getBpcTrustManager();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{bpcTrustManager}, new SecureRandom());
            return ClientBuilder.newBuilder().sslContext(sslContext).build();
        }
        catch (Exception ex) {
            throw new RestWebServiceClientInitException(ex);
        }
    }
}

