/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.utils;

import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.auth.UserSession;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;

public class StoragePersistenceQueryUtil {
    private static final Logger LOGGER = LogManager.getLogger(StoragePersistenceQueryUtil.class);

    private StoragePersistenceQueryUtil() {
    }

    public static QueryBuilder getQueryBuilderForSession(UserSession userSession) {
        LOGGER.info("getQueryBuilderForSession userSession=...");
        BoolQueryBuilder sessionQuery = QueryBuilders.boolQuery();
        if (userSession.hasRole("bpcadmin")) {
            BoolQueryBuilder userQuery = QueryBuilders.boolQuery();
            userQuery.must(QueryBuilders.termQuery("readRestriction.user", userSession.getLoginName()));
            sessionQuery.should(userQuery);
            BoolQueryBuilder notExistingUserQuery = QueryBuilders.boolQuery();
            notExistingUserQuery.mustNot(QueryBuilders.existsQuery("readRestriction.user"));
            sessionQuery.should(notExistingUserQuery);
        } else {
            List<Right> rights;
            List<Role> roles;
            BoolQueryBuilder userQuery = QueryBuilders.boolQuery();
            userQuery.must(QueryBuilders.termQuery("readRestriction.user", userSession.getLoginName()));
            sessionQuery.should(userQuery);
            List<Organisation> organisations = userSession.getOrganisations();
            if (!organisations.isEmpty()) {
                BoolQueryBuilder organisationsQuery = QueryBuilders.boolQuery();
                for (Organisation organisation : organisations) {
                    organisationsQuery.should(QueryBuilders.termQuery("readRestriction.organisations", organisation.getName()));
                }
                sessionQuery.should(organisationsQuery);
            }
            if (!(roles = userSession.getRoles()).isEmpty()) {
                BoolQueryBuilder rolesQuery = QueryBuilders.boolQuery();
                for (Role role : roles) {
                    rolesQuery.should(QueryBuilders.termQuery("readRestriction.roles", role.getName()));
                }
                sessionQuery.should(rolesQuery);
            }
            if (!(rights = userSession.getRights()).isEmpty()) {
                BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                for (Right right : rights) {
                    boolQueryBuilder.should(QueryBuilders.termQuery("readRestriction.rights", right.getName()));
                }
                sessionQuery.should(boolQueryBuilder);
            }
        }
        return sessionQuery;
    }
}

