/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.flow;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.action.ActionPayload;
import de.virtimo.bpc.api.action.ActionResult;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.HttpProxyException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ActionService;
import de.virtimo.bpc.api.service.FlowService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class FlowActionServiceImpl
implements ActionService,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(FlowActionServiceImpl.class);
    private final BundleContext bundleContext;
    private final BpcServicesTracker<FlowService> flowServiceTracker;

    public FlowActionServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.flowServiceTracker = new BpcServicesTracker<FlowService>(bundleContext, FlowService.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ActionResult startAction(String actionIdentifier, String bpcUrl, UserSession userSession, ActionPayload payload, HttpHeaders headers) throws ServiceNotFoundException, JsonProcessingException, ModuleNotFoundException, ModuleInstanceNotFoundException, HttpProxyException {
        String flowInstanceId = this.extractFromUrl(bpcUrl, ExtractionMode.INSTANCE_ID);
        String targetPath = this.extractFromUrl(bpcUrl, ExtractionMode.REMAINING_PATH);
        ObjectMapper objectMapper = new ObjectMapper();
        byte[] body = objectMapper.writeValueAsBytes((Object)payload);
        try (Response response = this.flowServiceTracker.getService().doPost(flowInstanceId, targetPath, null, null, headers, userSession, body);){
            String msg;
            Map json;
            int status = response.getStatus();
            MediaType contentType = response.getMediaType();
            if (status >= 400 && contentType != null && !contentType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
                String errorBodyAsString = "Could not read error body.";
                if (response.hasEntity()) {
                    try {
                        InputStream inputStream = (InputStream)response.getEntity();
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                            errorBodyAsString = reader.lines().collect(Collectors.joining("\n"));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to manually read response body as string, even after initial failure.", (Throwable)e);
                    }
                }
                LOGGER.error("Downstream service returned an error. Body: {}", (Object)errorBodyAsString);
                ActionResult e = ActionResult.failure(errorBodyAsString);
                return e;
            }
            try {
                json = (Map)objectMapper.readValue((InputStream)response.getEntity(), Map.class);
            }
            catch (IOException | ProcessingException e) {
                LOGGER.error("Failed to parse downstream response as JSON, status was: {}", (Object)status, (Object)e);
                ActionResult actionResult = ActionResult.failure("Received an invalid or non-JSON response from the downstream service.");
                if (response == null) return actionResult;
                response.close();
                return actionResult;
            }
            String string = json.get("message") != null ? json.get("message").toString() : (msg = json.get("msg") != null ? json.get("msg").toString() : "");
            if (status >= 200 && status < 300) {
                ActionResult actionResult = ActionResult.success(msg, json);
                return actionResult;
            }
            ActionResult actionResult = ActionResult.failure(msg);
            return actionResult;
        }
        catch (Exception e) {
            LOGGER.error("An unexpected exception occurred while calling the downstream service.", (Throwable)e);
            return ActionResult.failure("An unexpected error occurred while processing the action: " + e.getMessage());
        }
    }

    @Override
    public ActionResult stopAction(String referenceId, UserSession userSession, JsonNode payload) {
        return null;
    }

    private String extractFromUrl(String bpcUrl, ExtractionMode mode) {
        if (bpcUrl == null || bpcUrl.isBlank()) {
            throw new IllegalArgumentException("Missing bpcUrl.");
        }
        Pattern pattern = Pattern.compile("bpc://[^/]+/([^/]+)(?:/(.*))?");
        Matcher matcher = pattern.matcher(bpcUrl);
        if (matcher.find()) {
            switch (mode.ordinal()) {
                case 0: {
                    return matcher.group(1);
                }
                case 1: {
                    return matcher.group(2) != null ? matcher.group(2) : "";
                }
            }
            throw new IllegalArgumentException("Unsupported ExtractionMode: " + String.valueOf((Object)mode));
        }
        throw new IllegalArgumentException("Invalid bpcUrl: " + bpcUrl);
    }

    private static enum ExtractionMode {
        INSTANCE_ID,
        REMAINING_PATH;

    }
}

