/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.flow;

import de.virtimo.bpc.core.httpproxy.HttpProxyCallConfig;
import de.virtimo.bpc.flow.FlowModuleInstance;
import de.virtimo.bpc.util.StringUtil;
import java.util.List;
import java.util.Map;

public class HttpProxyCallConfigFromFlowInstance
implements HttpProxyCallConfig {
    private final FlowModuleInstance flowInstance;
    private final Map<String, String> additionalHttpHeaders;

    public HttpProxyCallConfigFromFlowInstance(FlowModuleInstance flowInstance) {
        this.flowInstance = flowInstance;
        this.additionalHttpHeaders = flowInstance.getConfiguration().getSettingValue("additionalHttpHeaders").asMap();
    }

    @Override
    public String getBaseUrl() {
        return this.flowInstance.getConfiguration().getSettingValue("connectionBaseUrl").asString();
    }

    @Override
    public boolean isBasicAuthEnabled() {
        return !StringUtil.isNullOrEmpty(this.getBasicAuthUsername()) && !StringUtil.isNullOrEmpty(this.getBasicAuthPassword());
    }

    @Override
    public String getBasicAuthUsername() {
        return this.flowInstance.getConfiguration().getSettingValue("connectionUsername").asString();
    }

    @Override
    public String getBasicAuthPassword() {
        return this.flowInstance.getConfiguration().getSettingValue("connectionPassword").asString();
    }

    @Override
    public long getTimeout() {
        return this.flowInstance.getConfiguration().getSettingValue("connectionTimeout").asLong(-1L);
    }

    @Override
    public String getProxyServer() {
        return this.flowInstance.getConfiguration().getSettingValue("proxyServer").asString();
    }

    @Override
    public Integer getProxyServerPort() {
        return this.flowInstance.getConfiguration().getSettingValue("proxyServerPort").asInt(80);
    }

    @Override
    public boolean isAllowUntrustedConnectionsEnabled() {
        return this.flowInstance.getConfiguration().getSettingValue("allowUntrustedConnections").asBoolean(false);
    }

    @Override
    public boolean isInjectSessionJwtEnabled() {
        return this.flowInstance.getConfiguration().getSettingValue("injectSessionJwt").asBoolean(false);
    }

    @Override
    public boolean isSendSessionIdEnabled() {
        return this.flowInstance.getConfiguration().getSettingValue("sendSessionId").asBoolean(false);
    }

    @Override
    public List getHttpHeaderFilters() {
        return this.flowInstance.getConfiguration().getSettingValue("httpHeaderFilter").asList(null);
    }

    @Override
    public Map<String, String> getAdditionalHttpHeaders() {
        return this.additionalHttpHeaders;
    }

    @Override
    public void addAdditionalHttpHeader(String httpHeaderName, String httpHeaderValue) {
        this.additionalHttpHeaders.put(httpHeaderName, httpHeaderValue);
    }
}

