/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.jaxrs;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.apikey.APIKeyException;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.IdentityProviderException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.message.Message;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class UserSessionProvider
implements ContextProvider<UserSession> {
    private static final Logger LOGGER = LogManager.getLogger(UserSessionProvider.class);

    public UserSession createContext(Message message) {
        LOGGER.debug("createContext message={}", (Object)message);
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(bundleContext, ClientSessionManager.class);
        try {
            HttpServletRequest servletRequest = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
            UserSession userSession = clientSessionManagerTracker.getService().getUserSession(servletRequest);
            clientSessionManagerTracker.close();
            return userSession;
        }
        catch (Throwable throwable) {
            try {
                try {
                    clientSessionManagerTracker.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (APIKeyException | IdentityProviderException | ServiceNotFoundException ex) {
                LOGGER.warn("Failed to get the user session: {}", (Object)ex.getMessage());
                return null;
            }
        }
    }
}

