/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice;

import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.util.StringUtil;
import java.util.Map;

public class LogServiceFieldTypeMappings {
    private final Map<String, Object> fieldTypeMappings = JsonDefaultsUtil.loadJsonFileAsMap("defaults/logservice/field_type_mappings.json");

    public boolean isKnownFieldType(String logServiceFieldType) {
        if (StringUtil.isNullOrEmpty(logServiceFieldType)) {
            return false;
        }
        return this.getFieldTypeMapping(logServiceFieldType) != null;
    }

    private Map<String, Object> getFieldTypeMapping(String logServiceFieldType) {
        return (Map)this.fieldTypeMappings.get(logServiceFieldType.toLowerCase());
    }

    public Map<String, Object> getOpenSearchMapping(String logServiceFieldType) {
        Map<String, Object> fieldTypeMapping = this.getFieldTypeMapping(logServiceFieldType);
        Map openSearchMapping = (Map)fieldTypeMapping.get("opensearch");
        return openSearchMapping;
    }

    public Map<String, Object> getJsonSchemaMapping(String logServiceFieldType) {
        Map<String, Object> fieldTypeMapping = this.getFieldTypeMapping(logServiceFieldType);
        Map jsonSchemaMapping = (Map)fieldTypeMapping.get("json_schema");
        return jsonSchemaMapping;
    }
}

