/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import de.virtimo.bpc.api.AbstractSettingUpdatedEventHandler;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.ItemRestriction;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.LogServiceSettingsException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.ItemRestrictionFactory;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.db.DatabaseTableDataCache;
import de.virtimo.bpc.logservice.jsonschema.LogDataJsonSchema;
import de.virtimo.bpc.logservice.jsonschema.LogDataJsonSchemaVariants;
import de.virtimo.bpc.module.AbstractModuleInstance;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ObjectMapperPool;
import de.virtimo.bpc.util.StringUtil;
import java.beans.PropertyChangeEvent;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class LogServiceModuleInstance
extends AbstractModuleInstance {
    private static final Logger LOGGER = LogManager.getLogger(LogServiceModuleInstance.class);
    private final EventRegistration eventRegistration;
    public static final String SETTING_ENABLED = "enabled";
    public static final String SETTING_OPENSEARCH_LOGGING_ENABLED = "openSearchLoggingEnabled";
    public static final String SETTING_OPENSEARCH_PARENT_INDEX = "openSearchParentIndex";
    public static final String SETTING_OPENSEARCH_CHILD_INDEX = "openSearchChildIndex";
    public static final String SETTING_RDMS_LOGGING_ENABLED = "rdmsLoggingEnabled";
    public static final String SETTING_JSON_SCHEMA_VALIDATION_MODE = "jsonSchemaValidation";
    public static final String SETTING_RDMS_DATA_SOURCE_NAME = "rdmsDataSourceName";
    public static final String SETTING_RDMS_TIME_ZONE = "rdmsTimeZone";
    public static final String SETTING_RDMS_PARENT_TABLE = "rdmsParentTable";
    public static final String SETTING_RDMS_CHILD_TABLE = "rdmsChildTable";
    public static final String SETTING_PARENT_KEY_FIELDS = "parentKeyFields";
    public static final String SETTING_CHILD_KEY_FIELDS = "childKeyFields";
    public static final String SETTING_PARENT_FIELDS = "parentFields";
    public static final String SETTING_CHILD_FIELDS = "childFields";
    public static final String SETTING_JOINS = "joins";
    public static final String SETTING_FILE_STORAGE_UPLOAD_ENABLED = "filestorageUploadEnabled";
    public static final String SETTING_FILE_STORAGE_BACKEND_CONNECTION_ID = "filestorageBackendConnection";
    public static final String SETTING_FILE_STORAGE_BUCKET = "filestorageBucket";
    public static final String SETTING_FILE_STORAGE_READ_RESTRICTION = "filestorageReadRestriction";
    public static final String SETTING_FILE_STORAGE_WRITE_RESTRICTION = "filestorageWriteRestriction";
    private final DatabaseTableDataCache databaseTableDataCache;
    private LookupJoins lookupJoins = null;
    private final Object JSON_SCHEMA_VARIANTS_LOCK = new Object();
    private LogDataJsonSchemaVariants logDataJsonSchemaVariants = null;

    public LogServiceModuleInstance(InstantiableModule pm, ModuleConfiguration mc, String instanceId) {
        super(pm, mc, instanceId);
        this.databaseTableDataCache = new DatabaseTableDataCache();
        BundleContext bundleContext = this.getModuleBundle().getBundleContext();
        this.eventRegistration = new EventRegistration(bundleContext);
        BpcBaseUrlOrPathUpdatedEventHandler bpcBaseUrlOrPathUpdatedEventHandler = new BpcBaseUrlOrPathUpdatedEventHandler();
        this.eventRegistration.forModuleUpdatedEvents("_core", "bpcBaseUrl", bpcBaseUrlOrPathUpdatedEventHandler);
        this.eventRegistration.forModuleUpdatedEvents("_core", "clientPath", bpcBaseUrlOrPathUpdatedEventHandler);
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
        this.eventRegistration.unregisterAllEventHandler();
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LogServiceModule logServiceModule;
        super.propertyChange(evt);
        if (!(evt.getSource() instanceof ModuleConfiguration)) {
            return;
        }
        if (SETTING_OPENSEARCH_PARENT_INDEX.equalsIgnoreCase(evt.getPropertyName()) || SETTING_OPENSEARCH_CHILD_INDEX.equalsIgnoreCase(evt.getPropertyName())) {
            LOGGER.info("{}: '{}' setting changed: restarting the backup jobs", (Object)this.getModuleId(), (Object)evt.getPropertyName());
            InstantiableModule parentModule = this.getParentModule();
            if (parentModule instanceof LogServiceModule) {
                LogServiceModule logServiceModule2 = (LogServiceModule)parentModule;
                logServiceModule2.restartBackupJob(this);
            }
        }
        if (SETTING_RDMS_DATA_SOURCE_NAME.equalsIgnoreCase(evt.getPropertyName()) || SETTING_RDMS_TIME_ZONE.equalsIgnoreCase(evt.getPropertyName()) || SETTING_RDMS_PARENT_TABLE.equalsIgnoreCase(evt.getPropertyName()) || SETTING_RDMS_CHILD_TABLE.equalsIgnoreCase(evt.getPropertyName())) {
            LOGGER.info("{}: '{}' setting changed: clearing the database table data cache", (Object)this.getModuleId(), (Object)evt.getPropertyName());
            this.databaseTableDataCache.clear();
        }
        if (SETTING_JOINS.equalsIgnoreCase(evt.getPropertyName())) {
            LOGGER.info("{}: '{}' setting changed: resetting the lookup joins", (Object)this.getModuleId(), (Object)SETTING_JOINS);
            this.lookupJoins = null;
        }
        if (SETTING_PARENT_FIELDS.equalsIgnoreCase(evt.getPropertyName()) || SETTING_CHILD_FIELDS.equalsIgnoreCase(evt.getPropertyName())) {
            LOGGER.info("{}: '{}' setting changed: updating the index mappings", (Object)this.getModuleId(), (Object)evt.getPropertyName());
            if (this.isEnabled() && this.isOpenSearchLoggingEnabled()) {
                logServiceModule = (LogServiceModule)this.getParentModule();
                logServiceModule.updateOpenSearchIndexMappings(this);
            }
        }
        if (SETTING_ENABLED.equalsIgnoreCase(evt.getPropertyName())) {
            LOGGER.info("{}: '{}' setting changed: updating the index mappings", (Object)this.getModuleId(), (Object)SETTING_ENABLED);
            if (this.isEnabled()) {
                logServiceModule = (LogServiceModule)this.getParentModule();
                logServiceModule.updateOpenSearchIndexMappings(this);
            }
        }
        if (SETTING_OPENSEARCH_LOGGING_ENABLED.equalsIgnoreCase(evt.getPropertyName())) {
            LOGGER.info("{}: '{}' setting changed: updating the index mappings", (Object)this.getModuleId(), (Object)SETTING_OPENSEARCH_LOGGING_ENABLED);
            if (this.isOpenSearchLoggingEnabled()) {
                logServiceModule = (LogServiceModule)this.getParentModule();
                logServiceModule.updateOpenSearchIndexMappings(this);
            }
        }
        if (SETTING_PARENT_KEY_FIELDS.equalsIgnoreCase(evt.getPropertyName()) || SETTING_CHILD_KEY_FIELDS.equalsIgnoreCase(evt.getPropertyName()) || SETTING_PARENT_FIELDS.equalsIgnoreCase(evt.getPropertyName()) || SETTING_CHILD_FIELDS.equalsIgnoreCase(evt.getPropertyName())) {
            LOGGER.info("{}: '{}' setting changed: resetting the JSON schema variants", (Object)this.getModuleId(), (Object)evt.getPropertyName());
            Object object = this.JSON_SCHEMA_VARIANTS_LOCK;
            synchronized (object) {
                this.logDataJsonSchemaVariants = null;
            }
        }
    }

    public DatabaseTableDataCache getDatabaseTableDataCache() {
        return this.databaseTableDataCache;
    }

    public boolean isEnabled() {
        return this.getConfiguration().getSettingValue(SETTING_ENABLED).asBoolean(true);
    }

    public boolean isOpenSearchLoggingEnabled() {
        return this.getConfiguration().getSettingValue(SETTING_OPENSEARCH_LOGGING_ENABLED).asBoolean(true);
    }

    public boolean isDatabaseLoggingEnabled() {
        return this.getConfiguration().getSettingValue(SETTING_RDMS_LOGGING_ENABLED).asBoolean(false);
    }

    public JsonSchemaValidationMode getJsonSchemaValidationMode() {
        return this.getConfiguration().getSettingValue(SETTING_JSON_SCHEMA_VALIDATION_MODE).asEnum(JsonSchemaValidationMode.class, JsonSchemaValidationMode.Off);
    }

    public String getOpenSearchParentIndex() {
        return this.getConfiguration().getSettingValue(SETTING_OPENSEARCH_PARENT_INDEX).asString(null);
    }

    public boolean hasOpenSearchChildProcessingEnabled() {
        return !StringUtil.isNullOrEmpty(this.getOpenSearchChildIndex());
    }

    public String getOpenSearchChildIndex() {
        return this.getConfiguration().getSettingValue(SETTING_OPENSEARCH_CHILD_INDEX).asString(null);
    }

    public String getRdmsDataSourceName() {
        return this.getConfiguration().getSettingValue(SETTING_RDMS_DATA_SOURCE_NAME).asString(null);
    }

    public ZoneId getRdmsTimeZoneAsZoneId() {
        String rdmsTimeZone = this.getRdmsTimeZone();
        return StringUtil.isNullOrEmpty(rdmsTimeZone) ? null : ZoneId.of(rdmsTimeZone);
    }

    public String getRdmsTimeZone() {
        return this.getConfiguration().getSettingValue(SETTING_RDMS_TIME_ZONE).asString(null);
    }

    public String getRdmsParentTable() {
        return this.getConfiguration().getSettingValue(SETTING_RDMS_PARENT_TABLE).asString(null);
    }

    public boolean hasRdmsChildProcessingEnabled() {
        return !StringUtil.isNullOrEmpty(this.getRdmsChildTable());
    }

    public String getRdmsChildTable() {
        return this.getConfiguration().getSettingValue(SETTING_RDMS_CHILD_TABLE).asString(null);
    }

    public KeysConfig getKeysConfig() {
        return new KeysConfig(this.getParentKeyFields(), this.getChildKeyFields());
    }

    public String getParentKeyFields() {
        return this.getConfiguration().getSettingValue(SETTING_PARENT_KEY_FIELDS).asString(null);
    }

    public String getChildKeyFields() {
        return this.getConfiguration().getSettingValue(SETTING_CHILD_KEY_FIELDS).asString(null);
    }

    public FieldsConfig getFieldsConfig() throws LogServiceSettingsException {
        return new FieldsConfig(this.getParentFields(), this.getChildFields());
    }

    public Map<String, FieldsConfig.Field> getParentFields() throws LogServiceSettingsException {
        return this.convertFieldsConfigSetting(SETTING_PARENT_FIELDS);
    }

    public Map<String, FieldsConfig.Field> getChildFields() throws LogServiceSettingsException {
        return this.convertFieldsConfigSetting(SETTING_CHILD_FIELDS);
    }

    private Map<String, FieldsConfig.Field> convertFieldsConfigSetting(String settingName) throws LogServiceSettingsException {
        Setting setting = this.getConfiguration().getSetting(settingName);
        if (setting == null) {
            throw new LogServiceSettingsException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "Converting setting to JSON failed. The requested setting '${setting}' is null.", MapUtil.mapOf("setting", settingName));
        }
        return LogServiceModuleInstance.convertFieldsSettingValue((Map)setting.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, FieldsConfig.Field> convertFieldsSettingValue(Map settingValue) {
        ObjectMapper objectMapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            MapType targetType = objectMapper.getTypeFactory().constructMapType(HashMap.class, String.class, FieldsConfig.Field.class);
            Map map = (Map)objectMapper.convertValue((Object)settingValue, (JavaType)targetType);
            return map;
        }
        finally {
            if (objectMapper != null) {
                ObjectMapperPool.getInstance().restore((Object)objectMapper);
            }
        }
    }

    public LookupJoins getLookupJoins() {
        LOGGER.debug("getLookupJoins");
        if (this.lookupJoins == null) {
            this.lookupJoins = new LookupJoins(this.getConfiguration().getSetting(SETTING_JOINS));
        }
        return this.lookupJoins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogDataJsonSchema getLogDataJsonSchema(boolean createStrictJsonSchema) throws LogServiceSettingsException {
        LOGGER.debug("getLogDataJsonSchema createStrictJsonSchema={}", (Object)createStrictJsonSchema);
        Object object = this.JSON_SCHEMA_VARIANTS_LOCK;
        synchronized (object) {
            if (this.logDataJsonSchemaVariants == null) {
                this.logDataJsonSchemaVariants = new LogDataJsonSchemaVariants(this.getBpcFrontendUrl(), this.getModuleId(), this.getKeysConfig(), this.getFieldsConfig());
            }
            return this.logDataJsonSchemaVariants.get(createStrictJsonSchema);
        }
    }

    public boolean isFileStorageUploadEnabled() {
        return this.getConfiguration().getSettingValue(SETTING_FILE_STORAGE_UPLOAD_ENABLED).asBoolean(false);
    }

    public String getFileStorageBackendConnectionId() {
        return this.getConfiguration().getSettingValue(SETTING_FILE_STORAGE_BACKEND_CONNECTION_ID).asString("");
    }

    public String getFileStorageBucket() {
        return this.getConfiguration().getSettingValue(SETTING_FILE_STORAGE_BUCKET).asString("");
    }

    public ItemRestriction getFileStorageReadRestriction() {
        Map readRestriction = this.getConfiguration().getSettingValue(SETTING_FILE_STORAGE_READ_RESTRICTION).asMap();
        return this.getFileStorageRestrictionFromMap(readRestriction);
    }

    public ItemRestriction getFileStorageWriteRestriction() {
        Map writeRestriction = this.getConfiguration().getSettingValue(SETTING_FILE_STORAGE_WRITE_RESTRICTION).asMap();
        return this.getFileStorageRestrictionFromMap(writeRestriction);
    }

    private ItemRestriction getFileStorageRestrictionFromMap(Map restrictionMap) {
        if (restrictionMap == null) {
            return null;
        }
        return ItemRestrictionFactory.create(restrictionMap);
    }

    private String getBpcFrontendUrl() {
        try {
            return this.getCoreModule().getBpcFrontendUrl();
        }
        catch (ModuleNotFoundException e) {
            return null;
        }
    }

    private CoreModule getCoreModule() throws ModuleNotFoundException {
        return (CoreModule)this.getModuleManager().getModuleById("_core");
    }

    private class BpcBaseUrlOrPathUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private BpcBaseUrlOrPathUpdatedEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processSetting(Setting setting) {
            LOGGER.info("{}: '{}' setting changed: resetting the JSON schema variants", (Object)LogServiceModuleInstance.this.getModuleId(), (Object)setting.getName());
            Object object = LogServiceModuleInstance.this.JSON_SCHEMA_VARIANTS_LOCK;
            synchronized (object) {
                LogServiceModuleInstance.this.logDataJsonSchemaVariants = null;
            }
        }
    }

    public static enum JsonSchemaValidationMode {
        Off,
        Regular,
        Strict;

    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class KeysConfig {
        public KeysConfigEntry parent;
        public KeysConfigEntry child;

        public KeysConfig() {
            this.parent = null;
            this.child = null;
        }

        public KeysConfig(String parentKeyFields, String childKeyFields) {
            this.parent = StringUtil.isNullOrEmpty(parentKeyFields) ? null : new KeysConfigEntry(parentKeyFields);
            this.child = StringUtil.isNullOrEmpty(childKeyFields) ? null : new KeysConfigEntry(childKeyFields);
        }

        public String toString() {
            return "KeysConfig{parent=" + String.valueOf(this.parent) + ", child=" + String.valueOf(this.child) + "}";
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class KeysConfigEntry {
            public String idColumns;

            public KeysConfigEntry(String idColumns) {
                this.idColumns = idColumns;
            }

            public List<String> getIdColumnsAsList() {
                return StringUtil.explode(this.idColumns, ",");
            }

            public String toString() {
                return "KeysConfigEntry{idColumns='" + this.idColumns + "'}";
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class FieldsConfig {
        public Map<String, Field> parent;
        public Map<String, Field> child;

        public FieldsConfig() {
            this.parent = null;
            this.child = null;
        }

        public FieldsConfig(Map<String, Field> parent, Map<String, Field> child) {
            this.parent = parent == null || parent.isEmpty() ? null : parent;
            this.child = child == null || child.isEmpty() ? null : child;
        }

        public static Map<String, Object> createDataContainerWithoutFieldsToSkip(Map<String, Object> data, Set<String> fieldsToSkip) {
            if (fieldsToSkip == null || fieldsToSkip.isEmpty()) {
                return data;
            }
            HashMap<String, Object> result = new HashMap<String, Object>(data);
            for (String fieldToSkip : fieldsToSkip) {
                result.remove(fieldToSkip);
            }
            return result;
        }

        public static Map<String, Object> createDataContainerWithReplacedSysdatePlaceholders(Map<String, Object> data, Set<String> timestampFieldsInLowerCase, ZonedDateTime currentDateTime, ZoneId targetTimeZoneId) {
            if (timestampFieldsInLowerCase == null || timestampFieldsInLowerCase.isEmpty()) {
                return data;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            data.forEach((key, value) -> {
                if (timestampFieldsInLowerCase.contains(key.toLowerCase()) && value instanceof String && "SYSDATE".equals(value)) {
                    ZonedDateTime targetDateTime = targetTimeZoneId == null ? currentDateTime : currentDateTime.withZoneSameInstant(targetTimeZoneId);
                    result.put((String)key, Timestamp.valueOf(targetDateTime.toLocalDateTime()));
                } else {
                    result.put((String)key, value);
                }
            });
            return result;
        }

        private static Set<String> getFieldsToSkip(Map<String, Field> container, SkipFieldChecker skipFieldChecker) {
            HashSet<String> result = null;
            if (container != null) {
                for (Map.Entry<String, Field> stringFieldEntry : container.entrySet()) {
                    String fieldName = stringFieldEntry.getKey();
                    Field field = stringFieldEntry.getValue();
                    if (!skipFieldChecker.skipField(field)) continue;
                    if (result == null) {
                        result = new HashSet<String>();
                    }
                    result.add(fieldName);
                }
            }
            return result;
        }

        public Set<String> getOpenSearchParentFieldsToSkip() {
            return FieldsConfig.getFieldsToSkip(this.parent, new SkipOpenSearchFieldChecker());
        }

        public Set<String> getOpenSearchChildFieldsToSkip() {
            return FieldsConfig.getFieldsToSkip(this.child, new SkipOpenSearchFieldChecker());
        }

        public Set<String> getDbParentFieldsToSkip() {
            return FieldsConfig.getFieldsToSkip(this.parent, new SkipDbFieldChecker());
        }

        public Set<String> getDbChildFieldsToSkip() {
            return FieldsConfig.getFieldsToSkip(this.child, new SkipDbFieldChecker());
        }

        private static Set<String> getTimestampFieldsInLowerCase(Map<String, Field> container) {
            HashSet<String> result = null;
            if (container != null) {
                for (Map.Entry<String, Field> stringFieldEntry : container.entrySet()) {
                    String fieldName = stringFieldEntry.getKey();
                    Field field = stringFieldEntry.getValue();
                    if (!"timestamp".equalsIgnoreCase(field.type)) continue;
                    if (result == null) {
                        result = new HashSet<String>();
                    }
                    result.add(fieldName.toLowerCase());
                }
            }
            return result;
        }

        public Set<String> getParentTimestampFieldsInLowerCase() {
            return FieldsConfig.getTimestampFieldsInLowerCase(this.parent);
        }

        public Set<String> getChildTimestampFieldsInLowerCase() {
            return FieldsConfig.getTimestampFieldsInLowerCase(this.child);
        }

        public String toString() {
            return "Fields{parent=" + String.valueOf(this.parent) + ", child=" + String.valueOf(this.child) + "}";
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class Field {
            public String type;
            public String dbFormat;
            public boolean skipOS;
            public boolean skipDB;

            public Field() {
            }

            public Field(String type) {
                this.type = type;
            }

            public String toString() {
                return "Field{type='" + this.type + "', dbFormat='" + this.dbFormat + "', skipOS=" + this.skipOS + ", skipDB=" + this.skipDB + "}";
            }
        }
    }

    private static class SkipDbFieldChecker
    implements SkipFieldChecker {
        private SkipDbFieldChecker() {
        }

        @Override
        public boolean skipField(FieldsConfig.Field field) {
            return field.skipDB;
        }
    }

    private static class SkipOpenSearchFieldChecker
    implements SkipFieldChecker {
        private SkipOpenSearchFieldChecker() {
        }

        @Override
        public boolean skipField(FieldsConfig.Field field) {
            return field.skipOS;
        }
    }

    private static interface SkipFieldChecker {
        public boolean skipField(FieldsConfig.Field var1);
    }
}

