/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice.db;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.exception.LogServiceException;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.logservice.db.DatabaseTableData;
import de.virtimo.bpc.util.MapUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatabaseTableDataCache {
    private static final Logger LOGGER = LogManager.getLogger(DatabaseTableDataCache.class);
    private Map<String, DatabaseTableData> databaseTableDataCache = new HashMap<String, DatabaseTableData>();

    private String createCacheKey(String dataSourceName, String tableName) {
        return dataSourceName + "---" + tableName;
    }

    public synchronized DatabaseTableData getDatabaseTableData(String dataSourceName, String tableName, Connection conn) throws LogServiceException {
        LOGGER.info("getDatabaseTableData dataSourceName={}, tableName={}, conn=...", (Object)dataSourceName, (Object)tableName);
        try {
            String parentCacheKey = this.createCacheKey(dataSourceName, tableName);
            DatabaseTableData databaseTableData = this.databaseTableDataCache.get(parentCacheKey);
            if (databaseTableData == null) {
                databaseTableData = new DatabaseTableData(conn, tableName);
                this.databaseTableDataCache.put(parentCacheKey, databaseTableData);
            }
            return databaseTableData;
        }
        catch (SQLException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_DB_GET_METADATA_FAILED, "Could not get the meta data of the database table '${tableName }'.", MapUtil.mapOf("tableName", tableName), (Throwable)ex);
        }
    }

    public synchronized void clear() {
        LOGGER.info("clear");
        this.databaseTableDataCache.clear();
    }
}

