/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice.opensearch;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.LogServiceException;
import de.virtimo.bpc.api.exception.LogServiceSettingsException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexMappingNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexCreateCallable;
import de.virtimo.bpc.api.opensearch.BpcIndexState;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcIndexMapping;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcQueryBuilder;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcSortBuilder;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.lookupjoins.LookupJoin;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.core.percolators.PercolatorsProcessorImpl;
import de.virtimo.bpc.core.replicator.OpenSearchRecordID;
import de.virtimo.bpc.logservice.ExternalReferenceData;
import de.virtimo.bpc.logservice.LogService;
import de.virtimo.bpc.logservice.LogServiceFieldTypeMappings;
import de.virtimo.bpc.logservice.LogServiceModule;
import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.logservice.resource.LogData;
import de.virtimo.bpc.logservice.resource.LogDataEntries;
import de.virtimo.bpc.util.ListUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.bulk.BulkProcessor;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.index.query.ConstantScoreQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortBuilder;

public class OpenSearchLogService
implements LogService {
    private static final Logger LOGGER = LogManager.getLogger(OpenSearchLogService.class);
    private final OpenSearchService oss;
    private final PercolatorsManager percolatorsManager;
    private final Map<String, Object> defaultIndexCreationSettings;
    private final List defaultDynamicTemplates;
    private static final Object PARENT_INDEX_LOCK = new Object();
    private static final Object CHILD_INDEX_LOCK = new Object();

    public OpenSearchLogService(OpenSearchService oss, PercolatorsManager percolatorsManager, Map<String, Object> defaultIndexCreationSettings, List defaultDynamicTemplates) {
        this.oss = oss;
        this.percolatorsManager = percolatorsManager;
        this.defaultIndexCreationSettings = defaultIndexCreationSettings;
        this.defaultDynamicTemplates = defaultDynamicTemplates;
    }

    private String createRecordId(List<String> idColumns, Map<String, Object> data) throws LogServiceException {
        LOGGER.debug("createRecordId idColumns={}, data=...", idColumns);
        TreeMap<String, Object> caseInsensitiveMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        caseInsensitiveMap.putAll(data);
        ArrayList<Object> idColumnValues = new ArrayList<Object>();
        for (String idColumn : idColumns) {
            Object value = caseInsensitiveMap.get(idColumn);
            if (value == null) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FIELD_MISSING, "Did not find the key field '${keyField}' in the log data entry: ${data}", MapUtil.mapOf("keyField", idColumn, "data", String.valueOf(caseInsensitiveMap)));
            }
            idColumnValues.add(value);
        }
        return OpenSearchRecordID.create(idColumnValues);
    }

    private Set<String> fetchAllChildIDsOfParents(String childIndexName, String parentKeyQueryField, Collection<String> parentIDs) throws OpenSearchRelatedException, OpenSearchIndexNotFoundException, OpenSearchIndexMappingNotFoundException {
        LOGGER.info("fetchAllChildIDsOfParents childIndexName={}, parentKeyQueryField={}, parentIDs=...", (Object)childIndexName, (Object)parentKeyQueryField);
        ConstantScoreQueryBuilder fetchChildIDsQuery = QueryBuilders.constantScoreQuery(QueryBuilders.termsQuery(parentKeyQueryField, parentIDs));
        SearchRequest fetchChildIDsRequest = new SearchRequest().indices(childIndexName).source(new SearchSourceBuilder().fetchSource(false).size(10000).query(fetchChildIDsQuery));
        HashSet<String> childIDs = new HashSet<String>();
        this.oss.search(fetchChildIDsRequest, searchHit -> {
            String childID = searchHit.getId();
            childIDs.add(childID);
        });
        return childIDs;
    }

    private List<Map<String, Object>> fetchAllChildDocumentsOfParents(String childIndexName, String parentKeyQueryField, Collection<String> parentIDs, List<SortBuilder> childSortBuilders) throws OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("fetchAllChildDocumentsOfParent childIndexName={}, parentKeyQueryField={}, parentIDs=..., childSortBuilders=...", (Object)childIndexName, (Object)parentKeyQueryField);
        ConstantScoreQueryBuilder fetchChildrenQuery = QueryBuilders.constantScoreQuery(QueryBuilders.termsQuery(parentKeyQueryField, parentIDs));
        SearchSourceBuilder ssb = new SearchSourceBuilder().size(100).query(fetchChildrenQuery);
        if (childSortBuilders != null) {
            for (SortBuilder childSortBuilder : childSortBuilders) {
                ssb.sort(childSortBuilder);
            }
        }
        SearchRequest fetchChildrenRequest = new SearchRequest().indices(childIndexName).source(ssb);
        ArrayList<Map<String, Object>> childDocuments = new ArrayList<Map<String, Object>>();
        this.oss.search(fetchChildrenRequest, searchHit -> {
            Map<String, Object> childDocument = searchHit.getSourceAsMap();
            childDocuments.add(childDocument);
        });
        return childDocuments;
    }

    private List<Map<String, Object>> fetchChildDocumentsOfParents(String childIndexName, String parentKeyQueryField, Collection<String> parentIDs, List<SortBuilder> childSortBuilders, String timeZoneId, String childQuery, String childFilter) throws OpenSearchRelatedException, OpenSearchIndexNotFoundException, OpenSearchIndexMappingNotFoundException {
        LOGGER.info("fetchChildDocumentsOfParents childIndexName={}, parentKeyQueryField={}, parentIDs=..., childSortBuilders=..., timeZoneId={}, childQuery={}, childFilter={}", (Object)childIndexName, (Object)parentKeyQueryField, (Object)timeZoneId, (Object)childQuery, (Object)childFilter);
        BpcIndexMapping childIndexMapping = new BpcIndexMapping(this.oss.getMappingMetaData(childIndexName));
        ConstantScoreQueryBuilder fetchDocsOnlyForSpecificParentsQuery = QueryBuilders.constantScoreQuery(QueryBuilders.termsQuery(parentKeyQueryField, parentIDs));
        QueryBuilder fetchChildrenQuery = new BpcQueryBuilder().addSkipPercolatorDocumentsQuery().addQueryBuilder(fetchDocsOnlyForSpecificParentsQuery).addStringBasedQuery(childQuery).addQueriesForFilters(childFilter, childIndexMapping, timeZoneId).buildAsBoolFilterQuery();
        SearchSourceBuilder ssb = new SearchSourceBuilder().size(100).query(fetchChildrenQuery);
        if (childSortBuilders != null) {
            for (SortBuilder childSortBuilder : childSortBuilders) {
                ssb.sort(childSortBuilder);
            }
        }
        SearchRequest fetchChildrenRequest = new SearchRequest().indices(childIndexName).source(ssb);
        ArrayList<Map<String, Object>> childDocuments = new ArrayList<Map<String, Object>>();
        this.oss.search(fetchChildrenRequest, searchHit -> {
            Map<String, Object> childDocument = searchHit.getSourceAsMap();
            childDocuments.add(childDocument);
        });
        return childDocuments;
    }

    private List<SortBuilder> createSortBuilders(String sortInstructions, List<String> keyFields, String keyFieldsDirection, BpcIndexMapping indexMapping) {
        if (!StringUtil.isNullOrEmpty(sortInstructions)) {
            return BpcSortBuilder.init(indexMapping).addSortFromCompactFormat(sortInstructions).build();
        }
        BpcSortBuilder bpcSortBuilder = BpcSortBuilder.init(indexMapping);
        if (keyFields != null) {
            for (String keyField : keyFields) {
                bpcSortBuilder.addSort(keyField, keyFieldsDirection);
            }
        }
        return bpcSortBuilder.build();
    }

    @Override
    public FutureTask<Exception> deleteData(LogServiceModuleInstance moduleInstance, String timeZoneId, String parentQuery, String parentFilter) throws LogServiceException {
        LOGGER.info("deleteData moduleInstance=..., timeZoneId={}, parentQuery={}, parentFilter={}", (Object)timeZoneId, (Object)parentQuery, (Object)parentFilter);
        try {
            String parentIndex = moduleInstance.getOpenSearchParentIndex();
            List<String> parentIDs = this.fetchParentIDs(parentIndex, parentQuery, parentFilter, timeZoneId);
            return this.deleteData(moduleInstance, parentIDs);
        }
        catch (OpenSearchIndexMappingNotFoundException | OpenSearchIndexNotFoundException | OpenSearchRelatedException | OpenSearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to delete OpenSearch data.", ex);
        }
    }

    private List<String> fetchParentIDs(String parentIndexName, String parentQuery, String parentFilter, String timeZoneId) throws OpenSearchIndexNotFoundException, OpenSearchRelatedException, OpenSearchIndexMappingNotFoundException {
        LOGGER.info("fetchParentIDs parentIndexName={}, parentQuery={}, parentFilter={}, timeZoneId={}", (Object)parentIndexName, (Object)parentQuery, (Object)parentFilter, (Object)timeZoneId);
        BpcIndexMapping parentIndexMapping = new BpcIndexMapping(this.oss.getMappingMetaData(parentIndexName));
        QueryBuilder fetchParentIDsQuery = new BpcQueryBuilder().addSkipPercolatorDocumentsQuery().addStringBasedQuery(parentQuery).addQueriesForFilters(parentFilter, parentIndexMapping, timeZoneId).buildAsBoolFilterQuery();
        SearchRequest fetchParentIDsRequest = new SearchRequest().indices(parentIndexName).source(new SearchSourceBuilder().fetchSource(false).size(10000).query(fetchParentIDsQuery));
        ArrayList<String> parentIDs = new ArrayList<String>();
        this.oss.search(fetchParentIDsRequest, searchHit -> {
            String parentID = searchHit.getId();
            parentIDs.add(parentID);
        });
        return parentIDs;
    }

    @Override
    public FutureTask<Exception> deleteData(LogServiceModuleInstance moduleInstance, List<String> parentIDs) throws LogServiceException {
        LOGGER.info("deleteData moduleInstance={}, parentIDs=...", (Object)moduleInstance);
        try {
            if (parentIDs == null || parentIDs.isEmpty()) {
                return null;
            }
            RestHighLevelClient osClient = this.oss.getClient();
            final String parentIndex = moduleInstance.getOpenSearchParentIndex();
            final String childIndex = moduleInstance.getOpenSearchChildIndex();
            LogServiceModuleInstance.KeysConfig keysConfig = moduleInstance.getKeysConfig();
            final boolean childProcessingEnabled = moduleInstance.hasOpenSearchChildProcessingEnabled();
            HashSet<String> openSearchParentRecordIDs = new HashSet<String>();
            for (String parentId : parentIDs) {
                String parentRecordId = OpenSearchRecordID.create(parentId);
                openSearchParentRecordIDs.add(parentRecordId);
            }
            HashSet<String> openSearchChildRecordIDs = new HashSet<String>();
            if (childProcessingEnabled) {
                BpcIndexMapping childIndexMapping = new BpcIndexMapping(this.oss.getMappingMetaData(childIndex));
                String parentKeyField = keysConfig.child.getIdColumnsAsList().get(0);
                String parentKeyQueryField = childIndexMapping.getPreferredQueryFieldForIDs(parentKeyField);
                int blockSize = 10000;
                int totalSize = parentIDs.size();
                for (int i = 0; i < totalSize; i += blockSize) {
                    Iterator subListOfParentIDs = parentIDs.subList(i, Math.min(i + blockSize, totalSize));
                    Set<String> childIDsOfParent = this.fetchAllChildIDsOfParents(childIndex, parentKeyQueryField, (Collection<String>)((Object)subListOfParentIDs));
                    openSearchChildRecordIDs.addAll(childIDsOfParent);
                }
            }
            PercolatorsProcessorImpl parentPercolatorsProcessor = null;
            Set<Percolator> parentPercolatorsFromIndex = this.percolatorsManager.getAllValidPercolatorsFromIndex(this.oss, parentIndex);
            parentPercolatorsProcessor = new PercolatorsProcessorImpl(this.oss, parentIndex, parentPercolatorsFromIndex);
            parentPercolatorsProcessor.keepDeletedDatabaseIDs(openSearchParentRecordIDs);
            parentPercolatorsProcessor.processForDeleted();
            PercolatorsProcessorImpl childPercolatorsProcessor = null;
            if (childProcessingEnabled) {
                Set<Percolator> childPercolatorsFromIndex = this.percolatorsManager.getAllValidPercolatorsFromIndex(this.oss, childIndex);
                childPercolatorsProcessor = new PercolatorsProcessorImpl(this.oss, childIndex, childPercolatorsFromIndex);
                childPercolatorsProcessor.keepDeletedDatabaseIDs(openSearchChildRecordIDs);
                childPercolatorsProcessor.processForDeleted();
            }
            final OpenSearchRelatedException[] bulkException = new OpenSearchRelatedException[1];
            BulkProcessor.Listener listener = new BulkProcessor.Listener(){

                @Override
                public void beforeBulk(long executionId, BulkRequest request) {
                }

                @Override
                public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                    if (response != null && response.hasFailures()) {
                        bulkException[0] = new OpenSearchRelatedException((ErrorCode)BpcErrorCode.OPENSEARCH_EXCEPTION, response.buildFailureMessage());
                    }
                }

                @Override
                public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                    if (failure != null) {
                        bulkException[0] = new OpenSearchRelatedException(failure);
                    }
                }
            };
            BulkProcessor bulkProcessor = BulkProcessor.builder((request, bulkListener) -> osClient.bulkAsync((BulkRequest)request, RequestOptions.DEFAULT, (ActionListener<BulkResponse>)bulkListener), listener).setBulkActions(10000).setBulkSize(new ByteSizeValue(25L, ByteSizeUnit.MB)).setFlushInterval(TimeValue.timeValueSeconds(5L)).setConcurrentRequests(1).build();
            for (String parentRecordId : openSearchParentRecordIDs) {
                bulkProcessor.add(new DeleteRequest(parentIndex).id(parentRecordId));
            }
            if (childProcessingEnabled) {
                for (String childRecordId : openSearchChildRecordIDs) {
                    bulkProcessor.add(new DeleteRequest(childIndex).id(childRecordId));
                }
            }
            bulkProcessor.awaitClose(15L, TimeUnit.MINUTES);
            if (bulkException[0] != null) {
                throw bulkException[0];
            }
            LOGGER.debug("OpenSearch call done");
            final PercolatorsProcessorImpl finalParentPercolatorsProcessor = parentPercolatorsProcessor;
            final PercolatorsProcessorImpl finalChildPercolatorsProcessor = childPercolatorsProcessor;
            return new FutureTask<Exception>(new Callable<Exception>(){

                @Override
                public Exception call() {
                    try {
                        OpenSearchLogService.this.percolatorsManager.informClientsAboutReplicatedData(OpenSearchLogService.this.oss, parentIndex, finalParentPercolatorsProcessor);
                        if (childProcessingEnabled) {
                            OpenSearchLogService.this.percolatorsManager.informClientsAboutReplicatedData(OpenSearchLogService.this.oss, childIndex, finalChildPercolatorsProcessor);
                        }
                        return null;
                    }
                    catch (Exception ex) {
                        LOGGER.error(ex.getMessage(), (Throwable)ex);
                        return ex;
                    }
                }
            });
        }
        catch (OpenSearchIndexMappingNotFoundException | OpenSearchIndexNotFoundException | OpenSearchRelatedException | InterruptedException | OpenSearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to delete OpenSearch data.", ex);
        }
    }

    @Override
    public FutureTask<Exception> deleteChildData(LogServiceModuleInstance moduleInstance, String parentId, String timeZoneId, String childQuery, String childFilter) throws LogServiceException {
        LOGGER.info("deleteChildData moduleInstance=..., parentId={}, timeZoneId={}, childQuery={}, childFilter={}", (Object)parentId, (Object)timeZoneId, (Object)childQuery, (Object)childFilter);
        try {
            String childIndex = moduleInstance.getOpenSearchChildIndex();
            LogServiceModuleInstance.KeysConfig keysConfig = moduleInstance.getKeysConfig();
            String parentKeyField = keysConfig.child.getIdColumnsAsList().get(0);
            Set<String> childRecordIDs = this.fetchChildRecordIDs(parentKeyField, parentId, childIndex, childQuery, childFilter, timeZoneId);
            return this.deleteChildData(moduleInstance, childRecordIDs);
        }
        catch (OpenSearchIndexMappingNotFoundException | OpenSearchIndexNotFoundException | OpenSearchRelatedException | OpenSearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to delete OpenSearch child entries.", ex);
        }
    }

    private Set<String> fetchChildRecordIDs(String parentKeyField, String parentId, String childIndexName, String childQuery, String childFilter, String timeZoneId) throws OpenSearchIndexNotFoundException, OpenSearchRelatedException, OpenSearchIndexMappingNotFoundException {
        LOGGER.info("fetchChildRecordIDs parentKeyField={}, parentId={}, childIndexName={}, childQuery={}, childFilter={}, timeZoneId={}", (Object)parentKeyField, (Object)parentId, (Object)childIndexName, (Object)childQuery, (Object)childFilter, (Object)timeZoneId);
        BpcIndexMapping childIndexMapping = new BpcIndexMapping(this.oss.getMappingMetaData(childIndexName));
        String parentKeyQueryField = childIndexMapping.getPreferredQueryFieldForIDs(parentKeyField);
        ConstantScoreQueryBuilder fetchChildIDsByParentIdQuery = QueryBuilders.constantScoreQuery(QueryBuilders.termsQuery(parentKeyQueryField, List.of(parentId)));
        QueryBuilder fetchParentIDsQuery = new BpcQueryBuilder().addSkipPercolatorDocumentsQuery().addQueryBuilder(fetchChildIDsByParentIdQuery).addStringBasedQuery(childQuery).addQueriesForFilters(childFilter, childIndexMapping, timeZoneId).buildAsBoolFilterQuery();
        SearchRequest fetchChildIDsRequest = new SearchRequest().indices(childIndexName).source(new SearchSourceBuilder().fetchSource(false).size(10000).query(fetchParentIDsQuery));
        HashSet<String> childRecordIDs = new HashSet<String>();
        this.oss.search(fetchChildIDsRequest, searchHit -> {
            String childRecordID = searchHit.getId();
            childRecordIDs.add(childRecordID);
        });
        return childRecordIDs;
    }

    @Override
    public FutureTask<Exception> deleteChildData(LogServiceModuleInstance moduleInstance, String parentId, List<String> childIDs) throws LogServiceException {
        LOGGER.info("deleteChildData moduleInstance={}, parentId={}, childIDs=...", (Object)moduleInstance, (Object)parentId);
        HashSet<String> childRecordIDs = new HashSet<String>();
        for (String childId : childIDs) {
            String childRecordId = OpenSearchRecordID.create(parentId, childId);
            childRecordIDs.add(childRecordId);
        }
        return this.deleteChildData(moduleInstance, childRecordIDs);
    }

    private FutureTask<Exception> deleteChildData(LogServiceModuleInstance moduleInstance, Set<String> childRecordIDs) throws LogServiceException {
        LOGGER.info("deleteChildData moduleInstance={}, childRecordIDs=...", (Object)moduleInstance);
        try {
            RestHighLevelClient osClient = this.oss.getClient();
            final String childIndex = moduleInstance.getOpenSearchChildIndex();
            if (!moduleInstance.hasOpenSearchChildProcessingEnabled()) {
                return null;
            }
            if (childRecordIDs == null || childRecordIDs.isEmpty()) {
                return null;
            }
            Set<Percolator> childPercolatorsFromIndex = this.percolatorsManager.getAllValidPercolatorsFromIndex(this.oss, childIndex);
            final PercolatorsProcessorImpl childPercolatorsProcessor = new PercolatorsProcessorImpl(this.oss, childIndex, childPercolatorsFromIndex);
            childPercolatorsProcessor.keepDeletedDatabaseIDs(childRecordIDs);
            childPercolatorsProcessor.processForDeleted();
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            for (String childRecordId : childRecordIDs) {
                bulkRequest.add(new DeleteRequest(childIndex).id(childRecordId));
            }
            BulkResponse bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            if (bulkResponse.hasFailures()) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_DELETE_FAILED, "Failed to delete log service data. OpenSearch error: ${error}", MapUtil.mapOf("error", bulkResponse.buildFailureMessage()));
            }
            LOGGER.debug("OpenSearch call done");
            return new FutureTask<Exception>(new Callable<Exception>(){

                @Override
                public Exception call() {
                    try {
                        OpenSearchLogService.this.percolatorsManager.informClientsAboutReplicatedData(OpenSearchLogService.this.oss, childIndex, childPercolatorsProcessor);
                        return null;
                    }
                    catch (Exception ex) {
                        LOGGER.error(ex.getMessage(), (Throwable)ex);
                        return ex;
                    }
                }
            });
        }
        catch (OpenSearchRelatedException | IOException | OpenSearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to delete OpenSearch data.", ex);
        }
    }

    @Override
    public FutureTask<Exception> deleteChildData(LogServiceModuleInstance moduleInstance, String timeZoneId, String childQuery, String childFilter) throws LogServiceException {
        LOGGER.info("deleteChildData moduleInstance=..., timeZoneId={}, childQuery={}, childFilter={}", (Object)timeZoneId, (Object)childQuery, (Object)childFilter);
        try {
            String childIndex = moduleInstance.getOpenSearchChildIndex();
            Set<String> childRecordIDs = this.fetchChildRecordIDs(childIndex, childQuery, childFilter, timeZoneId);
            return this.deleteChildData(moduleInstance, childRecordIDs);
        }
        catch (OpenSearchIndexMappingNotFoundException | OpenSearchIndexNotFoundException | OpenSearchRelatedException | OpenSearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to delete OpenSearch child entries.", ex);
        }
    }

    private Set<String> fetchChildRecordIDs(String childIndexName, String childQuery, String childFilter, String timeZoneId) throws OpenSearchIndexNotFoundException, OpenSearchRelatedException, OpenSearchIndexMappingNotFoundException {
        LOGGER.info("fetchChildRecordIDs childIndexName={}, childQuery={}, childFilter={}, timeZoneId={}", (Object)childIndexName, (Object)childQuery, (Object)childFilter, (Object)timeZoneId);
        BpcIndexMapping childIndexMapping = new BpcIndexMapping(this.oss.getMappingMetaData(childIndexName));
        QueryBuilder fetchChildIDsQuery = new BpcQueryBuilder().addSkipPercolatorDocumentsQuery().addStringBasedQuery(childQuery).addQueriesForFilters(childFilter, childIndexMapping, timeZoneId).buildAsBoolFilterQuery();
        SearchRequest fetchChildIDsRequest = new SearchRequest().indices(childIndexName).source(new SearchSourceBuilder().fetchSource(false).size(10000).query(fetchChildIDsQuery));
        HashSet<String> childRecordIDs = new HashSet<String>();
        this.oss.search(fetchChildIDsRequest, searchHit -> {
            String childRecordID = searchHit.getId();
            childRecordIDs.add(childRecordID);
        });
        return childRecordIDs;
    }

    public static Map<String, Object> fieldsAsOpenSearchMappingProperties(Map<String, LogServiceModuleInstance.FieldsConfig.Field> fields) {
        LOGGER.debug("fieldsAsOpenSearchMappingProperties fields={}", fields);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (fields != null && !fields.isEmpty()) {
            LogServiceFieldTypeMappings logServiceFieldTypeMappings = new LogServiceFieldTypeMappings();
            for (String fieldName : fields.keySet()) {
                LogServiceModuleInstance.FieldsConfig.Field field = fields.get(fieldName);
                if (field.skipOS || !logServiceFieldTypeMappings.isKnownFieldType(field.type)) continue;
                properties.put(fieldName, logServiceFieldTypeMappings.getOpenSearchMapping(field.type));
            }
        }
        properties.put("_percolator_query", MapUtil.mapOf("type", "percolator"));
        properties.put("externalReference", MapUtil.mapOf("type", "flat_object"));
        return properties;
    }

    private Map<String, Object> fieldsAsOpenSearchMapping(OpenSearchService oss, Map<String, LogServiceModuleInstance.FieldsConfig.Field> fields) {
        Map<String, Object> properties;
        LOGGER.debug("fieldsAsOpenSearchMapping oss=..., fields={}", fields);
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        if (this.defaultDynamicTemplates != null && !this.defaultDynamicTemplates.isEmpty()) {
            mapping.put("dynamic_templates", this.defaultDynamicTemplates);
        }
        if ((properties = OpenSearchLogService.fieldsAsOpenSearchMappingProperties(fields)) != null && !properties.isEmpty()) {
            mapping.put("properties", properties);
        }
        return mapping;
    }

    @Override
    public FutureTask<Exception> logData(LogServiceModuleInstance moduleInstance, ZonedDateTime currentDateTime, LogData logData) throws LogServiceException {
        return this.logData(moduleInstance, currentDateTime, logData, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureTask<Exception> logData(LogServiceModuleInstance moduleInstance, ZonedDateTime currentDateTime, LogData logData, ExternalReferenceData externalReferenceData) throws LogServiceException {
        LOGGER.info("logData moduleInstance={}, currentDateTime={}, logData=..., externalReferenceData=...", (Object)moduleInstance, (Object)currentDateTime);
        try {
            final String parentIndex = moduleInstance.getOpenSearchParentIndex();
            final String childIndex = moduleInstance.getOpenSearchChildIndex();
            LogServiceModuleInstance.KeysConfig keysConfig = moduleInstance.getKeysConfig();
            LogServiceModuleInstance.FieldsConfig fieldsConfig = moduleInstance.getFieldsConfig();
            LookupJoins lookupJoins = moduleInstance.getLookupJoins();
            final boolean childProcessingEnabled = moduleInstance.hasOpenSearchChildProcessingEnabled();
            Object object = PARENT_INDEX_LOCK;
            synchronized (object) {
                this.prepareParentIndexIfNotAlreadyDone(parentIndex, fieldsConfig);
            }
            object = CHILD_INDEX_LOCK;
            synchronized (object) {
                if (childProcessingEnabled) {
                    this.prepareChildIndexIfNotAlreadyDone(childIndex, fieldsConfig);
                }
            }
            RestHighLevelClient osClient = this.oss.getClient();
            Set<String> parentFieldsToSkip = fieldsConfig.getOpenSearchParentFieldsToSkip();
            Set<String> childFieldsToSkip = fieldsConfig.getOpenSearchChildFieldsToSkip();
            Set<String> parentTimestampFieldsInLowerCase = fieldsConfig.getParentTimestampFieldsInLowerCase();
            Set<String> childTimestampFieldsInLowerCase = fieldsConfig.getChildTimestampFieldsInLowerCase();
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            for (LogData.Entry logDataEntry : logData) {
                if (logDataEntry.hasParent()) {
                    Map<String, Object> parentData = this.createDataContainerWithLookupJoinData(logDataEntry.parent(), lookupJoins);
                    parentData = LogServiceModuleInstance.FieldsConfig.createDataContainerWithoutFieldsToSkip(parentData, parentFieldsToSkip);
                    parentData = LogServiceModuleInstance.FieldsConfig.createDataContainerWithReplacedSysdatePlaceholders(parentData, parentTimestampFieldsInLowerCase, currentDateTime, null);
                    parentData = this.createDataContainerWithExternalReferenceDataAdded(parentData, externalReferenceData);
                    parentData = this.createDataContainerWithConvertedValuesLikeOpenSearchNeedsThem(parentData);
                    String parentRecordId = this.createRecordId(keysConfig.parent.getIdColumnsAsList(), parentData);
                    if (logDataEntry.partialUpdate()) {
                        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(parentIndex)).id(parentRecordId).doc(parentData, (MediaType)XContentType.JSON);
                        bulkRequest.add(updateRequest);
                    } else {
                        IndexRequest indexRequest = ((IndexRequest)new IndexRequest().index(parentIndex)).id(parentRecordId).source(parentData, (MediaType)XContentType.JSON);
                        indexRequest.setPipeline(this.oss.getAttachmentsPipelineName(parentIndex));
                        bulkRequest.add(indexRequest);
                    }
                }
                if (!childProcessingEnabled || !logDataEntry.hasChildren()) continue;
                for (Map<String, Object> childData : logDataEntry.children()) {
                    childData = this.createDataContainerWithLookupJoinData(childData, lookupJoins);
                    childData = LogServiceModuleInstance.FieldsConfig.createDataContainerWithoutFieldsToSkip(childData, childFieldsToSkip);
                    childData = LogServiceModuleInstance.FieldsConfig.createDataContainerWithReplacedSysdatePlaceholders(childData, childTimestampFieldsInLowerCase, currentDateTime, null);
                    childData = this.createDataContainerWithConvertedValuesLikeOpenSearchNeedsThem(childData);
                    String childRecordId = this.createRecordId(keysConfig.child.getIdColumnsAsList(), childData);
                    if (logDataEntry.partialUpdate()) {
                        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(childIndex)).id(childRecordId).doc(childData, (MediaType)XContentType.JSON);
                        bulkRequest.add(updateRequest);
                        continue;
                    }
                    IndexRequest indexRequest = ((IndexRequest)new IndexRequest().index(childIndex)).id(childRecordId).source(childData, (MediaType)XContentType.JSON);
                    indexRequest.setPipeline(this.oss.getAttachmentsPipelineName(childIndex));
                    bulkRequest.add(indexRequest);
                }
            }
            final BulkResponse bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            if (bulkResponse.hasFailures()) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_LOGGING_FAILED, "Failed to bulk index the given log service data. OpenSearch error: ${error}", MapUtil.mapOf("error", bulkResponse.buildFailureMessage()));
            }
            LOGGER.debug("OpenSearch call done");
            return new FutureTask<Exception>(new Callable<Exception>(){

                @Override
                public Exception call() {
                    try {
                        OpenSearchLogService.this.percolatorsManager.informClientsAboutReplicatedData(OpenSearchLogService.this.oss, parentIndex, bulkResponse);
                        if (childProcessingEnabled) {
                            OpenSearchLogService.this.percolatorsManager.informClientsAboutReplicatedData(OpenSearchLogService.this.oss, childIndex, bulkResponse);
                        }
                        return null;
                    }
                    catch (Exception ex) {
                        LOGGER.error(ex.getMessage(), (Throwable)ex);
                        return ex;
                    }
                }
            });
        }
        catch (OpenSearchRelatedException | IOException | OpenSearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to log data in OpenSearch.", ex);
        }
    }

    private void prepareParentIndexIfNotAlreadyDone(final String parentIndex, final LogServiceModuleInstance.FieldsConfig fieldsConfig) throws LogServiceException {
        try {
            BpcIndexState parentIndexState = this.oss.getIndexState(parentIndex);
            parentIndexState.prepareUsing(new BpcIndexCreateCallable(){

                @Override
                public String createIndex(OpenSearchService oss) throws OpenSearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                    return oss.createIndex(parentIndex, OpenSearchLogService.this.defaultIndexCreationSettings, OpenSearchLogService.this.fieldsAsOpenSearchMapping(OpenSearchLogService.this.oss, fieldsConfig.parent));
                }
            });
            if (!this.oss.existsAttachmentsPipeline(parentIndex)) {
                this.oss.prepareAttachmentsPipeline(parentIndex);
            }
        }
        catch (Exception ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_LOGGING_FAILED, "Failed to prepare the parent index: ${error}", MapUtil.mapOf("index", parentIndex, "error", ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    private void prepareChildIndexIfNotAlreadyDone(final String childIndex, final LogServiceModuleInstance.FieldsConfig fieldsConfig) throws LogServiceException {
        try {
            BpcIndexState childIndexState = this.oss.getIndexState(childIndex);
            childIndexState.prepareUsing(new BpcIndexCreateCallable(){

                @Override
                public String createIndex(OpenSearchService oss) throws OpenSearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                    return oss.createIndex(childIndex, OpenSearchLogService.this.defaultIndexCreationSettings, OpenSearchLogService.this.fieldsAsOpenSearchMapping(OpenSearchLogService.this.oss, fieldsConfig.child));
                }
            });
            if (!this.oss.existsAttachmentsPipeline(childIndex)) {
                this.oss.prepareAttachmentsPipeline(childIndex);
            }
        }
        catch (Exception ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_LOGGING_FAILED, "Failed to prepare the child index: ${error}", MapUtil.mapOf("index", childIndex, "error", ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    public Map<String, Object> createDataContainerWithLookupJoinData(Map<String, Object> data, LookupJoins lookupJoins) throws OpenSearchRelatedException {
        if (lookupJoins == null || !lookupJoins.hasEntries()) {
            return data;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(data);
        for (LookupJoin lookupJoin : lookupJoins.getEntries()) {
            Object value = result.get(lookupJoin.getKeyField());
            if (value == null) continue;
            Map<String, Object> alreadyPrefixedLookupData = lookupJoin.getAlreadyPrefixedLookupData(this.oss, value);
            result.putAll(alreadyPrefixedLookupData);
        }
        return result;
    }

    private Map<String, Object> createDataContainerWithExternalReferenceDataAdded(Map<String, Object> data, ExternalReferenceData externalReferenceData) {
        if (externalReferenceData == null || externalReferenceData.isEmpty()) {
            return data;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(data);
        result.put("externalReference", externalReferenceData.asMap());
        return result;
    }

    private Map<String, Object> createDataContainerWithConvertedValuesLikeOpenSearchNeedsThem(Map<String, Object> data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        data.forEach((key, value) -> {
            if (value instanceof Date) {
                result.put((String)key, this.oss.formatForOpenSearch((Date)value));
            } else if (value instanceof Timestamp) {
                result.put((String)key, this.oss.formatForOpenSearch((Timestamp)value));
            } else if (value instanceof java.util.Date) {
                result.put((String)key, this.oss.formatForOpenSearch((java.util.Date)value));
            } else {
                result.put((String)key, value);
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOpenSearchIndexMappings(LogServiceModuleInstance logServiceModuleInstance) throws LogServiceSettingsException, OpenSearchRelatedException {
        LOGGER.info("updateOpenSearchIndexMappings logServiceModuleInstance=...");
        if (logServiceModuleInstance != null) {
            String parentIndex = logServiceModuleInstance.getOpenSearchParentIndex();
            String childIndex = logServiceModuleInstance.getOpenSearchChildIndex();
            LogServiceModuleInstance.FieldsConfig fieldsConfig = logServiceModuleInstance.getFieldsConfig();
            boolean childProcessingEnabled = logServiceModuleInstance.hasOpenSearchChildProcessingEnabled();
            Object object = PARENT_INDEX_LOCK;
            synchronized (object) {
                if (this.oss.existsIndex(parentIndex)) {
                    try {
                        this.oss.updateIndexMapping(parentIndex, this.fieldsAsOpenSearchMapping(this.oss, fieldsConfig.parent));
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed to update the parent index mapping ({}) of the log service module instance: {}", (Object)parentIndex, (Object)logServiceModuleInstance, (Object)ex);
                    }
                }
            }
            if (childProcessingEnabled) {
                object = CHILD_INDEX_LOCK;
                synchronized (object) {
                    if (this.oss.existsIndex(childIndex)) {
                        try {
                            this.oss.updateIndexMapping(childIndex, this.fieldsAsOpenSearchMapping(this.oss, fieldsConfig.child));
                        }
                        catch (Exception ex) {
                            LOGGER.error("Failed to update the child index mapping ({}) of the log service module instance: {}", (Object)childIndex, (Object)logServiceModuleInstance, (Object)ex);
                        }
                    }
                }
            }
        }
    }

    @Override
    public LogDataEntries getLogDataEntries(LogServiceModule logServiceModule, LogServiceModuleInstance moduleInstance, String timeZoneId, Integer start, Integer limit, String parentQuery, String parentFilter, String parentSort, boolean addChildren, String childSort) throws LogServiceException {
        LOGGER.info("getLogDataEntries logServiceModule=..., moduleInstance=..., timeZoneId={}, start={}, limit={}, parentQuery={}, parentFilter={}, parentSort={}, addChildren={}, childSort={}", (Object)timeZoneId, (Object)start, (Object)limit, (Object)parentQuery, (Object)parentFilter, (Object)parentSort, (Object)addChildren, (Object)childSort);
        try {
            if (start == null || start < 0) {
                start = 0;
                LOGGER.debug("No start parameter or out of range. Set start to " + start);
            }
            if (limit == null || limit < 0 || limit > 10000) {
                limit = 100;
                LOGGER.debug("No limit parameter or out of range. Set limit to " + limit);
            }
            RestHighLevelClient osClient = this.oss.getClient();
            String parentIndex = moduleInstance.getOpenSearchParentIndex();
            String childIndex = moduleInstance.getOpenSearchChildIndex();
            boolean childProcessingEnabled = moduleInstance.hasOpenSearchChildProcessingEnabled();
            LogServiceModuleInstance.KeysConfig keysConfig = moduleInstance.getKeysConfig();
            int maxResultWindowSize = (Integer)logServiceModule.getConfiguration().getSetting("openSearchDataViewLimit").getValue();
            int maxDataCount = (Integer)logServiceModule.getConfiguration().getSetting("openSearchDataCountLimit").getValue();
            try {
                Settings settings = Settings.builder().put("max_result_window", maxResultWindowSize).build();
                osClient.indices().putSettings(new UpdateSettingsRequest(parentIndex).settings(settings), RequestOptions.DEFAULT);
            }
            catch (Exception e) {
                LOGGER.warn(e.getLocalizedMessage());
            }
            if (start + limit > maxResultWindowSize) {
                throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_QUERY_RANGE_LIMIT, "Requested range ${from} - ${to} is breaking the configured limit (${settingName}) of ${maxResultWindowSize}", MapUtil.mapOf("from", start, "to", start + limit, "settingName", "openSearchDataViewLimit", "maxResultWindowSize", maxResultWindowSize));
            }
            BpcIndexMapping parentIndexMapping = new BpcIndexMapping(this.oss.getMappingMetaData(parentIndex));
            List<SortBuilder> parentSortBuilders = this.createSortBuilders(parentSort, keysConfig.parent.getIdColumnsAsList(), "DESC", parentIndexMapping);
            List<SortBuilder> childSortBuilders = null;
            String parentKeyField = null;
            String parentKeyFieldForChildQuery = null;
            if (addChildren && childProcessingEnabled) {
                BpcIndexMapping childIndexMapping = new BpcIndexMapping(this.oss.getMappingMetaData(childIndex));
                childSortBuilders = this.createSortBuilders(childSort, keysConfig.child.getIdColumnsAsList(), "ASC", childIndexMapping);
                parentKeyField = keysConfig.child.getIdColumnsAsList().get(0);
                parentKeyFieldForChildQuery = childIndexMapping.getPreferredQueryFieldForIDs(parentKeyField);
            }
            QueryBuilder osQuery = new BpcQueryBuilder().addSkipPercolatorDocumentsQuery().addStringBasedQuery(parentQuery).addQueriesForFilters(parentFilter, parentIndexMapping, timeZoneId).buildAsBoolFilterQuery();
            SearchSourceBuilder ssb = new SearchSourceBuilder().from(start).size(limit).trackTotalHitsUpTo(maxDataCount).query(osQuery);
            for (SortBuilder parentSortBuilder : parentSortBuilders) {
                ssb.sort(parentSortBuilder);
            }
            SearchRequest searchRequest = new SearchRequest().indices(parentIndex).source(ssb);
            LogDataEntries logData = new LogDataEntries();
            SearchResponse searchResponse = this.oss.search(searchRequest, RequestOptions.DEFAULT);
            for (SearchHit searchHit : searchResponse.getHits()) {
                String parentId = searchHit.getId();
                Map<String, Object> parentDocument = searchHit.getSourceAsMap();
                logData.addEntry(parentId, parentDocument);
            }
            this.oss.releaseScrollId(searchResponse);
            if (addChildren && childProcessingEnabled) {
                List<Map<String, Object>> childDocuments = this.fetchAllChildDocumentsOfParents(childIndex, parentKeyFieldForChildQuery, logData.getParentIDs(), childSortBuilders);
                for (Map<String, Object> childDocument : childDocuments) {
                    Object parentIdObject = childDocument.get(parentKeyField);
                    if (parentIdObject == null) continue;
                    String parentId = String.valueOf(parentIdObject);
                    logData.addChildDocument(parentId, childDocument);
                }
            }
            return logData;
        }
        catch (OpenSearchIndexMappingNotFoundException | OpenSearchIndexNotFoundException | OpenSearchRelatedException | OpenSearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to get log data from OpenSearch.", ex);
        }
    }

    @Override
    public LogDataEntries getLogDataEntries(LogServiceModuleInstance moduleInstance, String parentId) throws LogServiceException {
        LOGGER.info("getLogDataEntries moduleInstance=..., parentId={}", (Object)parentId);
        try {
            RestHighLevelClient osClient = this.oss.getClient();
            String parentIndex = moduleInstance.getOpenSearchParentIndex();
            String childIndex = moduleInstance.getOpenSearchChildIndex();
            boolean childProcessingEnabled = moduleInstance.hasOpenSearchChildProcessingEnabled();
            LogServiceModuleInstance.KeysConfig keysConfig = moduleInstance.getKeysConfig();
            String parentDocumentId = OpenSearchRecordID.create(parentId);
            Map<String, Object> parentDocument = this.fetchDocumentFromIndexById(osClient, parentIndex, parentDocumentId);
            List<Map<String, Object>> childDocuments = null;
            if (childProcessingEnabled) {
                BpcIndexMapping childIndexMapping = new BpcIndexMapping(this.oss.getMappingMetaData(childIndex));
                List<SortBuilder> childSortBuilders = this.createSortBuilders(null, keysConfig.child.getIdColumnsAsList(), "ASC", childIndexMapping);
                String parentKeyField = keysConfig.child.getIdColumnsAsList().get(0);
                String parentKeyQueryField = childIndexMapping.getPreferredQueryFieldForIDs(parentKeyField);
                childDocuments = this.fetchAllChildDocumentsOfParents(childIndex, parentKeyQueryField, List.of(parentId), childSortBuilders);
            }
            LogDataEntries logDataEntries = new LogDataEntries();
            logDataEntries.addEntry(parentId, parentDocument, childDocuments);
            return logDataEntries;
        }
        catch (OpenSearchIndexMappingNotFoundException | OpenSearchIndexNotFoundException | OpenSearchRelatedException | IOException | OpenSearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to get log data from OpenSearch.", ex);
        }
    }

    @Override
    public LogDataEntries getLogDataEntries(LogServiceModuleInstance moduleInstance, String parentId, String timeZoneId, String childQuery, String childFilter) throws LogServiceException {
        LOGGER.info("getLogDataEntries moduleInstance=..., parentId={}, timeZoneId={}, childQuery={}, childFilter={}", (Object)parentId, (Object)timeZoneId, (Object)childQuery, (Object)childFilter);
        try {
            RestHighLevelClient osClient = this.oss.getClient();
            String parentIndex = moduleInstance.getOpenSearchParentIndex();
            String childIndex = moduleInstance.getOpenSearchChildIndex();
            boolean childProcessingEnabled = moduleInstance.hasOpenSearchChildProcessingEnabled();
            LogServiceModuleInstance.KeysConfig keysConfig = moduleInstance.getKeysConfig();
            String parentDocumentId = OpenSearchRecordID.create(parentId);
            Map<String, Object> parentDocument = this.fetchDocumentFromIndexById(osClient, parentIndex, parentDocumentId);
            List<Map<String, Object>> childDocuments = null;
            if (childProcessingEnabled) {
                BpcIndexMapping childIndexMapping = new BpcIndexMapping(this.oss.getMappingMetaData(childIndex));
                List<SortBuilder> childSortBuilders = this.createSortBuilders(null, keysConfig.child.getIdColumnsAsList(), "ASC", childIndexMapping);
                String parentKeyField = keysConfig.child.getIdColumnsAsList().get(0);
                String parentKeyQueryField = childIndexMapping.getPreferredQueryFieldForIDs(parentKeyField);
                childDocuments = this.fetchChildDocumentsOfParents(childIndex, parentKeyQueryField, List.of(parentId), childSortBuilders, timeZoneId, childQuery, childFilter);
            }
            LogDataEntries logDataEntries = new LogDataEntries();
            logDataEntries.addEntry(parentId, parentDocument, childDocuments);
            return logDataEntries;
        }
        catch (OpenSearchIndexMappingNotFoundException | OpenSearchIndexNotFoundException | OpenSearchRelatedException | IOException | OpenSearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to get log data from OpenSearch.", ex);
        }
    }

    @Override
    public LogDataEntries getLogDataEntries(LogServiceModuleInstance moduleInstance, String parentId, String childId) throws LogServiceException {
        LOGGER.info("getLogDataEntries moduleInstance=..., parentId={}, childId={}", (Object)parentId, (Object)childId);
        try {
            RestHighLevelClient osClient = this.oss.getClient();
            String parentIndex = moduleInstance.getOpenSearchParentIndex();
            String childIndex = moduleInstance.getOpenSearchChildIndex();
            if (!moduleInstance.hasOpenSearchChildProcessingEnabled()) {
                return null;
            }
            String parentDocumentId = OpenSearchRecordID.create(parentId);
            Map<String, Object> parentDocument = this.fetchDocumentFromIndexById(osClient, parentIndex, parentDocumentId);
            String childDocumentId = OpenSearchRecordID.create(parentId, childId);
            Map<String, Object> childDocument = this.fetchDocumentFromIndexById(osClient, childIndex, childDocumentId);
            LogDataEntries logDataEntries = new LogDataEntries();
            logDataEntries.addEntry(parentId, parentDocument, ListUtil.listOf(childDocument));
            return logDataEntries;
        }
        catch (IOException | OpenSearchException ex) {
            throw new LogServiceException((ErrorCode)CoreErrorCode.LOG_SERVICE_ES_FAILURE, "Failed to get log data from OpenSearch.", ex);
        }
    }

    private Map<String, Object> fetchDocumentFromIndexById(RestHighLevelClient osClient, String index, String documentId) throws IOException {
        LOGGER.info("fetchDocumentFromIndexById osClient=..., index={}, documentId={}", (Object)index, (Object)documentId);
        GetRequest getReq = ((GetRequest)new GetRequest().index(index)).id(documentId);
        GetResponse response = osClient.get(getReq, RequestOptions.DEFAULT);
        return response.getSourceAsMap();
    }

    public void dropIndices(LogServiceModuleInstance moduleInstance) throws OpenSearchRelatedException {
        LOGGER.info("dropIndices moduleInstance=...");
        if (moduleInstance != null) {
            this.dropIndex(moduleInstance.getOpenSearchParentIndex());
            this.dropIndex(moduleInstance.getOpenSearchChildIndex());
        }
    }

    private void dropIndex(String aliasOfIndex) throws OpenSearchRelatedException {
        LOGGER.info("dropIndex aliasOfIndex={}", (Object)aliasOfIndex);
        if (StringUtil.isNullOrEmpty(aliasOfIndex)) {
            return;
        }
        if (!this.oss.existsIndex(aliasOfIndex)) {
            return;
        }
        Set<String> indexNames = this.oss.getIndexNamesWithAlias(aliasOfIndex);
        if (indexNames.isEmpty()) {
            this.oss.deleteIndex(aliasOfIndex);
        } else {
            for (String indexName : indexNames) {
                this.oss.deleteIndex(indexName);
            }
        }
    }
}

