/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.LicenseException;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ModuleInstanceCreateException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.core.opensearch.ModuleConfigurationImpl;
import de.virtimo.bpc.core.opensearch.ModuleConfigurationPersistenceCallback;
import de.virtimo.bpc.core.opensearch.ModuleManagerImpl;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.module.ModuleConfigurationBuilder;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchException;
import org.opensearch.core.rest.RestStatus;
import org.osgi.framework.Bundle;

public abstract class AbstractInstantiableModule
implements InstantiableModule,
PropertyChangeListener {
    private static final Logger LOGGER = LogManager.getLogger(AbstractInstantiableModule.class);
    private ModuleConfiguration moduleConfiguration;
    private Map<String, ModuleInstance> instances;
    private int licenseRelevantInstanceCounter;
    private ModuleManager moduleManager;
    private Class<? extends ModuleInstance> instanceClass;
    private Bundle moduleBundle;
    private ModuleConfiguration _cachedDefaultModuleConfiguration;
    private Map<String, ModuleConfiguration> _cachedDefaultInstanceConfigurations = new HashMap<String, ModuleConfiguration>();
    private BpcServicesTracker<LicenseService> licenseServiceTracker;
    private BpcServicesTracker<EventManager> eventManagerTracker;

    public AbstractInstantiableModule(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
        this.instanceClass = this.getModuleInstanceClass();
        this.instances = new HashMap<String, ModuleInstance>();
        this.licenseRelevantInstanceCounter = 0;
    }

    @Override
    public void destroy() {
        LOGGER.info("{}: destroy", (Object)this.getClass().getSimpleName());
        try {
            if (this.instances != null && !this.instances.isEmpty()) {
                for (ModuleInstance moduleInstance : this.instances.values()) {
                    moduleInstance.destroy();
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error("{}: Cannot destroy the module instances.", (Object)this.getClass().getSimpleName(), (Object)t);
        }
        ModuleConfiguration currentModuleConfiguration = this.moduleConfiguration;
        if (currentModuleConfiguration != null) {
            currentModuleConfiguration.removePropertyChangeListener(this);
            currentModuleConfiguration.destroy();
        }
        this.moduleConfiguration = null;
        BpcServicesTracker.stopAll(this, AbstractInstantiableModule.class);
        this.moduleManager = null;
    }

    @Override
    public Bundle getModuleBundle() {
        return this.moduleBundle;
    }

    @Override
    public void setModuleBundle(Bundle moduleBundle) {
        this.moduleBundle = moduleBundle;
        BpcServicesTracker.stopAll(this);
        this.licenseServiceTracker = new BpcServicesTracker<LicenseService>(moduleBundle.getBundleContext(), LicenseService.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(moduleBundle.getBundleContext(), EventManager.class);
    }

    protected String getNextInstanceId() {
        return this.getModuleId().toLowerCase() + new Date().getTime();
    }

    @Override
    public boolean usesInstanceTypes() {
        String[] supportedInstanceTypes = this.getSupportedInstanceTypes();
        return supportedInstanceTypes != null && supportedInstanceTypes.length > 0;
    }

    @Override
    public String[] getSupportedInstanceTypes() {
        return null;
    }

    @Override
    public ModuleConfiguration getInstanceConfiguration(String moduleInstanceId) {
        Module instance = this.instances.get(moduleInstanceId);
        ModuleConfiguration mc = null;
        if (instance != null) {
            mc = instance.getConfiguration();
        }
        return mc;
    }

    public ModuleConfiguration getCachedDefaultConfiguration() {
        LOGGER.debug("{} ({}): getCachedDefaultConfiguration", (Object)this.getClass().getSimpleName(), (Object)this.getModuleId());
        if (this._cachedDefaultModuleConfiguration == null) {
            this._cachedDefaultModuleConfiguration = this.getDefaultConfiguration();
        }
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).addSettings(this._cachedDefaultModuleConfiguration.getSettings().values()).build();
    }

    @Override
    public abstract ModuleConfiguration getDefaultConfiguration();

    @Override
    public abstract String getModuleId();

    @Override
    public abstract String getModuleName();

    @Override
    public void setConfiguration(ModuleConfiguration moduleConfiguration) {
        LOGGER.info("{} ({}): setConfiguration moduleConfiguration={}", (Object)this.getClass().getSimpleName(), (Object)this.getModuleId(), (Object)moduleConfiguration);
        ModuleConfiguration oldModuleConfiguration = this.moduleConfiguration;
        if (oldModuleConfiguration != null) {
            oldModuleConfiguration.removePropertyChangeListener(this);
        }
        moduleConfiguration.addPropertyChangeListener(this);
        this.moduleConfiguration = moduleConfiguration;
        LOGGER.info("{} ({}): Destroying existing module instances", (Object)this.getClass().getSimpleName(), (Object)this.getModuleId());
        for (ModuleInstance moduleInstance : this.instances.values()) {
            try {
                LOGGER.info("{} ({}): Destroying the existing module instance: {}", (Object)this.getClass().getSimpleName(), (Object)this.getModuleId(), (Object)moduleInstance);
                moduleInstance.destroy();
            }
            catch (Throwable t) {
                LOGGER.error("{} ({}): Could not destroy the existing module instance: {}", (Object)this.getClass().getSimpleName(), (Object)this.getModuleId(), (Object)moduleInstance);
            }
        }
        LOGGER.info("{} ({}): Clearing the module instances container", (Object)this.getClass().getSimpleName(), (Object)this.getModuleId());
        this.instances.clear();
        this.licenseRelevantInstanceCounter = 0;
        LOGGER.info("{} ({}): Creating the module instances", (Object)this.getClass().getSimpleName(), (Object)this.getModuleId());
        try {
            Map<String, ModuleConfiguration> instanceMap = this.moduleManager.getModuleInstanceConfiguration(this);
            instanceMap.forEach((instanceId, instanceModuleConfiguration) -> {
                try {
                    String instanceType = instanceModuleConfiguration instanceof ModuleConfigurationImpl ? ((ModuleConfigurationImpl)instanceModuleConfiguration).getInstanceType() : "none";
                    this.createModuleInstance((String)instanceId, instanceType, (ModuleConfiguration)instanceModuleConfiguration, true);
                }
                catch (ModuleInstanceCreateException e) {
                    LOGGER.warn("{} ({}): Can't create module instance. General error.", (Object)this.getClass().getSimpleName(), (Object)this.getModuleId(), (Object)e);
                }
                catch (LicenseException e) {
                    LOGGER.warn("{} ({}): Can't create module instance. License error.", (Object)this.getClass().getSimpleName(), (Object)this.getModuleId(), (Object)e);
                }
                catch (SettingException e) {
                    LOGGER.warn("{} ({}): Can't create module instance. Setting error.", (Object)this.getClass().getSimpleName(), (Object)this.getModuleId(), (Object)e);
                }
            });
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                LOGGER.warn("{} ({}): Failed to read the module instance settings. The '{}' index is missing. Should happen only on first start or when someone deleted that index!", (Object)this.getClass().getSimpleName(), (Object)this.getModuleId(), (Object)ex.getIndex());
            } else {
                LOGGER.error("{} ({}): Unhandled exception in AbstractInstantiableModule.setConfiguration(). Please report the occurred RestStatus '{}' to the BPC developers.", (Object)this.getClass().getSimpleName(), (Object)this.getModuleId(), (Object)ex.status(), (Object)ex);
            }
        }
        catch (SettingException | OpenSearchRelatedException | ServiceNotFoundException ex) {
            LOGGER.warn("{} ({}): Can't re-create the module instances.", (Object)this.getClass().getSimpleName(), (Object)this.getModuleId(), (Object)ex);
        }
    }

    @Override
    public ModuleConfiguration getConfiguration() {
        return this.moduleConfiguration;
    }

    @Override
    public abstract ModuleConfiguration getDefaultInstanceConfiguration();

    @Override
    public ModuleConfiguration getDefaultInstanceConfiguration(String instanceType) {
        return this.getDefaultInstanceConfiguration();
    }

    public ModuleConfiguration getCachedDefaultInstanceConfiguration(String instanceType) {
        ModuleConfiguration cachedModuleConfiguration;
        LOGGER.debug("{} ({}): getCachedDefaultInstanceConfiguration instanceType={}", (Object)this.getClass().getSimpleName(), (Object)this.getModuleId(), (Object)instanceType);
        if (instanceType == null) {
            instanceType = "none";
        }
        if ((cachedModuleConfiguration = this._cachedDefaultInstanceConfigurations.get(instanceType)) == null) {
            cachedModuleConfiguration = this.getDefaultInstanceConfiguration(instanceType);
            this._cachedDefaultInstanceConfigurations.put(instanceType, cachedModuleConfiguration);
        }
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).withInstanceId(null).withInstanceType(instanceType).addSettings(cachedModuleConfiguration.getSettings().values()).build();
    }

    @Override
    public Map<String, ModuleInstance> getModuleInstances() {
        return new HashMap<String, ModuleInstance>(this.instances);
    }

    @Override
    public ModuleInstance getModuleInstance(String moduleInstanceId) {
        if (!StringUtil.isNullOrEmpty(moduleInstanceId)) {
            return this.instances.get(moduleInstanceId.toLowerCase());
        }
        return null;
    }

    @Override
    @NotNull
    public ModuleInstance getModuleInstanceById(String moduleInstanceId) throws ModuleInstanceNotFoundException {
        ModuleInstance moduleInstance = this.getModuleInstance(moduleInstanceId);
        if (moduleInstance == null) {
            throw new ModuleInstanceNotFoundException(this.getModuleId(), moduleInstanceId);
        }
        return moduleInstance;
    }

    @Override
    @NotNull
    public ModuleInstance getModuleInstanceByIdOrName(String moduleInstanceIdOrName) throws ModuleInstanceNotFoundException {
        LOGGER.debug("{} ({}): getModuleInstanceByIdOrName moduleInstanceIdOrName:{}", (Object)this.getClass().getSimpleName(), (Object)this.getModuleId(), (Object)moduleInstanceIdOrName);
        ModuleInstance moduleInstance = this.getModuleInstance(moduleInstanceIdOrName);
        if (moduleInstance != null) {
            return moduleInstance;
        }
        List<ModuleInstance> moduleInstances = this.getModuleInstancesByName(moduleInstanceIdOrName);
        if (moduleInstances.size() == 1) {
            return moduleInstances.get(0);
        }
        throw new ModuleInstanceNotFoundException(this.getModuleId(), moduleInstanceIdOrName);
    }

    @Override
    @NotNull
    public List<ModuleInstance> getModuleInstancesByName(String instanceName) {
        LOGGER.debug("{} ({}): getModuleInstancesByName moduleName:{}", (Object)this.getClass().getSimpleName(), (Object)this.getModuleId(), (Object)instanceName);
        ArrayList<ModuleInstance> result = new ArrayList<ModuleInstance>();
        if (!StringUtil.isNullOrEmpty(instanceName)) {
            for (ModuleInstance moduleInstance : this.instances.values()) {
                String moduleNameSettingValue;
                Setting moduleNameSetting = moduleInstance.getConfiguration().getSetting("module_name");
                if (moduleNameSetting == null || StringUtil.isNullOrEmpty(moduleNameSettingValue = (String)moduleNameSetting.getValue()) || !instanceName.equals(moduleNameSettingValue)) continue;
                result.add(moduleInstance);
            }
        }
        return result;
    }

    @Override
    @NotNull
    public List<ModuleInstance> getModuleInstancesByInstanceType(String instanceType) {
        LOGGER.debug("{} ({}): getModuleInstancesByInstanceType instanceType:{}", (Object)this.getClass().getSimpleName(), (Object)this.getModuleId(), (Object)instanceType);
        ArrayList<ModuleInstance> result = new ArrayList<ModuleInstance>();
        if (!StringUtil.isNullOrEmpty(instanceType)) {
            for (ModuleInstance moduleInstance : this.instances.values()) {
                if (!instanceType.equalsIgnoreCase(moduleInstance.getInstanceType())) continue;
                result.add(moduleInstance);
            }
        }
        return result;
    }

    @Override
    @NotNull
    public List<ModuleInstance> getUseableModuleInstances(UserSession userSession) {
        LOGGER.debug("{} ({}): getUseableModuleInstances userSession:{}", (Object)this.getClass().getSimpleName(), (Object)this.getModuleId(), (Object)userSession);
        ArrayList<ModuleInstance> result = new ArrayList<ModuleInstance>();
        if (userSession != null) {
            for (ModuleInstance moduleInstance : this.instances.values()) {
                if (!userSession.hasUseModuleInstanceRight(moduleInstance)) continue;
                result.add(moduleInstance);
            }
        }
        return result;
    }

    @Override
    public ModuleInstance createModuleInstance(String instanceId, String instanceType, ModuleConfiguration moduleConfiguration) throws ModuleInstanceCreateException, LicenseException, SettingException {
        return this.createModuleInstance(instanceId, instanceType, moduleConfiguration, false);
    }

    public static boolean isValidModuleInstanceId(String instanceId) {
        if (instanceId == null) {
            return false;
        }
        Pattern p = Pattern.compile("[a-z0-9_\\-]+");
        Matcher m = p.matcher(instanceId);
        return m.matches();
    }

    private ModuleInstance createModuleInstance(String instanceId, String instanceType, ModuleConfiguration moduleConfiguration, boolean calledFromModuleInitialization) throws ModuleInstanceCreateException, LicenseException, SettingException {
        block19: {
            LOGGER.debug("{}: createModuleInstance instanceId:{}, instanceType={}, moduleConfiguration:{}, calledFromModuleInitialization={}", (Object)this.getClass().getSimpleName(), (Object)instanceId, (Object)instanceType, (Object)moduleConfiguration, (Object)calledFromModuleInitialization);
            if (!AbstractInstantiableModule.isValidModuleInstanceId(instanceId)) {
                throw new ModuleInstanceCreateException("Failed to create the instance '${instanceId}' of module '${moduleId}'. The instance ID must be lower case and contain only a-z, 0-9 and the characters '-' and '_'.", MapUtil.mapOf("moduleId", this.getModuleId(), "instanceId", instanceId));
            }
            instanceId = instanceId.toLowerCase();
            if (!ModuleManagerImpl.isCantLiveWithoutModule(this)) {
                try {
                    LicenseService licenseService = this.licenseServiceTracker.getService();
                    if (licenseService.isAllowedModule(this)) {
                        LOGGER.debug("Skip license check for this instance. It's one of the allowed modules.");
                        break block19;
                    }
                    if (!this.isLicenseRelevant(moduleConfiguration)) {
                        LOGGER.debug("Skip license limit check for this instance. It's free of charge");
                        break block19;
                    }
                    if (licenseService.isModuleWithInstanceLimit(this)) {
                        Integer currentLimit = licenseService.getInstanceLimit(this);
                        if (this.licenseRelevantInstanceCounter >= currentLimit) {
                            LOGGER.warn("Module instance limit reached. Limit: {} InstanceCount: {}", (Object)currentLimit, (Object)this.instances.size());
                            throw new LicenseException((ErrorCode)CoreErrorCode.LICENSE_MODULE_INSTANCE_LIMIT_REACHED, "Failed to create module instance. Module instance limit reached. Limit for module '${moduleId}' = ${limit}", MapUtil.mapOf("moduleId", this.getModuleId(), "limit", currentLimit));
                        }
                        LOGGER.debug("Module instance limit NOT reached. Limit: {} InstanceCount: {}", (Object)currentLimit, (Object)this.instances.size());
                        break block19;
                    }
                    if (licenseService.isOutdatedLicense() && !licenseService.isModuleWithInstanceLimit(this)) {
                        LOGGER.debug("Skip license check for this instance. It's from an outdated licenses to be backward compatible.");
                        break block19;
                    }
                    LOGGER.warn("Module is not allowed to create instances.");
                    throw new LicenseException((ErrorCode)CoreErrorCode.LICENSE_MODULE_INSTANCE_NOT_ALLOWED_TO_CREATE, "Failed to create module instance. License does not not allow to create instances of module '${moduleId}'", MapUtil.mapOf("moduleId", this.getModuleId()));
                }
                catch (LicenseException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new LicenseException((ErrorCode)CoreErrorCode.LICENSE_CHECK_FAILED, "Failed to check license: ${error}", MapUtil.mapOf("error", ex.getLocalizedMessage()), (Throwable)ex);
                }
            }
        }
        try {
            ModuleInstance moduleInstance;
            ModuleConfigurationImpl moduleInstanceConfiguration = new ModuleConfigurationImpl(this, instanceId, instanceType, moduleConfiguration.getSettings(), (ModuleConfigurationPersistenceCallback)((Object)this.moduleManager));
            Constructor moduleConstructor = this.getConstructorWithInstanceType();
            if (moduleConstructor != null) {
                moduleInstance = (ModuleInstance)moduleConstructor.newInstance(this, moduleInstanceConfiguration, instanceId, instanceType);
            } else {
                moduleConstructor = this.getConstructorWithoutInstanceType();
                if (moduleConstructor != null) {
                    moduleInstance = (ModuleInstance)moduleConstructor.newInstance(this, moduleInstanceConfiguration, instanceId);
                } else {
                    throw new RuntimeException("The instance class implementation (" + this.instanceClass.getName() + ") does not have the required constructor.");
                }
            }
            ModuleConfiguration managedMc = this.moduleManager.manageConfigurationPersistence(moduleInstance, moduleInstance.getConfiguration());
            moduleInstance.setConfiguration(managedMc);
            this.instances.put(moduleInstance.getModuleId(), moduleInstance);
            if (this.isLicenseRelevant(moduleInstance)) {
                ++this.licenseRelevantInstanceCounter;
            }
            try {
                this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/Configuration/moduleInstanceCreated", MapUtil.mapOf("moduleId", this.getModuleId(), "moduleInstanceId", instanceId, "moduleInstanceType", instanceType == null ? "none" : instanceType, "setting", new ArrayList<Setting>(managedMc.getSettings().values())));
            }
            catch (ServiceNotFoundException ex) {
                LOGGER.warn("Failed to send an module instance created event.", (Throwable)ex);
            }
            return moduleInstance;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            throw new ModuleInstanceCreateException("Failed to create the instance '${instanceId}' of module '${moduleId}': ${error}", MapUtil.mapOf("moduleId", this.getModuleId(), "instanceId", instanceId, "error", ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    @Override
    public void moduleInstanceCreated(ModuleInstance moduleInstance) {
    }

    @Override
    public void moduleInstanceUpdated(ModuleInstance moduleInstance) {
    }

    private Constructor getConstructorWithInstanceType() {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = this.instanceClass.getDeclaredConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 4 || !Module.class.isAssignableFrom(parameterTypes[0]) || !ModuleConfiguration.class.isAssignableFrom(parameterTypes[1]) || !parameterTypes[2].equals(String.class) || !parameterTypes[3].equals(String.class)) continue;
            return constructor;
        }
        return null;
    }

    private Constructor getConstructorWithoutInstanceType() {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = this.instanceClass.getDeclaredConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 3 || !Module.class.isAssignableFrom(parameterTypes[0]) || !ModuleConfiguration.class.isAssignableFrom(parameterTypes[1]) || !parameterTypes[2].equals(String.class)) continue;
            return constructor;
        }
        return null;
    }

    @Override
    public void deleteModuleInstance(String instanceId) {
        LOGGER.info("{}: deleteModuleInstance instanceId:{}", (Object)this.getClass().getSimpleName(), (Object)instanceId);
        try {
            if (this.isLicenseRelevant(this.instances.get(instanceId))) {
                --this.licenseRelevantInstanceCounter;
            }
            ModuleInstance removedModuleInstance = this.instances.remove(instanceId);
            this.getModuleManager().deleteModuleInstance(this.getModuleId(), instanceId);
            try {
                this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/Configuration/moduleDeleted", MapUtil.mapOf("moduleId", this.getModuleId(), "moduleInstanceId", instanceId, "moduleInstanceType", removedModuleInstance.getInstanceType(), "moduleInstance", removedModuleInstance));
            }
            catch (ServiceNotFoundException ex) {
                LOGGER.warn("Failed to send an module instance deleted event.", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to delete the module instance: " + instanceId, (Throwable)ex);
        }
    }

    @Override
    public void moduleInstanceDeleted(ModuleInstance moduleInstance) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LOGGER.info("Got a property change event: {}", (Object)evt);
        if (evt.getSource() instanceof ModuleConfiguration) {
            // empty if block
        }
    }

    public String toString() {
        return this.getModuleId();
    }

    @Override
    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    public abstract Class<? extends ModuleInstance> getModuleInstanceClass();

    public Map<String, Object> loadJsonFileAsMap(String fileName) {
        return JsonDefaultsUtil.loadJsonFileAsMap(this.getModuleBundle(), fileName);
    }

    public List<Object> loadJsonFileAsList(String fileName) {
        return JsonDefaultsUtil.loadJsonFileAsList(this.getModuleBundle(), fileName);
    }

    public Map<String, Object> parseJsonStringAsMap(String jsonString) {
        return JsonDefaultsUtil.parseJsonStringAsMap(jsonString);
    }

    public String loadJsonFileAsString(String fileName) {
        return JsonDefaultsUtil.loadJsonFileAsString(this.getModuleBundle(), fileName);
    }

    private boolean isLicenseRelevant(ModuleInstance moduleInstance) {
        return this.isLicenseRelevant(moduleInstance.getConfiguration());
    }

    private boolean isLicenseRelevant(ModuleConfiguration moduleConfiguration) {
        return !moduleConfiguration.getSettingValue("internalInstance").asBoolean(false);
    }
}

