/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module;

import de.virtimo.bpc.api.CustomFields;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.RestrictedSetting;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.module.simple.CustomFieldsImpl;
import de.virtimo.bpc.module.simple.SimpleModuleConfig;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.MapUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;

public class ModuleConfigurationBuilder {
    private static final Logger LOGGER = LogManager.getLogger(ModuleConfigurationBuilder.class);
    private String moduleId = null;
    private String instanceId = null;
    private String instanceType = null;
    private final Map<String, Setting> settingMap = new HashMap<String, Setting>();

    public static ModuleConfigurationBuilder newInstance() {
        return new ModuleConfigurationBuilder();
    }

    private ModuleConfigurationBuilder() {
    }

    public ModuleConfigurationBuilder withModuleId(String moduleId) {
        this.moduleId = moduleId;
        return this;
    }

    public ModuleConfigurationBuilder withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public ModuleConfigurationBuilder withInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    public ModuleConfigurationBuilder addSetting(String key, Object value, String type) {
        this.settingMap.put(key, new SimpleSettingImpl(value, key, type, this.moduleId, this.instanceId, this.instanceType));
        return this;
    }

    public ModuleConfigurationBuilder addSetting(String key, Object value, String type, CustomFields customFields) {
        this.settingMap.put(key, new SimpleSettingImpl(value, key, type, this.moduleId, this.instanceId, this.instanceType, customFields));
        return this;
    }

    public ModuleConfigurationBuilder addSettingsFromFile(Bundle bundle, String fileName) {
        LOGGER.info("addSettingsFromFile bundle={}, fileName={}", (Object)bundle, (Object)fileName);
        Map<String, Object> loadedSettings = JsonDefaultsUtil.loadJsonFileAsMap(bundle, fileName);
        if (loadedSettings != null) {
            try {
                if (!this.isSortableGroupedSettings(loadedSettings)) {
                    throw new Exception("Settings are not Sortable Grouped Settings.");
                }
                this.addSortableGroupedSettings(bundle, loadedSettings);
            }
            catch (Exception ex) {
                LOGGER.error("{}: Failed to add settings from file: {}", (Object)bundle, (Object)fileName, (Object)ex);
            }
        }
        return this;
    }

    boolean isSortableGroupedSettings(Map<String, Object> settings) {
        if (settings != null) {
            if (settings.size() == 0) {
                return true;
            }
            for (String groupName : settings.keySet()) {
                Object groupValueObject = settings.get(groupName);
                if (!(groupValueObject instanceof Map)) continue;
                Map entriesOfGroup = (Map)groupValueObject;
                long groupSortPriority = MapUtil.getValueAsLong(entriesOfGroup, "sortPriority", -1L);
                List settingsOfGroup = MapUtil.getValueAsList(entriesOfGroup, "settings", null);
                if (groupSortPriority == -1L && settingsOfGroup == null) continue;
                return true;
            }
        }
        return false;
    }

    public ModuleConfigurationBuilder addSortableGroupedSettingsFromFile(Bundle bundle, String fileName) {
        LOGGER.info("addSortableGroupedSettingsFromFile bundle={}, fileName={}", (Object)bundle, (Object)fileName);
        Map<String, Object> sortableGroupedSettings = JsonDefaultsUtil.loadJsonFileAsMap(bundle, fileName);
        return this.addSortableGroupedSettings(bundle, sortableGroupedSettings);
    }

    private ModuleConfigurationBuilder addSortableGroupedSettings(Bundle bundle, Map<String, Object> sortableGroupedSettings) {
        LOGGER.info("addSortableGroupedSettings bundle={}, sortableGroupedSettings=...", (Object)bundle);
        if (sortableGroupedSettings != null) {
            for (String group : sortableGroupedSettings.keySet()) {
                Map entriesOfGroup = (Map)sortableGroupedSettings.get(group);
                long groupSortPriority = MapUtil.getValueAsLong(entriesOfGroup, "sortPriority", -1L);
                String groupLabel = MapUtil.getValueAsString(entriesOfGroup, "groupLabel", group);
                String groupTooltip = MapUtil.getValueAsString(entriesOfGroup, "groupTooltip", "");
                List settingsOfGroup = MapUtil.getValueAsList(entriesOfGroup, "settings", null);
                for (Map map : settingsOfGroup) {
                    map.put("_group", group);
                    map.put("_groupLabel", groupLabel);
                    map.put("_groupTooltip", groupTooltip);
                    if (groupSortPriority > 0L) {
                        map.put("_groupSortPriority", groupSortPriority);
                    }
                    String key = (String)map.get("name");
                    this.settingMap.put(key, this.createSetting(key, map, bundle));
                }
            }
        }
        return this;
    }

    private Setting createSetting(String key, Map<String, Object> map, Bundle bundle) {
        CustomFieldsImpl customFields;
        String type = (String)map.get("type");
        Object value = map.get("value");
        if ("json".equalsIgnoreCase(type) && value instanceof String) {
            value = ((String)value).trim().endsWith(".json") ? JsonDefaultsUtil.loadJsonFileAsListOrMap(bundle, (String)value) : JsonDefaultsUtil.parseJsonStringAsListOrMap((String)value);
        }
        if (!(customFields = new CustomFieldsImpl(map)).existsField("_writeableByRoles")) {
            customFields.setObjectValue("_writeableByRoles", RestrictedSetting.DefaultWriteableByRoles);
        }
        if (!customFields.existsField("_readableByRoles")) {
            customFields.setObjectValue("_readableByRoles", RestrictedSetting.DefaultReadableByRoles);
        }
        return new SimpleSettingImpl(value, key, type, this.moduleId, this.instanceId, this.instanceType, customFields);
    }

    public ModuleConfigurationBuilder addSettings(Collection<Setting> settings) {
        if (settings != null) {
            for (Setting setting : settings) {
                this.settingMap.put(setting.getName(), new SimpleSettingImpl(setting.getValue(), setting.getName(), setting.getType(), this.moduleId, this.instanceId, this.instanceType, new CustomFieldsImpl(setting.getCustomFields())));
            }
        }
        return this;
    }

    public ModuleConfiguration build() {
        return new SimpleModuleConfig(this.settingMap);
    }
}

