/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ByteArrayEntity
extends AbstractHttpEntity {
    private final byte[] buf;
    private final int off;
    private final int len;

    public ByteArrayEntity(byte[] buf, int off, int len, ContentType contentType, String contentEncoding, boolean chunked) {
        super(contentType, contentEncoding, chunked);
        Args.notNull((Object)buf, (String)"Source byte array");
        Args.notNegative((int)off, (String)"offset");
        Args.notNegative((int)len, (String)"length");
        Args.notNegative((int)(off + len), (String)"off + len");
        Args.check((off <= buf.length ? 1 : 0) != 0, (String)"off %s cannot be greater then b.length %s ", (Object[])new Object[]{off, buf.length});
        Args.check((off + len <= buf.length ? 1 : 0) != 0, (String)"off + len  %s cannot be less then b.length %s ", (Object[])new Object[]{off + len, buf.length});
        this.buf = buf;
        this.off = off;
        this.len = len;
    }

    public ByteArrayEntity(byte[] buf, int off, int len, ContentType contentType, String contentEncoding) {
        this(buf, off, len, contentType, contentEncoding, false);
    }

    public ByteArrayEntity(byte[] buf, ContentType contentType, String contentEncoding, boolean chunked) {
        super(contentType, contentEncoding, chunked);
        Args.notNull((Object)buf, (String)"Source byte array");
        this.buf = buf;
        this.off = 0;
        this.len = this.buf.length;
    }

    public ByteArrayEntity(byte[] buf, ContentType contentType, String contentEncoding) {
        this(buf, contentType, contentEncoding, false);
    }

    public ByteArrayEntity(byte[] buf, ContentType contentType, boolean chunked) {
        this(buf, contentType, null, chunked);
    }

    public ByteArrayEntity(byte[] buf, ContentType contentType) {
        this(buf, contentType, null, false);
    }

    public ByteArrayEntity(byte[] buf, int off, int len, ContentType contentType, boolean chunked) {
        this(buf, off, len, contentType, null, chunked);
    }

    public ByteArrayEntity(byte[] buf, int off, int len, ContentType contentType) {
        this(buf, off, len, contentType, null, false);
    }

    @Override
    public final boolean isRepeatable() {
        return true;
    }

    @Override
    public final long getContentLength() {
        return this.len;
    }

    @Override
    public final InputStream getContent() {
        return new ByteArrayInputStream(this.buf, this.off, this.len);
    }

    @Override
    public final void writeTo(OutputStream outStream) throws IOException {
        Args.notNull((Object)outStream, (String)"Output stream");
        outStream.write(this.buf, this.off, this.len);
        outStream.flush();
    }

    @Override
    public final boolean isStreaming() {
        return false;
    }

    @Override
    public final void close() throws IOException {
    }
}

