/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene50.compressing;

import java.io.IOException;
import org.apache.lucene.backward_codecs.compressing.CompressionMode;
import org.apache.lucene.backward_codecs.lucene50.compressing.Lucene50CompressingStoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;

public class Lucene50CompressingStoredFieldsFormat
extends StoredFieldsFormat {
    protected final String formatName;
    protected final String segmentSuffix;
    protected final CompressionMode compressionMode;
    protected final int chunkSize;
    protected final int maxDocsPerChunk;
    protected final int blockShift;

    public Lucene50CompressingStoredFieldsFormat(String formatName, CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockShift) {
        this(formatName, "", compressionMode, chunkSize, maxDocsPerChunk, blockShift);
    }

    public Lucene50CompressingStoredFieldsFormat(String formatName, String segmentSuffix, CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockShift) {
        this.formatName = formatName;
        this.segmentSuffix = segmentSuffix;
        this.compressionMode = compressionMode;
        if (chunkSize < 1) {
            throw new IllegalArgumentException("chunkSize must be >= 1");
        }
        this.chunkSize = chunkSize;
        if (maxDocsPerChunk < 1) {
            throw new IllegalArgumentException("maxDocsPerChunk must be >= 1");
        }
        this.maxDocsPerChunk = maxDocsPerChunk;
        if (blockShift < 2 || blockShift > 22) {
            throw new IllegalArgumentException("blockSize must be in 2-22, got " + blockShift);
        }
        this.blockShift = blockShift;
    }

    @Override
    public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        return new Lucene50CompressingStoredFieldsReader(directory, si, this.segmentSuffix, fn, context, this.formatName, this.compressionMode);
    }

    @Override
    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        throw new UnsupportedOperationException("Old formats can't be used for writing");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(compressionMode=" + String.valueOf(this.compressionMode) + ", chunkSize=" + this.chunkSize + ", maxDocsPerChunk=" + this.maxDocsPerChunk + ", blockShift=" + this.blockShift + ")";
    }
}

