/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.search.join.ToParentDocValues;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;

public class BlockJoinSelector {
    private BlockJoinSelector() {
    }

    public static Bits wrap(final Bits docsWithValue, final BitSet parents, final BitSet children) {
        return new Bits(){

            @Override
            public boolean get(int docID) {
                assert (parents.get(docID)) : "this selector may only be used on parent documents";
                if (docID == 0) {
                    return false;
                }
                int firstPotentialChild = parents.prevSetBit(docID - 1) + 1;
                assert (firstPotentialChild <= docID);
                if (firstPotentialChild == docID) {
                    return false;
                }
                int child = children.nextSetBit(firstPotentialChild, docID);
                while (child != Integer.MAX_VALUE) {
                    if (docsWithValue.get(child)) {
                        return true;
                    }
                    child = children.nextSetBit(child + 1, docID);
                }
                return false;
            }

            @Override
            public int length() {
                return docsWithValue.length();
            }
        };
    }

    public static SortedDocValues wrap(SortedSetDocValues sortedSet, Type selection, BitSet parents, DocIdSetIterator children) {
        return BlockJoinSelector.wrap(switch (selection.ordinal()) {
            case 0 -> SortedSetSelector.wrap(sortedSet, SortedSetSelector.Type.MIN);
            case 1 -> SortedSetSelector.wrap(sortedSet, SortedSetSelector.Type.MAX);
            default -> throw new AssertionError();
        }, selection, parents, children);
    }

    public static SortedDocValues wrap(SortedDocValues values, Type selection, BitSet parents, DocIdSetIterator children) {
        if (values.docID() != -1) {
            throw new IllegalArgumentException("values iterator was already consumed: values.docID=" + values.docID());
        }
        return ToParentDocValues.wrap(values, selection, parents, children);
    }

    protected static BitSetIterator toIter(BitSet children) {
        return new BitSetIterator(children, 0L);
    }

    public static NumericDocValues wrap(SortedNumericDocValues sortedNumerics, Type selection, BitSet parents, DocIdSetIterator children) {
        return BlockJoinSelector.wrap(switch (selection.ordinal()) {
            case 0 -> SortedNumericSelector.wrap(sortedNumerics, SortedNumericSelector.Type.MIN, SortField.Type.LONG);
            case 1 -> SortedNumericSelector.wrap(sortedNumerics, SortedNumericSelector.Type.MAX, SortField.Type.LONG);
            default -> throw new AssertionError();
        }, selection, parents, children);
    }

    public static NumericDocValues wrap(NumericDocValues values, Type selection, BitSet parents, DocIdSetIterator children) {
        if (values.docID() != -1) {
            throw new IllegalArgumentException("values iterator was already consumed: values.docID=" + values.docID());
        }
        return ToParentDocValues.wrap(values, selection, parents, children);
    }

    public static enum Type {
        MIN,
        MAX;

    }
}

