/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.matchhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.search.FilterMatchesIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TaskExecutor;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.matchhighlight.OffsetRange;
import org.apache.lucene.search.matchhighlight.OffsetsFromMatchIterator;
import org.apache.lucene.search.matchhighlight.OffsetsFromPositions;
import org.apache.lucene.search.matchhighlight.OffsetsFromTokens;
import org.apache.lucene.search.matchhighlight.OffsetsRetrievalStrategy;
import org.apache.lucene.search.matchhighlight.OffsetsRetrievalStrategySupplier;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IOConsumer;

public class MatchRegionRetriever {
    private final List<LeafReaderContext> leaves;
    private final Weight weight;
    private final Map<String, OffsetsRetrievalStrategy> offsetStrategies;
    private final TreeSet<String> queryAffectedHighlightedFields;
    private final Predicate<String> shouldLoadStoredField;
    private final IndexSearcher searcher;

    public MatchRegionRetriever(IndexSearcher searcher, Query query, Analyzer analyzer, Predicate<String> fieldsToLoadUnconditionally, Predicate<String> fieldsToLoadIfWithHits) throws IOException {
        this(searcher, query, MatchRegionRetriever.computeOffsetRetrievalStrategies(searcher.getIndexReader(), analyzer), fieldsToLoadUnconditionally, fieldsToLoadIfWithHits);
    }

    public MatchRegionRetriever(IndexSearcher searcher, Query query, OffsetsRetrievalStrategySupplier fieldOffsetStrategySupplier, Predicate<String> fieldsToLoadUnconditionally, final Predicate<String> fieldsToLoadIfWithHits) throws IOException {
        this.searcher = searcher;
        this.leaves = searcher.getIndexReader().leaves();
        assert (this.checkOrderConsistency(this.leaves));
        this.weight = searcher.createWeight(query, ScoreMode.COMPLETE, 0.0f);
        this.queryAffectedHighlightedFields = new TreeSet();
        query.visit(new QueryVisitor(){

            @Override
            public boolean acceptField(String field) {
                if (fieldsToLoadIfWithHits.test(field)) {
                    MatchRegionRetriever.this.queryAffectedHighlightedFields.add(field);
                }
                return false;
            }
        });
        this.offsetStrategies = new HashMap<String, OffsetsRetrievalStrategy>();
        for (String field2 : this.queryAffectedHighlightedFields) {
            this.offsetStrategies.put(field2, (OffsetsRetrievalStrategy)fieldOffsetStrategySupplier.apply(field2));
        }
        this.shouldLoadStoredField = field -> fieldsToLoadUnconditionally.test((String)field) || this.queryAffectedHighlightedFields.contains(field);
    }

    public void highlightDocuments(TopDocs topDocs, MatchOffsetsConsumer consumer) throws IOException {
        this.highlightDocuments(Arrays.stream(topDocs.scoreDocs).mapToInt(scoreDoc -> scoreDoc.doc).sorted().iterator(), consumer, field -> Integer.MAX_VALUE);
    }

    public void highlightDocuments(PrimitiveIterator.OfInt docIds, MatchOffsetsConsumer consumer, ToIntFunction<String> maxHitsPerField) throws IOException {
        int DEFAULT_MAX_BLOCK_SIZE = 50;
        this.highlightDocuments(docIds, consumer, maxHitsPerField, 50, ForkJoinPool.getCommonPoolParallelism());
    }

    public void highlightDocuments(PrimitiveIterator.OfInt docIds, MatchOffsetsConsumer consumer, ToIntFunction<String> maxHitsPerField, int maxBlockSize, int maxBlocksProcessedInParallel) throws IOException {
        if (this.leaves.isEmpty()) {
            return;
        }
        ArrayList<Callable<DocHighlightData[]>> blockQueue = new ArrayList<Callable<DocHighlightData[]>>();
        TaskExecutor taskExecutor = this.searcher.getTaskExecutor();
        IOConsumer<ArrayList> drainQueue = maxBlocksProcessedInParallel == 1 ? queue -> {
            for (Callable callable : queue) {
                try {
                    this.processBlock((DocHighlightData[])callable.call(), consumer);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            queue.clear();
        } : queue -> {
            for (DocHighlightData[] highlightData : taskExecutor.invokeAll(queue)) {
                this.processBlock(highlightData, consumer);
            }
            queue.clear();
        };
        int previousDocId = -1;
        int[] block = new int[maxBlockSize];
        int blockPos = 0;
        while (docIds.hasNext()) {
            int docId = docIds.nextInt();
            if (docId < previousDocId) {
                throw new RuntimeException("Input document IDs must be sorted (increasing).");
            }
            previousDocId = docId;
            block[blockPos++] = docId;
            if (blockPos < maxBlockSize && docIds.hasNext()) continue;
            int[] idBlock = ArrayUtil.copyOfSubArray(block, 0, blockPos);
            blockQueue.add(() -> this.prepareBlock(idBlock, maxHitsPerField));
            blockPos = 0;
            if (blockQueue.size() < maxBlocksProcessedInParallel) continue;
            drainQueue.accept(blockQueue);
        }
        if (!blockQueue.isEmpty()) {
            drainQueue.accept(blockQueue);
        }
    }

    private DocHighlightData[] prepareBlock(int[] idBlock, ToIntFunction<String> maxHitsPerField) throws IOException {
        DocHighlightData[] docData = new DocHighlightData[idBlock.length];
        Iterator<LeafReaderContext> ctx = this.leaves.iterator();
        LeafReaderContext currentContext = ctx.next();
        LeafReader reader = currentContext.reader();
        for (int i = 0; i < idBlock.length; ++i) {
            int docId = idBlock[i];
            while (docId >= currentContext.docBase + reader.maxDoc()) {
                currentContext = ctx.next();
                reader = currentContext.reader();
            }
            int contextRelativeDocId = docId - currentContext.docBase;
            StoredFieldsVisitor fieldVisitor = new StoredFieldsVisitor(this.shouldLoadStoredField);
            StoredFields storedFields = reader.storedFields();
            storedFields.document(contextRelativeDocId, fieldVisitor);
            TreeMap<String, List<OffsetRange>> highlights = new TreeMap<String, List<OffsetRange>>();
            this.highlightDocument(currentContext, contextRelativeDocId, fieldVisitor, maxHitsPerField, highlights);
            docData[i] = new DocHighlightData(docId, reader, contextRelativeDocId, fieldVisitor, highlights);
        }
        return docData;
    }

    private void processBlock(DocHighlightData[] docHighlightData, MatchOffsetsConsumer consumer) throws IOException {
        for (DocHighlightData data : docHighlightData) {
            consumer.accept(data.docId, data.leafReader, data.leafDocId, data.fieldValueProvider, data.hits);
        }
    }

    public void highlightDocument(LeafReaderContext leafReaderContext, int contextDocId, FieldValueProvider doc, ToIntFunction<String> maxHitsPerField, Map<String, List<OffsetRange>> outputHighlights) throws IOException {
        Matches matches = this.weight.matches(leafReaderContext, contextDocId);
        if (matches == null) {
            return;
        }
        for (String field : this.queryAffectedHighlightedFields) {
            List<OffsetRange> ranges;
            MatchesIterator matchesIterator = matches.getMatches(field);
            if (matchesIterator == null) continue;
            OffsetsRetrievalStrategy offsetStrategy = this.offsetStrategies.get(field);
            if (offsetStrategy == null) {
                throw new IOException("Non-empty matches but no offset retrieval strategy for field: " + field);
            }
            OffsetsRetrievalStrategy delegate = offsetStrategy;
            int maxHits = maxHitsPerField.applyAsInt(field);
            if (maxHits != Integer.MAX_VALUE) {
                offsetStrategy = (matchesIterator1, doc1) -> delegate.get(new MatchesIteratorWithLimit(matchesIterator1, maxHits), doc1);
            }
            if ((ranges = offsetStrategy.get(matchesIterator, doc)).isEmpty()) continue;
            outputHighlights.put(field, ranges);
        }
    }

    private boolean checkOrderConsistency(List<LeafReaderContext> leaves) {
        for (int i = 1; i < leaves.size(); ++i) {
            LeafReaderContext prev = leaves.get(i - 1);
            LeafReaderContext next = leaves.get(i);
            assert (prev.docBase <= next.docBase);
            assert (prev.docBase + prev.reader().maxDoc() == next.docBase);
        }
        return true;
    }

    public static OffsetsRetrievalStrategySupplier computeOffsetRetrievalStrategies(IndexReader reader, Analyzer analyzer) {
        FieldInfos fieldInfos = FieldInfos.getMergedFieldInfos(reader);
        return field -> {
            FieldInfo fieldInfo = fieldInfos.fieldInfo((String)field);
            if (fieldInfo == null) {
                return (mi, doc) -> {
                    throw new IOException("FieldInfo is null for field: " + field);
                };
            }
            switch (fieldInfo.getIndexOptions()) {
                case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                    return new OffsetsFromMatchIterator((String)field, new OffsetsFromPositions((String)field, analyzer));
                }
                case DOCS_AND_FREQS_AND_POSITIONS: {
                    return new OffsetsFromPositions((String)field, analyzer);
                }
                case DOCS_AND_FREQS: 
                case DOCS: {
                    return new OffsetsFromTokens((String)field, analyzer);
                }
            }
            return (matchesIterator, doc) -> {
                throw new IOException("Field is indexed without positions and/or offsets: " + field + ", " + String.valueOf((Object)fieldInfo.getIndexOptions()));
            };
        };
    }

    @FunctionalInterface
    public static interface MatchOffsetsConsumer {
        public void accept(int var1, LeafReader var2, int var3, FieldValueProvider var4, Map<String, List<OffsetRange>> var5) throws IOException;
    }

    private record DocHighlightData(int docId, LeafReader leafReader, int leafDocId, FieldValueProvider fieldValueProvider, Map<String, List<OffsetRange>> hits) {
    }

    private static class StoredFieldsVisitor
    extends StoredFieldVisitor
    implements FieldValueProvider {
        private final Predicate<String> needsField;
        private final LinkedHashMap<String, List<String>> fieldValues = new LinkedHashMap();

        public StoredFieldsVisitor(Predicate<String> shouldLoadStoredField) {
            this.needsField = shouldLoadStoredField;
        }

        @Override
        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return this.needsField.test(fieldInfo.name) ? StoredFieldVisitor.Status.YES : StoredFieldVisitor.Status.NO;
        }

        @Override
        public List<String> getValues(String field) {
            List<String> values = this.fieldValues.get(field);
            return values == null ? List.of() : values;
        }

        @Override
        public void stringField(FieldInfo fieldInfo, String value) throws IOException {
            this.addField(fieldInfo, value);
        }

        @Override
        public void intField(FieldInfo fieldInfo, int value) throws IOException {
            this.addField(fieldInfo, Integer.toString(value));
        }

        @Override
        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            this.addField(fieldInfo, Long.toString(value));
        }

        @Override
        public void floatField(FieldInfo fieldInfo, float value) throws IOException {
            this.addField(fieldInfo, Float.toString(value));
        }

        @Override
        public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
            this.addField(fieldInfo, Double.toString(value));
        }

        private void addField(FieldInfo field, String value) {
            this.fieldValues.computeIfAbsent(field.name, v -> new ArrayList()).add(value);
        }

        @Override
        public Iterator<String> iterator() {
            return this.fieldValues.keySet().iterator();
        }
    }

    public static interface FieldValueProvider
    extends Iterable<String> {
        public List<String> getValues(String var1);
    }

    private static class MatchesIteratorWithLimit
    extends FilterMatchesIterator {
        private int limit;

        public MatchesIteratorWithLimit(MatchesIterator matchesIterator, int limit) {
            super(matchesIterator);
            if (limit < 0) {
                throw new IllegalArgumentException();
            }
            this.limit = limit;
        }

        @Override
        public boolean next() throws IOException {
            if (this.limit == 0) {
                return false;
            }
            --this.limit;
            return super.next();
        }
    }
}

