/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchParseException;
import org.opensearch.Version;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.collect.Tuple;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.breaker.CircuitBreakingException;
import org.opensearch.core.common.io.stream.NotSerializableExceptionWrapper;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.logging.LoggerMessageFormat;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.index.snapshots.IndexShardSnapshotFailedException;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.tasks.TaskCancelledException;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParseException;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@PublicApi(since="1.0.0")
public class OpenSearchException
extends RuntimeException
implements Writeable,
ToXContentFragment {
    protected static final Version UNKNOWN_VERSION_ADDED = Version.fromId(0);
    private static final String REST_EXCEPTION_SKIP_CAUSE = "rest.exception.cause.skip";
    public static final String REST_EXCEPTION_SKIP_STACK_TRACE = "rest.exception.stacktrace.skip";
    public static final boolean REST_EXCEPTION_SKIP_STACK_TRACE_DEFAULT = true;
    private static final boolean REST_EXCEPTION_SKIP_CAUSE_DEFAULT = false;
    private static final String RESOURCE_METADATA_TYPE_KEY = "opensearch.resource.type";
    private static final String RESOURCE_METADATA_ID_KEY = "opensearch.resource.id";
    private static final String INDEX_METADATA_KEY = "opensearch.index";
    private static final String INDEX_METADATA_KEY_UUID = "opensearch.index_uuid";
    private static final String SHARD_METADATA_KEY = "opensearch.shard";
    public static final String OPENSEARCH_PREFIX_KEY = "opensearch.";
    private static final String TYPE = "type";
    private static final String REASON = "reason";
    private static final String CAUSED_BY = "caused_by";
    private static final ParseField SUPPRESSED = new ParseField("suppressed", new String[0]);
    public static final String STACK_TRACE = "stack_trace";
    private static final String HEADER = "header";
    private static final String ERROR = "error";
    private static final String ROOT_CAUSE = "root_cause";
    protected final Map<String, List<String>> metadata = new HashMap<String, List<String>>();
    protected final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public OpenSearchException(Throwable cause) {
        super(cause);
    }

    public OpenSearchException(String msg, Object ... args) {
        super(LoggerMessageFormat.format(msg, args));
    }

    public OpenSearchException(String msg, Throwable cause, Object ... args) {
        super(LoggerMessageFormat.format(msg, args), cause);
    }

    public OpenSearchException(StreamInput in) throws IOException {
        this(in.readOptionalString(), (Throwable)in.readException(), new Object[0]);
        OpenSearchException.readStackTrace(this, in);
        this.headers.putAll(in.readMapOfLists(StreamInput::readString, StreamInput::readString));
        this.metadata.putAll(in.readMapOfLists(StreamInput::readString, StreamInput::readString));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.getMessage());
        out.writeException(this.getCause());
        OpenSearchException.writeStackTraces(this, out, StreamOutput::writeException);
        out.writeMapOfLists(this.headers, StreamOutput::writeString, StreamOutput::writeString);
        out.writeMapOfLists(this.metadata, StreamOutput::writeString, StreamOutput::writeString);
    }

    public void addMetadata(String key, String ... values) {
        this.addMetadata(key, Arrays.asList(values));
    }

    public void addMetadata(String key, List<String> values) {
        if (!key.startsWith(OPENSEARCH_PREFIX_KEY)) {
            throw new IllegalArgumentException("exception metadata must start with [opensearch.], found [" + key + "] instead");
        }
        this.metadata.put(key, values);
    }

    public Set<String> getMetadataKeys() {
        return this.metadata.keySet();
    }

    public List<String> getMetadata(String key) {
        return this.metadata.get(key);
    }

    public Map<String, List<String>> getMetadata() {
        return this.metadata;
    }

    public void addHeader(String key, List<String> value) {
        if (key.startsWith(OPENSEARCH_PREFIX_KEY)) {
            throw new IllegalArgumentException("exception headers must not start with [opensearch.], found [" + key + "] instead");
        }
        this.headers.put(key, value);
    }

    public void addHeader(String key, String ... value) {
        this.addHeader(key, Arrays.asList(value));
    }

    public Set<String> getHeaderKeys() {
        return this.headers.keySet();
    }

    public List<String> getHeader(String key) {
        return this.headers.get(key);
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public RestStatus status() {
        Throwable cause = this.unwrapCause();
        if (cause == this) {
            return RestStatus.INTERNAL_SERVER_ERROR;
        }
        return ExceptionsHelper.status(cause);
    }

    public Throwable unwrapCause() {
        return ExceptionsHelper.unwrapCause(this);
    }

    public String getDetailedMessage() {
        if (this.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.toString()).append("; ");
            if (this.getCause() instanceof OpenSearchException) {
                sb.append(((OpenSearchException)this.getCause()).getDetailedMessage());
            } else {
                sb.append(this.getCause());
            }
            return sb.toString();
        }
        return this.toString();
    }

    public Throwable getRootCause() {
        Throwable rootCause = this;
        for (Throwable cause = this.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    public static <T extends StreamInput> OpenSearchException readException(T input, int id) throws IOException {
        CheckedFunction<StreamInput, ? extends OpenSearchException, IOException> opensearchException = OpenSearchExceptionHandleRegistry.getSupplier(id);
        if (opensearchException == null) {
            throw new IllegalStateException("unknown exception for id: " + id);
        }
        return opensearchException.apply(input);
    }

    public static boolean isRegistered(Class<? extends Throwable> exception, Version version) {
        return OpenSearchExceptionHandleRegistry.isRegistered(exception, version);
    }

    static Set<Class<? extends OpenSearchException>> getRegisteredKeys() {
        return OpenSearchExceptionHandleRegistry.getRegisteredKeys();
    }

    public static int getId(Class<? extends OpenSearchException> exception) {
        return OpenSearchExceptionHandleRegistry.getId(exception);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Throwable ex = ExceptionsHelper.unwrapCause(this);
        if (ex != this) {
            OpenSearchException.generateThrowableXContent(builder, params, this);
        } else {
            OpenSearchException.innerToXContent(builder, params, this, this.getExceptionName(), this.getMessage(), this.headers, this.metadata, this.getCause());
        }
        return builder;
    }

    protected static void innerToXContent(XContentBuilder builder, ToXContent.Params params, Throwable throwable, String type, String message, Map<String, List<String>> headers, Map<String, List<String>> metadata, Throwable cause) throws IOException {
        Throwable[] allSuppressed;
        builder.field(TYPE, type);
        builder.field(REASON, message);
        for (Map.Entry<String, List<String>> entry : metadata.entrySet()) {
            OpenSearchException.headerToXContent(builder, entry.getKey().substring(OPENSEARCH_PREFIX_KEY.length()), entry.getValue());
        }
        if (throwable instanceof OpenSearchException) {
            OpenSearchException exception = (OpenSearchException)throwable;
            exception.metadataToXContent(builder, params);
        }
        if (!params.paramAsBoolean(REST_EXCEPTION_SKIP_CAUSE, false) && cause != null) {
            builder.field(CAUSED_BY);
            builder.startObject();
            OpenSearchException.generateThrowableXContent(builder, params, cause);
            builder.endObject();
        }
        if (!headers.isEmpty()) {
            builder.startObject(HEADER);
            for (Map.Entry entry : headers.entrySet()) {
                OpenSearchException.headerToXContent(builder, (String)entry.getKey(), (List)entry.getValue());
            }
            builder.endObject();
        }
        if (!params.paramAsBoolean(REST_EXCEPTION_SKIP_STACK_TRACE, true)) {
            builder.field(STACK_TRACE, ExceptionsHelper.stackTrace(throwable));
        }
        if ((allSuppressed = throwable.getSuppressed()).length > 0) {
            builder.startArray(SUPPRESSED.getPreferredName());
            for (Throwable suppressed : allSuppressed) {
                builder.startObject();
                OpenSearchException.generateThrowableXContent(builder, params, suppressed);
                builder.endObject();
            }
            builder.endArray();
        }
    }

    protected static void headerToXContent(XContentBuilder builder, String key, List<String> values) throws IOException {
        if (values != null && !values.isEmpty()) {
            if (values.size() == 1) {
                builder.field(key, values.get(0));
            } else {
                builder.startArray(key);
                for (String value : values) {
                    builder.value(value);
                }
                builder.endArray();
            }
        }
    }

    protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    public static OpenSearchException fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
        return OpenSearchException.innerFromXContent(parser, false);
    }

    public static OpenSearchException innerFromXContent(XContentParser parser, boolean parseRootCauses) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
        String type = null;
        String reason = null;
        String stack = null;
        OpenSearchException cause = null;
        HashMap<String, List<String>> metadata = new HashMap<String, List<String>>();
        HashMap<String, List<Object>> headers = new HashMap<String, List<Object>>();
        ArrayList<OpenSearchException> rootCauses = new ArrayList<OpenSearchException>();
        ArrayList<OpenSearchException> suppressed = new ArrayList<OpenSearchException>();
        while (token == XContentParser.Token.FIELD_NAME) {
            String currentFieldName = parser.currentName();
            token = parser.nextToken();
            if (token.isValue()) {
                if (TYPE.equals(currentFieldName)) {
                    type = parser.text();
                } else if (REASON.equals(currentFieldName)) {
                    reason = parser.text();
                } else if (STACK_TRACE.equals(currentFieldName)) {
                    stack = parser.text();
                } else if (token == XContentParser.Token.VALUE_STRING) {
                    metadata.put(currentFieldName, Collections.singletonList(parser.text()));
                }
            } else if (token == XContentParser.Token.START_OBJECT) {
                if (CAUSED_BY.equals(currentFieldName)) {
                    cause = OpenSearchException.fromXContent(parser);
                } else if (HEADER.equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        values = headers.getOrDefault(currentFieldName, new ArrayList());
                        if (token == XContentParser.Token.VALUE_STRING) {
                            values.add(parser.text());
                        } else if (token == XContentParser.Token.START_ARRAY) {
                            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                if (token == XContentParser.Token.VALUE_STRING) {
                                    values.add(parser.text());
                                    continue;
                                }
                                parser.skipChildren();
                            }
                        } else if (token == XContentParser.Token.START_OBJECT) {
                            parser.skipChildren();
                        }
                        headers.put(currentFieldName, values);
                    }
                } else {
                    parser.skipChildren();
                }
            } else if (token == XContentParser.Token.START_ARRAY) {
                if (parseRootCauses && ROOT_CAUSE.equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        rootCauses.add(OpenSearchException.fromXContent(parser));
                    }
                } else if (SUPPRESSED.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        suppressed.add(OpenSearchException.fromXContent(parser));
                    }
                } else {
                    values = new ArrayList();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            values.add(parser.text());
                            continue;
                        }
                        parser.skipChildren();
                    }
                    if (values.size() > 0) {
                        if (metadata.containsKey(currentFieldName)) {
                            values.addAll((Collection)metadata.get(currentFieldName));
                        }
                        metadata.put(currentFieldName, values);
                    }
                }
            }
            token = parser.nextToken();
        }
        OpenSearchException e = new OpenSearchException(OpenSearchException.buildMessage(type, reason, stack), cause, new Object[0]){};
        for (Map.Entry entry : metadata.entrySet()) {
            e.addMetadata(OPENSEARCH_PREFIX_KEY + (String)entry.getKey(), (List)entry.getValue());
        }
        for (Map.Entry header : headers.entrySet()) {
            e.addHeader((String)header.getKey(), (List)header.getValue());
        }
        for (OpenSearchException rootCause : rootCauses) {
            e.addSuppressed(rootCause);
        }
        for (OpenSearchException s : suppressed) {
            e.addSuppressed(s);
        }
        return e;
    }

    public static void generateThrowableXContent(XContentBuilder builder, ToXContent.Params params, Throwable t) throws IOException {
        if ((t = ExceptionsHelper.unwrapCause(t)) instanceof OpenSearchException) {
            ((OpenSearchException)t).toXContent(builder, params);
        } else {
            OpenSearchException.innerToXContent(builder, params, t, OpenSearchException.getExceptionName(t), t.getMessage(), Collections.emptyMap(), Collections.emptyMap(), t.getCause());
        }
    }

    public static void generateFailureXContent(XContentBuilder builder, ToXContent.Params params, @Nullable Exception e, boolean detailed) throws IOException {
        if (e == null) {
            builder.field(ERROR, "unknown");
            return;
        }
        if (!detailed) {
            Throwable unwrapped = ExceptionsHelper.unwrapToOpenSearchException(e);
            builder.field(ERROR, ExceptionsHelper.summaryMessage(unwrapped));
            return;
        }
        OpenSearchException[] rootCauses = OpenSearchException.guessRootCauses(e);
        builder.startObject(ERROR);
        builder.startArray(ROOT_CAUSE);
        for (OpenSearchException rootCause : rootCauses) {
            builder.startObject();
            rootCause.toXContent(builder, new ToXContent.DelegatingMapParams(Collections.singletonMap(REST_EXCEPTION_SKIP_CAUSE, "true"), params));
            builder.endObject();
        }
        builder.endArray();
        OpenSearchException.generateThrowableXContent(builder, params, e);
        builder.endObject();
    }

    public static OpenSearchException failureFromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureFieldName(parser, token, ERROR);
        token = parser.nextToken();
        if (token.isValue()) {
            return new OpenSearchException(OpenSearchException.buildMessage("exception", parser.text(), null), new Object[0]){};
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
        token = parser.nextToken();
        return OpenSearchException.innerFromXContent(parser, true);
    }

    public OpenSearchException[] guessRootCauses() {
        Throwable cause = this.getCause();
        if (cause != null && cause instanceof OpenSearchException) {
            return ((OpenSearchException)cause).guessRootCauses();
        }
        return new OpenSearchException[]{this};
    }

    public static OpenSearchException[] guessRootCauses(Throwable t) {
        Throwable cause;
        Throwable ex = ExceptionsHelper.unwrapCause(t);
        if (ex instanceof OpenSearchException) {
            return ((OpenSearchException)ex).guessRootCauses();
        }
        if (ex instanceof XContentParseException && (cause = ex.getCause()) != null && (cause instanceof XContentParseException || cause instanceof OpenSearchException)) {
            return OpenSearchException.guessRootCauses(ex.getCause());
        }
        return new OpenSearchException[]{new OpenSearchException(ex.getMessage(), ex, new Object[0]){

            @Override
            protected String getExceptionName() {
                return 3.getExceptionName(this.getCause());
            }
        }};
    }

    protected String getExceptionName() {
        return OpenSearchException.getExceptionName(this);
    }

    public static String getExceptionName(Throwable ex) {
        String simpleName = OpenSearchException.getExceptionSimpleClassName(ex);
        if (simpleName.startsWith("OpenSearch")) {
            simpleName = simpleName.substring("OpenSearch".length());
        }
        return OpenSearchException.toUnderscoreCase(simpleName);
    }

    public static String getExceptionSimpleClassName(Throwable ex) {
        String simpleName = ex.getClass().getSimpleName();
        if (Strings.isEmpty(simpleName)) {
            simpleName = "OpenSearchException";
        }
        return simpleName;
    }

    static String buildMessage(String type, String reason, String stack) {
        StringBuilder message = new StringBuilder("OpenSearch exception [");
        message.append(TYPE).append('=').append(type).append(", ");
        message.append(REASON).append('=').append(reason);
        if (stack != null) {
            message.append(", ").append(STACK_TRACE).append('=').append(stack);
        }
        message.append(']');
        return message.toString();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.metadata.containsKey(INDEX_METADATA_KEY)) {
            builder.append(this.getIndex());
            if (this.metadata.containsKey(SHARD_METADATA_KEY)) {
                builder.append('[').append(this.getShardId()).append(']');
            }
            builder.append(' ');
        }
        return builder.append(ExceptionsHelper.detailedMessage(this).trim()).toString();
    }

    public static <T extends Throwable> T readStackTrace(T throwable, StreamInput in) throws IOException {
        throwable.setStackTrace(in.readArray(i -> {
            String declaringClasss = i.readString();
            String fileName = i.readOptionalString();
            String methodName = i.readString();
            int lineNumber = i.readVInt();
            return new StackTraceElement(declaringClasss, methodName, fileName, lineNumber);
        }, StackTraceElement[]::new));
        int numSuppressed = in.readVInt();
        for (int i2 = 0; i2 < numSuppressed; ++i2) {
            throwable.addSuppressed((Throwable)in.readException());
        }
        return throwable;
    }

    public static <S extends StreamOutput, T extends Throwable> T writeStackTraces(T throwable, StreamOutput out, Writeable.Writer<Throwable> exceptionWriter) throws IOException {
        out.writeArray((o, v) -> {
            o.writeString(v.getClassName());
            o.writeOptionalString(v.getFileName());
            o.writeString(v.getMethodName());
            o.writeVInt(v.getLineNumber());
        }, throwable.getStackTrace());
        out.writeArray(exceptionWriter, throwable.getSuppressed());
        return throwable;
    }

    public void setResources(String type, String ... id) {
        assert (type != null);
        this.addMetadata(RESOURCE_METADATA_ID_KEY, id);
        this.addMetadata(RESOURCE_METADATA_TYPE_KEY, type);
    }

    public List<String> getResourceId() {
        return this.getMetadata(RESOURCE_METADATA_ID_KEY);
    }

    public String getResourceType() {
        List<String> header = this.getMetadata(RESOURCE_METADATA_TYPE_KEY);
        if (header != null && !header.isEmpty()) {
            assert (header.size() == 1);
            return header.get(0);
        }
        return null;
    }

    private static String toUnderscoreCase(String value) {
        StringBuilder sb = new StringBuilder();
        boolean changed = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!changed) {
                    for (int j = 0; j < i; ++j) {
                        sb.append(value.charAt(j));
                    }
                    changed = true;
                    if (i == 0) {
                        sb.append(Character.toLowerCase(c));
                        continue;
                    }
                    sb.append('_');
                    sb.append(Character.toLowerCase(c));
                    continue;
                }
                sb.append('_');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (!changed) continue;
            sb.append(c);
        }
        if (!changed) {
            return value;
        }
        return sb.toString();
    }

    static int[] ids() {
        return OpenSearchExceptionHandleRegistry.ids().stream().mapToInt(i -> i).toArray();
    }

    static Tuple<Integer, Class<? extends OpenSearchException>>[] classes() {
        Tuple[] ts = (Tuple[])OpenSearchExceptionHandleRegistry.handles().stream().map(h -> Tuple.tuple(h.id, h.exceptionClass)).toArray(Tuple[]::new);
        return ts;
    }

    public Index getIndex() {
        List<String> index = this.getMetadata(INDEX_METADATA_KEY);
        if (index != null && !index.isEmpty()) {
            List<String> index_uuid = this.getMetadata(INDEX_METADATA_KEY_UUID);
            return new Index(index.get(0), index_uuid.get(0));
        }
        return null;
    }

    public void setIndex(Index index) {
        if (index != null) {
            this.addMetadata(INDEX_METADATA_KEY, index.getName());
            this.addMetadata(INDEX_METADATA_KEY_UUID, index.getUUID());
        }
    }

    public void setIndex(String index) {
        if (index != null) {
            this.setIndex(new Index(index, "_na_"));
        }
    }

    public ShardId getShardId() {
        List<String> shard = this.getMetadata(SHARD_METADATA_KEY);
        if (shard != null && !shard.isEmpty()) {
            return new ShardId(this.getIndex(), Integer.parseInt(shard.get(0)));
        }
        return null;
    }

    public void setShard(ShardId shardId) {
        if (shardId != null) {
            this.setIndex(shardId.getIndex());
            this.addMetadata(SHARD_METADATA_KEY, Integer.toString(shardId.id()));
        }
    }

    static {
        OpenSearchExceptionHandleRegistry.registerExceptionHandle(new OpenSearchExceptionHandle(IndexShardSnapshotFailedException.class, IndexShardSnapshotFailedException::new, 0, UNKNOWN_VERSION_ADDED));
        OpenSearchExceptionHandleRegistry.registerExceptionHandle(new OpenSearchExceptionHandle(OpenSearchParseException.class, OpenSearchParseException::new, 35, UNKNOWN_VERSION_ADDED));
        OpenSearchExceptionHandleRegistry.registerExceptionHandle(new OpenSearchExceptionHandle(ParsingException.class, ParsingException::new, 40, UNKNOWN_VERSION_ADDED));
        OpenSearchExceptionHandleRegistry.registerExceptionHandle(new OpenSearchExceptionHandle(NotSerializableExceptionWrapper.class, NotSerializableExceptionWrapper::new, 62, UNKNOWN_VERSION_ADDED));
        OpenSearchExceptionHandleRegistry.registerExceptionHandle(new OpenSearchExceptionHandle(CircuitBreakingException.class, CircuitBreakingException::new, 133, UNKNOWN_VERSION_ADDED));
        OpenSearchExceptionHandleRegistry.registerExceptionHandle(new OpenSearchExceptionHandle(TaskCancelledException.class, TaskCancelledException::new, 146, UNKNOWN_VERSION_ADDED));
    }

    public static class OpenSearchExceptionHandleRegistry {
        private static final Map<Integer, CheckedFunction<StreamInput, ? extends OpenSearchException, IOException>> ID_TO_SUPPLIER_REGISTRY = new ConcurrentHashMap<Integer, CheckedFunction<StreamInput, ? extends OpenSearchException, IOException>>();
        private static final Map<Class<? extends OpenSearchException>, OpenSearchExceptionHandle> CLASS_TO_OPENSEARCH_EXCEPTION_HANDLE_REGISTRY = new ConcurrentHashMap<Class<? extends OpenSearchException>, OpenSearchExceptionHandle>();

        public static CheckedFunction<StreamInput, ? extends OpenSearchException, IOException> getSupplier(int id) {
            return ID_TO_SUPPLIER_REGISTRY.get(id);
        }

        public static void registerExceptionHandle(OpenSearchExceptionHandle handle) {
            ID_TO_SUPPLIER_REGISTRY.put(handle.id, handle.constructor);
            CLASS_TO_OPENSEARCH_EXCEPTION_HANDLE_REGISTRY.put(handle.exceptionClass, handle);
        }

        public static int getId(Class<? extends OpenSearchException> exception) {
            return OpenSearchExceptionHandleRegistry.CLASS_TO_OPENSEARCH_EXCEPTION_HANDLE_REGISTRY.get(exception).id;
        }

        public static Set<Integer> ids() {
            return ID_TO_SUPPLIER_REGISTRY.keySet();
        }

        public static Collection<OpenSearchExceptionHandle> handles() {
            return CLASS_TO_OPENSEARCH_EXCEPTION_HANDLE_REGISTRY.values();
        }

        public static boolean isRegistered(Class<? extends Throwable> exception, Version version) {
            OpenSearchExceptionHandle openSearchExceptionHandle = CLASS_TO_OPENSEARCH_EXCEPTION_HANDLE_REGISTRY.get(exception);
            if (openSearchExceptionHandle != null) {
                return version.onOrAfter(openSearchExceptionHandle.versionAdded);
            }
            return false;
        }

        public static Set<Class<? extends OpenSearchException>> getRegisteredKeys() {
            return CLASS_TO_OPENSEARCH_EXCEPTION_HANDLE_REGISTRY.keySet();
        }
    }

    protected static class OpenSearchExceptionHandle {
        final Class<? extends OpenSearchException> exceptionClass;
        final CheckedFunction<StreamInput, ? extends OpenSearchException, IOException> constructor;
        final int id;
        final Version versionAdded;

        <E extends OpenSearchException> OpenSearchExceptionHandle(Class<E> exceptionClass, CheckedFunction<StreamInput, E, IOException> constructor, int id, Version versionAdded) {
            this.exceptionClass = exceptionClass;
            this.constructor = constructor;
            this.versionAdded = versionAdded;
            this.id = id;
        }
    }
}

