/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.create;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.support.clustermanager.ShardsAcknowledgedResponse;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

@PublicApi(since="1.0.0")
public class CreateIndexResponse
extends ShardsAcknowledgedResponse {
    private static final ParseField INDEX = new ParseField("index", new String[0]);
    private static final ConstructingObjectParser<CreateIndexResponse, Void> PARSER = new ConstructingObjectParser("create_index", true, args -> new CreateIndexResponse((Boolean)args[0], (Boolean)args[1], (String)args[2]));
    private final String index;

    protected static <T extends CreateIndexResponse> void declareFields(ConstructingObjectParser<T, Void> objectParser) {
        CreateIndexResponse.declareAcknowledgedAndShardsAcknowledgedFields(objectParser);
        objectParser.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.textOrNull(), INDEX, ObjectParser.ValueType.STRING_OR_NULL);
    }

    protected CreateIndexResponse(StreamInput in) throws IOException {
        super(in, true);
        this.index = in.readString();
    }

    public CreateIndexResponse(boolean acknowledged, boolean shardsAcknowledged, String index) {
        super(acknowledged, shardsAcknowledged);
        this.index = index;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeShardsAcknowledged(out);
        out.writeString(this.index);
    }

    public String index() {
        return this.index;
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.addCustomFields(builder, params);
        builder.field(INDEX.getPreferredName(), this.index());
    }

    public static CreateIndexResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            CreateIndexResponse that = (CreateIndexResponse)o;
            return Objects.equals(this.index, that.index);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.index);
    }

    static {
        CreateIndexResponse.declareFields(PARSER);
    }
}

