/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.forcemerge;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.opensearch.action.support.broadcast.BroadcastResponse;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.XContentParser;

@PublicApi(since="1.0.0")
public class ForceMergeResponse
extends BroadcastResponse {
    private static final ConstructingObjectParser<ForceMergeResponse, Void> PARSER = new ConstructingObjectParser("force_merge", true, arg -> {
        BroadcastResponse response = (BroadcastResponse)arg[0];
        return new ForceMergeResponse(response.getTotalShards(), response.getSuccessfulShards(), response.getFailedShards(), Arrays.asList(response.getShardFailures()));
    });

    ForceMergeResponse(StreamInput in) throws IOException {
        super(in);
    }

    ForceMergeResponse(int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
    }

    public static ForceMergeResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append("[");
        builder.append("total_shards=").append(this.getTotalShards()).append(',');
        builder.append("successful_shards=").append(this.getSuccessfulShards()).append(',');
        builder.append("failed_shards=").append(this.getFailedShards()).append(',');
        builder.append("failures=").append(Arrays.asList(this.getShardFailures()).subList(0, Math.min(3, this.getShardFailures().length)));
        return builder.append(']').toString();
    }

    static {
        ForceMergeResponse.declareBroadcastFields(PARSER);
    }
}

