/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.readonly;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.AcknowledgedRequest;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.util.CollectionUtils;

@PublicApi(since="1.0.0")
public class AddIndexBlockRequest
extends AcknowledgedRequest<AddIndexBlockRequest>
implements IndicesRequest.Replaceable {
    private final IndexMetadata.APIBlock block;
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

    public AddIndexBlockRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.block = IndexMetadata.APIBlock.readFrom(in);
    }

    public AddIndexBlockRequest(IndexMetadata.APIBlock block, String ... indices) {
        this.block = Objects.requireNonNull(block);
        this.indices = Objects.requireNonNull(indices);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (CollectionUtils.isEmpty(this.indices)) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        if (this.block == IndexMetadata.APIBlock.READ_ONLY_ALLOW_DELETE) {
            validationException = ValidateActions.addValidationError("read_only_allow_delete block is for internal use only", validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public AddIndexBlockRequest indices(String ... indices) {
        this.indices = Objects.requireNonNull(indices);
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public AddIndexBlockRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public IndexMetadata.APIBlock getBlock() {
        return this.block;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        this.block.writeTo(out);
    }
}

