/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.template.put;

import java.io.IOException;
import org.opensearch.action.admin.indices.template.put.PutComponentTemplateAction;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.ComponentTemplate;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.MetadataIndexTemplateService;
import org.opensearch.cluster.metadata.Template;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.index.mapper.MappingTransformerRegistry;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import reactor.util.annotation.NonNull;

public class TransportPutComponentTemplateAction
extends TransportClusterManagerNodeAction<PutComponentTemplateAction.Request, AcknowledgedResponse> {
    private final MetadataIndexTemplateService indexTemplateService;
    private final IndexScopedSettings indexScopedSettings;
    private final MappingTransformerRegistry mappingTransformerRegistry;

    @Inject
    public TransportPutComponentTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexScopedSettings indexScopedSettings, MappingTransformerRegistry mappingTransformerRegistry) {
        super("cluster:admin/component_template/put", transportService, clusterService, threadPool, actionFilters, PutComponentTemplateAction.Request::new, indexNameExpressionResolver);
        this.indexTemplateService = indexTemplateService;
        this.indexScopedSettings = indexScopedSettings;
        this.mappingTransformerRegistry = mappingTransformerRegistry;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(PutComponentTemplateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void clusterManagerOperation(PutComponentTemplateAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        ComponentTemplate componentTemplate = request.componentTemplate();
        Template template = componentTemplate.template();
        if (template.settings() != null) {
            Settings.Builder builder = Settings.builder().put(template.settings()).normalizePrefix("index.");
            Settings settings = builder.build();
            this.indexScopedSettings.validate(settings, true);
            template = new Template(settings, template.mappings(), template.aliases());
            componentTemplate = new ComponentTemplate(template, componentTemplate.version(), componentTemplate.metadata());
        }
        ActionListener<String> mappingTransformListener = this.getMappingTransformListener(request, listener, componentTemplate);
        this.transformMapping(template, mappingTransformListener);
    }

    private ActionListener<String> getMappingTransformListener(@NonNull PutComponentTemplateAction.Request request, @NonNull ActionListener<AcknowledgedResponse> listener, @NonNull ComponentTemplate componentTemplate) {
        return ActionListener.wrap(transformedMappings -> {
            if (transformedMappings != null && componentTemplate.template() != null) {
                componentTemplate.template().setMappings(new CompressedXContent((String)transformedMappings));
            }
            this.indexTemplateService.putComponentTemplate(request.cause(), request.create(), request.name(), request.clusterManagerNodeTimeout(), componentTemplate, listener);
        }, listener::onFailure);
    }

    private void transformMapping(Template template, @NonNull ActionListener<String> mappingTransformListener) {
        if (template == null || template.mappings() == null) {
            mappingTransformListener.onResponse(null);
        } else {
            this.mappingTransformerRegistry.applyTransformers(template.mappings().string(), null, mappingTransformListener);
        }
    }
}

