/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.view;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.admin.indices.view.ViewService;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@ExperimentalApi
public class SearchViewAction
extends ActionType<SearchResponse> {
    public static final SearchViewAction INSTANCE = new SearchViewAction();
    public static final String NAME = "views:data/read/search";

    private SearchViewAction() {
        super(NAME, SearchResponse::new);
    }

    public static class TransportAction
    extends HandledTransportAction<Request, SearchResponse> {
        private final ViewService viewService;

        @Inject
        public TransportAction(TransportService transportService, ActionFilters actionFilters, ViewService viewService) {
            super(SearchViewAction.NAME, transportService, actionFilters, Request::new);
            this.viewService = viewService;
        }

        @Override
        protected void doExecute(Task task, Request request, ActionListener<SearchResponse> listener) {
            this.viewService.searchView(request, listener);
        }
    }

    @ExperimentalApi
    public static class Request
    extends SearchRequest {
        private final String view;

        public Request(String view, SearchRequest searchRequest) {
            super(searchRequest);
            this.view = view;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.view = in.readString();
        }

        public String getView() {
            return this.view;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return this.view.equals(that.view) && super.equals(that);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.view, super.hashCode());
        }

        @Override
        public ActionRequestValidationException validate() {
            Function<String, String> unsupported = x -> x + " is not supported when searching views";
            ActionRequestValidationException validationException = super.validate();
            if (this.scroll() != null) {
                validationException = ValidateActions.addValidationError(unsupported.apply("Scroll"), validationException);
            }
            if (Strings.isNullOrEmpty(this.view)) {
                validationException = ValidateActions.addValidationError("View is required", validationException);
            }
            return validationException;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.view);
        }

        @Override
        public String toString() {
            return super.toString().replace("SearchRequest{", "SearchViewAction.Request{view=" + this.view + ",");
        }
    }
}

