/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.view;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.indices.view.CreateViewAction;
import org.opensearch.action.admin.indices.view.GetViewAction;
import org.opensearch.action.admin.indices.view.ViewService;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.View;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

@ExperimentalApi
public class UpdateViewAction
extends ActionType<GetViewAction.Response> {
    public static final UpdateViewAction INSTANCE = new UpdateViewAction();
    public static final String NAME = "cluster:admin/views/update";

    public UpdateViewAction() {
        super(NAME, GetViewAction.Response::new);
    }

    @ExperimentalApi
    public static class TransportAction
    extends TransportClusterManagerNodeAction<CreateViewAction.Request, GetViewAction.Response> {
        private final ViewService viewService;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ViewService viewService) {
            super(UpdateViewAction.NAME, transportService, clusterService, threadPool, actionFilters, CreateViewAction.Request::new, indexNameExpressionResolver);
            this.viewService = viewService;
        }

        @Override
        protected String executor() {
            return "management";
        }

        @Override
        protected GetViewAction.Response read(StreamInput in) throws IOException {
            return new GetViewAction.Response(in);
        }

        @Override
        protected void clusterManagerOperation(CreateViewAction.Request request, ClusterState state, ActionListener<GetViewAction.Response> listener) throws Exception {
            this.viewService.updateView(request, listener);
        }

        @Override
        protected ClusterBlockException checkBlock(CreateViewAction.Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }
    }

    @ExperimentalApi
    public static class Request {
        private static final ConstructingObjectParser<CreateViewAction.Request, String> PARSER = new ConstructingObjectParser<CreateViewAction.Request, String>("create_view_request", false, (args, viewName) -> new CreateViewAction.Request((String)viewName, (String)args[0], (List)args[1]));

        public static CreateViewAction.Request fromXContent(XContentParser parser, String viewName) throws IOException {
            return PARSER.parse(parser, viewName);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), View.DESCRIPTION_FIELD);
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> CreateViewAction.Request.Target.fromXContent(p), View.TARGETS_FIELD);
        }
    }
}

