/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support.replication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.opensearch.action.support.RetryableAction;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.shard.IndexShardClosedException;
import org.opensearch.index.shard.PrimaryShardClosedException;
import org.opensearch.index.shard.ReplicationGroup;
import org.opensearch.threadpool.ThreadPool;

@PublicApi(since="1.0.0")
public class PendingReplicationActions
implements Consumer<ReplicationGroup>,
Releasable {
    private final Map<String, Set<RetryableAction<?>>> onGoingReplicationActions = ConcurrentCollections.newConcurrentMap();
    private final ShardId shardId;
    private final ThreadPool threadPool;
    private volatile long replicationGroupVersion = -1L;

    public PendingReplicationActions(ShardId shardId, ThreadPool threadPool) {
        this.shardId = shardId;
        this.threadPool = threadPool;
    }

    public void addPendingAction(String allocationId, RetryableAction<?> replicationAction) {
        Set<RetryableAction<?>> ongoingActionsOnNode = this.onGoingReplicationActions.get(allocationId);
        if (ongoingActionsOnNode != null) {
            ongoingActionsOnNode.add(replicationAction);
            if (!this.onGoingReplicationActions.containsKey(allocationId)) {
                replicationAction.cancel(new IndexShardClosedException(this.shardId, "Replica unavailable - replica could have left ReplicationGroup or IndexShard might have closed"));
            }
        } else {
            replicationAction.cancel(new IndexShardClosedException(this.shardId, "Replica unavailable - replica could have left ReplicationGroup or IndexShard might have closed"));
        }
    }

    public void removeReplicationAction(String allocationId, RetryableAction<?> action) {
        Set<RetryableAction<?>> ongoingActionsOnNode = this.onGoingReplicationActions.get(allocationId);
        if (ongoingActionsOnNode != null) {
            ongoingActionsOnNode.remove(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(ReplicationGroup replicationGroup) {
        if (this.isNewerVersion(replicationGroup)) {
            PendingReplicationActions pendingReplicationActions = this;
            synchronized (pendingReplicationActions) {
                if (this.isNewerVersion(replicationGroup)) {
                    this.acceptNewTrackedAllocationIds(replicationGroup.getTrackedAllocationIds());
                    this.replicationGroupVersion = replicationGroup.getVersion();
                }
            }
        }
    }

    private boolean isNewerVersion(ReplicationGroup replicationGroup) {
        return replicationGroup.getVersion() - this.replicationGroupVersion > 0L;
    }

    synchronized void acceptNewTrackedAllocationIds(Set<String> trackedAllocationIds) {
        for (String targetAllocationId : trackedAllocationIds) {
            this.onGoingReplicationActions.putIfAbsent(targetAllocationId, ConcurrentCollections.newConcurrentSet());
        }
        ArrayList toCancel = new ArrayList();
        for (String allocationId : this.onGoingReplicationActions.keySet()) {
            if (trackedAllocationIds.contains(allocationId)) continue;
            toCancel.add(this.onGoingReplicationActions.remove(allocationId));
        }
        this.cancelActions(toCancel, () -> new IndexShardClosedException(this.shardId, "Replica left ReplicationGroup"));
    }

    @Override
    public synchronized void close() {
        ArrayList toCancel = new ArrayList(this.onGoingReplicationActions.values());
        this.onGoingReplicationActions.clear();
        this.cancelActions(toCancel, () -> new PrimaryShardClosedException(this.shardId));
    }

    private void cancelActions(ArrayList<Set<RetryableAction<?>>> toCancel, Supplier<IndexShardClosedException> exceptionSupplier) {
        this.threadPool.executor("generic").execute(() -> toCancel.stream().flatMap(Collection::stream).forEach(arg_0 -> PendingReplicationActions.lambda$cancelActions$1((Supplier)exceptionSupplier, arg_0)));
    }

    private static /* synthetic */ void lambda$cancelActions$1(Supplier exceptionSupplier, RetryableAction action) {
        action.cancel((Exception)exceptionSupplier.get());
    }
}

