/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.node;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.Version;
import org.opensearch.cluster.node.DiscoveryNodeRole;
import org.opensearch.common.UUIDs;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.io.stream.BufferedChecksumStreamOutput;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.VerifiableWriteable;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.node.Node;
import org.opensearch.node.NodeRoleSettings;
import org.opensearch.node.remotestore.RemoteStoreNodeAttribute;

@PublicApi(since="1.0.0")
public class DiscoveryNode
implements VerifiableWriteable,
ToXContentFragment {
    static final String COORDINATING_ONLY = "coordinating_only";
    private final String nodeName;
    private final String nodeId;
    private final String ephemeralId;
    private final String hostName;
    private final String hostAddress;
    private final TransportAddress address;
    private final TransportAddress streamAddress;
    private final Map<String, String> attributes;
    private final Version version;
    private final SortedSet<DiscoveryNodeRole> roles;
    private static Map<String, DiscoveryNodeRole> roleMap = DiscoveryNode.rolesToMap(DiscoveryNodeRole.BUILT_IN_ROLES.stream());

    public static boolean nodeRequiresLocalStorage(Settings settings) {
        boolean localStorageEnable = Node.NODE_LOCAL_STORAGE_SETTING.get(settings);
        if (!localStorageEnable && (DiscoveryNode.isDataNode(settings) || DiscoveryNode.isClusterManagerNode(settings))) {
            throw new IllegalArgumentException("storage can not be disabled for cluster-manager and data nodes");
        }
        return localStorageEnable;
    }

    public static boolean hasRole(Settings settings, DiscoveryNodeRole role) {
        if (settings.hasValue("node.roles")) {
            return settings.getAsList("node.roles").contains(role.roleName());
        }
        if (role.legacySetting() != null && settings.hasValue(role.legacySetting().getKey())) {
            return role.legacySetting().get(settings);
        }
        return role.isEnabledByDefault(settings);
    }

    public static boolean isClusterManagerNode(Settings settings) {
        return DiscoveryNode.hasRole(settings, DiscoveryNodeRole.MASTER_ROLE) || DiscoveryNode.hasRole(settings, DiscoveryNodeRole.CLUSTER_MANAGER_ROLE);
    }

    public static boolean isDataNode(Settings settings) {
        return DiscoveryNode.getRolesFromSettings(settings).stream().anyMatch(DiscoveryNodeRole::canContainData);
    }

    public static boolean isIngestNode(Settings settings) {
        return DiscoveryNode.hasRole(settings, DiscoveryNodeRole.INGEST_ROLE);
    }

    public static boolean isRemoteClusterClient(Settings settings) {
        return DiscoveryNode.hasRole(settings, DiscoveryNodeRole.REMOTE_CLUSTER_CLIENT_ROLE);
    }

    public static boolean isWarmNode(Settings settings) {
        return DiscoveryNode.hasRole(settings, DiscoveryNodeRole.WARM_ROLE);
    }

    public static boolean isDedicatedWarmNode(Settings settings) {
        return DiscoveryNode.getRolesFromSettings(settings).stream().allMatch(DiscoveryNodeRole.WARM_ROLE::equals);
    }

    public DiscoveryNode(String id, TransportAddress address, Version version) {
        this(id, address, Collections.emptyMap(), DiscoveryNodeRole.BUILT_IN_ROLES, version);
    }

    public DiscoveryNode(String id, TransportAddress address, Map<String, String> attributes, Set<DiscoveryNodeRole> roles, Version version) {
        this("", id, address, attributes, roles, version);
    }

    public DiscoveryNode(String nodeName, String nodeId, TransportAddress address, Map<String, String> attributes, Set<DiscoveryNodeRole> roles, Version version) {
        this(nodeName, nodeId, UUIDs.randomBase64UUID(), address.address().getHostString(), address.getAddress(), address, attributes, roles, version);
    }

    public DiscoveryNode(String nodeName, String nodeId, String ephemeralId, String hostName, String hostAddress, TransportAddress address, Map<String, String> attributes, Set<DiscoveryNodeRole> roles, Version version) {
        this(nodeName, nodeId, ephemeralId, hostName, hostAddress, address, null, attributes, roles, version);
    }

    public DiscoveryNode(String nodeName, String nodeId, String ephemeralId, String hostName, String hostAddress, TransportAddress address, TransportAddress streamAddress, Map<String, String> attributes, Set<DiscoveryNodeRole> roles, Version version) {
        this.nodeName = nodeName != null ? nodeName.intern() : "";
        this.nodeId = nodeId.intern();
        this.ephemeralId = ephemeralId.intern();
        this.hostName = hostName.intern();
        this.hostAddress = hostAddress.intern();
        this.address = address;
        this.streamAddress = streamAddress;
        this.version = version == null ? Version.CURRENT : version;
        this.attributes = Collections.unmodifiableMap(attributes);
        Predicate<Map> predicate = attrs -> {
            boolean success = true;
            for (DiscoveryNodeRole role : roleMap.values()) {
                assert (success &= !attrs.containsKey(role.roleName())) : role.roleName();
            }
            return success;
        };
        assert (predicate.test(attributes)) : attributes;
        this.roles = Collections.unmodifiableSortedSet(new TreeSet<DiscoveryNodeRole>(roles));
    }

    public DiscoveryNode(DiscoveryNode node, TransportAddress streamAddress) {
        this(node.getName(), node.getId(), node.getEphemeralId(), node.getHostName(), node.getHostAddress(), node.getAddress(), streamAddress, node.getAttributes(), node.getRoles(), node.getVersion());
    }

    public static DiscoveryNode createLocal(Settings settings, TransportAddress publishAddress, String nodeId) {
        Map<String, String> attributes = Node.NODE_ATTRIBUTES.getAsMap(settings);
        Set<DiscoveryNodeRole> roles = DiscoveryNode.getRolesFromSettings(settings);
        return new DiscoveryNode(Node.NODE_NAME_SETTING.get(settings), nodeId, publishAddress, attributes, roles, Version.CURRENT);
    }

    public static Set<DiscoveryNodeRole> getRolesFromSettings(Settings settings) {
        if (NodeRoleSettings.NODE_ROLES_SETTING.exists(settings)) {
            DiscoveryNode.validateLegacySettings(settings, roleMap);
            return Collections.unmodifiableSet(new HashSet(NodeRoleSettings.NODE_ROLES_SETTING.get(settings)));
        }
        return roleMap.values().stream().filter(s -> s.isEnabledByDefault(settings)).collect(Collectors.toSet());
    }

    private static void validateLegacySettings(Settings settings, Map<String, DiscoveryNodeRole> roleMap) {
        for (DiscoveryNodeRole role : roleMap.values()) {
            if (role.legacySetting() == null || !role.legacySetting().exists(settings)) continue;
            String message = String.format(Locale.ROOT, "can not explicitly configure node roles and use legacy role setting [%s]=[%s]", role.legacySetting().getKey(), role.legacySetting().get(settings));
            throw new IllegalArgumentException(message);
        }
    }

    public DiscoveryNode(StreamInput in) throws IOException {
        this.nodeName = in.readString().intern();
        this.nodeId = in.readString().intern();
        this.ephemeralId = in.readString().intern();
        this.hostName = in.readString().intern();
        this.hostAddress = in.readString().intern();
        this.address = new TransportAddress(in);
        this.streamAddress = in.getVersion().onOrAfter(Version.V_3_2_0) ? in.readOptionalWriteable(TransportAddress::new) : null;
        int size = in.readVInt();
        this.attributes = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            this.attributes.put(in.readString(), in.readString());
        }
        int rolesSize = in.readVInt();
        HashSet<DiscoveryNodeRole> roles = new HashSet<DiscoveryNodeRole>(rolesSize);
        for (int i = 0; i < rolesSize; ++i) {
            String roleName = in.readString();
            String roleNameAbbreviation = in.readString();
            boolean canContainData = in.readBoolean();
            DiscoveryNodeRole role = roleMap.get(roleName);
            if (role == null) {
                if (in.getVersion().onOrAfter(Version.V_2_1_0)) {
                    roles.add(new DiscoveryNodeRole.DynamicRole(roleName, roleNameAbbreviation, canContainData));
                    continue;
                }
                roles.add(new DiscoveryNodeRole.UnknownRole(roleName, roleNameAbbreviation, canContainData));
                continue;
            }
            assert (roleName.equals(role.roleName())) : "role name [" + roleName + "] does not match role [" + role.roleName() + "]";
            assert (roleNameAbbreviation.equals(role.roleNameAbbreviation())) : "role name abbreviation [" + roleName + "] does not match role [" + role.roleNameAbbreviation() + "]";
            roles.add(role);
        }
        this.roles = Collections.unmodifiableSortedSet(new TreeSet(roles));
        this.version = in.readVersion();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_2_17_0)) {
            this.writeToUtil(out, false);
        } else {
            this.writeToUtil(out, true);
        }
    }

    public void writeToWithAttribute(StreamOutput out) throws IOException {
        this.writeToUtil(out, true);
    }

    public void writeToUtil(StreamOutput out, boolean includeAllAttributes) throws IOException {
        this.writeNodeDetails(out);
        if (includeAllAttributes) {
            out.writeVInt(this.attributes.size());
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                out.writeString(entry.getKey());
                out.writeString(entry.getValue());
            }
        } else {
            out.writeVInt(0);
        }
        this.writeRolesAndVersion(out);
    }

    @Override
    public void writeVerifiableTo(BufferedChecksumStreamOutput out) throws IOException {
        this.writeNodeDetails(out);
        out.writeMap(this.attributes, StreamOutput::writeString, StreamOutput::writeString);
        this.writeRolesAndVersion(out);
    }

    private void writeNodeDetails(StreamOutput out) throws IOException {
        out.writeString(this.nodeName);
        out.writeString(this.nodeId);
        out.writeString(this.ephemeralId);
        out.writeString(this.hostName);
        out.writeString(this.hostAddress);
        this.address.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_3_2_0)) {
            out.writeOptionalWriteable(this.streamAddress);
        }
    }

    private void writeRolesAndVersion(StreamOutput out) throws IOException {
        out.writeVInt(this.roles.size());
        for (DiscoveryNodeRole role : this.roles) {
            DiscoveryNodeRole compatibleRole = role.getCompatibilityRole(out.getVersion());
            out.writeString(compatibleRole.roleName());
            out.writeString(compatibleRole.roleNameAbbreviation());
            out.writeBoolean(compatibleRole.canContainData());
        }
        out.writeVersion(this.version);
    }

    public TransportAddress getAddress() {
        return this.address;
    }

    public TransportAddress getStreamAddress() {
        return this.streamAddress;
    }

    public String getId() {
        return this.nodeId;
    }

    public String getEphemeralId() {
        return this.ephemeralId;
    }

    public String getName() {
        return this.nodeName;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean isDataNode() {
        return this.roles.stream().anyMatch(DiscoveryNodeRole::canContainData);
    }

    public boolean isClusterManagerNode() {
        return this.roles.contains(DiscoveryNodeRole.MASTER_ROLE) || this.roles.contains(DiscoveryNodeRole.CLUSTER_MANAGER_ROLE);
    }

    public boolean isIngestNode() {
        return this.roles.contains(DiscoveryNodeRole.INGEST_ROLE);
    }

    public boolean isRemoteClusterClient() {
        return this.roles.contains(DiscoveryNodeRole.REMOTE_CLUSTER_CLIENT_ROLE);
    }

    public boolean isWarmNode() {
        return this.roles.contains(DiscoveryNodeRole.WARM_ROLE);
    }

    public boolean isSearchNode() {
        return this.roles.contains(DiscoveryNodeRole.SEARCH_ROLE);
    }

    public boolean isRemoteStoreNode() {
        return RemoteStoreNodeAttribute.isClusterStateRepoConfigured(this.getAttributes()) && RemoteStoreNodeAttribute.isSegmentRepoConfigured(this.getAttributes());
    }

    public boolean isRemoteSegmentStoreNode() {
        return RemoteStoreNodeAttribute.isSegmentRepoConfigured(this.getAttributes());
    }

    public boolean isRemoteStatePublicationEnabled() {
        return RemoteStoreNodeAttribute.isClusterStateRepoConfigured(this.getAttributes()) && RemoteStoreNodeAttribute.isRoutingTableRepoConfigured(this.getAttributes());
    }

    public Set<DiscoveryNodeRole> getRoles() {
        return this.roles;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryNode that = (DiscoveryNode)o;
        return this.ephemeralId.equals(that.ephemeralId);
    }

    public int hashCode() {
        return this.ephemeralId.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.nodeName.length() > 0) {
            sb.append('{').append(this.nodeName).append('}');
        }
        sb.append('{').append(this.nodeId).append('}');
        sb.append('{').append(this.ephemeralId).append('}');
        sb.append('{').append(this.hostName).append('}');
        sb.append('{').append(this.address).append('}');
        if (this.streamAddress != null) {
            sb.append('{').append(this.streamAddress).append('}');
        }
        if (!this.roles.isEmpty()) {
            sb.append('{');
            this.roles.stream().map(DiscoveryNodeRole::roleNameAbbreviation).sorted().forEach(sb::append);
            sb.append('}');
        }
        if (!this.attributes.isEmpty()) {
            sb.append(this.attributes.entrySet().stream().filter(entry -> {
                for (String prefix : RemoteStoreNodeAttribute.REMOTE_STORE_NODE_ATTRIBUTE_KEY_PREFIX) {
                    if (!((String)entry.getKey()).startsWith(prefix)) continue;
                    return false;
                }
                return true;
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        return sb.toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getId());
        builder.field("name", this.getName());
        builder.field("ephemeral_id", this.getEphemeralId());
        builder.field("transport_address", this.getAddress().toString());
        if (this.streamAddress != null) {
            builder.field("stream_transport_address", this.getStreamAddress().toString());
        }
        builder.startObject("attributes");
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            builder.field(entry.getKey(), entry.getValue());
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private static Map<String, DiscoveryNodeRole> rolesToMap(Stream<DiscoveryNodeRole> roles) {
        Stream<DiscoveryNodeRole> rolesWithSearch = Stream.concat(roles, Stream.of(DiscoveryNodeRole.SEARCH_ROLE));
        return Collections.unmodifiableMap(rolesWithSearch.collect(Collectors.toMap(DiscoveryNodeRole::roleName, Function.identity())));
    }

    public static DiscoveryNodeRole getRoleFromRoleName(String roleName) {
        String lowerCasedRoleName = Objects.requireNonNull(roleName).toLowerCase(Locale.ROOT);
        if (roleMap.containsKey(lowerCasedRoleName)) {
            return roleMap.get(lowerCasedRoleName);
        }
        return new DiscoveryNodeRole.DynamicRole(lowerCasedRoleName, lowerCasedRoleName, false);
    }

    public static Set<DiscoveryNodeRole> getPossibleRoles() {
        return Collections.unmodifiableSet(new HashSet<DiscoveryNodeRole>(roleMap.values()));
    }

    public static void setAdditionalRoles(Set<DiscoveryNodeRole> additionalRoles) {
        assert (additionalRoles.stream().allMatch(r -> r.legacySetting() == null || r.legacySetting().isDeprecated())) : additionalRoles;
        Map<String, DiscoveryNodeRole> roleNameToPossibleRoles = DiscoveryNode.rolesToMap(Stream.concat(DiscoveryNodeRole.BUILT_IN_ROLES.stream(), additionalRoles.stream()));
        Map roleNameAbbreviationToPossibleRoles = Collections.unmodifiableMap(roleNameToPossibleRoles.values().stream().collect(Collectors.toMap(DiscoveryNodeRole::roleNameAbbreviation, Function.identity())));
        assert (roleNameToPossibleRoles.size() == roleNameAbbreviationToPossibleRoles.size()) : "roles by name [" + String.valueOf(roleNameToPossibleRoles) + "], roles by name abbreviation [" + String.valueOf(roleNameAbbreviationToPossibleRoles) + "]";
        roleMap = roleNameToPossibleRoles;
    }

    public static void setDeprecatedMasterRole() {
        HashMap<String, DiscoveryNodeRole> modifiableRoleMap = new HashMap<String, DiscoveryNodeRole>(roleMap);
        modifiableRoleMap.put(DiscoveryNodeRole.MASTER_ROLE.roleName(), DiscoveryNodeRole.MASTER_ROLE);
        roleMap = Collections.unmodifiableMap(modifiableRoleMap);
    }

    public static Set<String> getPossibleRoleNames() {
        return roleMap.keySet();
    }
}

