/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.io;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.opensearch.common.io.IndexIOStreamHandler;
import org.opensearch.common.io.IndexIOStreamHandlerFactory;

public class VersionedCodecStreamWrapper<T> {
    private static final Logger logger = LogManager.getLogger(VersionedCodecStreamWrapper.class);
    private final IndexIOStreamHandlerFactory<T> indexIOStreamHandlerFactory;
    private final int minVersion;
    private final int currentVersion;
    private final String codec;

    public VersionedCodecStreamWrapper(IndexIOStreamHandlerFactory<T> indexIOStreamHandlerFactory, int minVersion, int currentVersion, String codec) {
        this.indexIOStreamHandlerFactory = indexIOStreamHandlerFactory;
        this.minVersion = minVersion;
        this.currentVersion = currentVersion;
        this.codec = codec;
    }

    public T readStream(IndexInput indexInput) throws IOException {
        logger.debug("Reading input stream [{}] of length - [{}]", (Object)indexInput.toString(), (Object)indexInput.length());
        try {
            CodecUtil.checksumEntireFile(indexInput);
            int readStreamVersion = this.checkHeader(indexInput);
            return this.getHandlerForVersion(readStreamVersion).readContent(indexInput);
        }
        catch (CorruptIndexException cie) {
            logger.error(() -> new ParameterizedMessage("Error while validating header/footer for [{}]. Total data length [{}]", (Object)indexInput.toString(), (Object)indexInput.length()));
            throw cie;
        }
    }

    public void writeStream(IndexOutput indexOutput, T content) throws IOException {
        this.writeHeader(indexOutput);
        this.getHandlerForVersion(this.currentVersion).writeContent(indexOutput, content);
        this.writeFooter(indexOutput);
    }

    private int checkHeader(IndexInput indexInput) throws IOException {
        return CodecUtil.checkHeader(indexInput, this.codec, this.minVersion, this.currentVersion);
    }

    private void checkFooter(ChecksumIndexInput indexInput) throws IOException {
        CodecUtil.checkFooter(indexInput);
    }

    private void writeHeader(IndexOutput indexOutput) throws IOException {
        CodecUtil.writeHeader(indexOutput, this.codec, this.currentVersion);
    }

    private void writeFooter(IndexOutput indexOutput) throws IOException {
        CodecUtil.writeFooter(indexOutput);
    }

    private IndexIOStreamHandler<T> getHandlerForVersion(int version) {
        return this.indexIOStreamHandlerFactory.getHandler(version);
    }
}

