/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.logging;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.util.StringBuilders;
import org.opensearch.common.logging.OpenSearchLogMessage;
import org.opensearch.core.common.Strings;

@Plugin(category="Converter", name="OpenSearchMessageField")
@ConverterKeys(value={"OpenSearchMessageField"})
public final class OpenSearchMessageFieldConverter
extends LogEventPatternConverter {
    private String key;

    public static OpenSearchMessageFieldConverter newInstance(Configuration config, String[] options) {
        String key = options[0];
        return new OpenSearchMessageFieldConverter(key);
    }

    public OpenSearchMessageFieldConverter(String key) {
        super("OpenSearchMessageField", "OpenSearchMessageField");
        this.key = key;
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        OpenSearchLogMessage logMessage;
        String value;
        if (event.getMessage() instanceof OpenSearchLogMessage && !Strings.isNullOrEmpty(value = (logMessage = (OpenSearchLogMessage)event.getMessage()).getValueFor(this.key))) {
            StringBuilders.appendValue((StringBuilder)toAppendTo, (Object)value);
            return;
        }
        StringBuilders.appendValue((StringBuilder)toAppendTo, (Object)"");
    }
}

