/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.xcontent;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opensearch.common.collect.Tuple;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.XContentLocation;

public class ParseFieldRegistry<T> {
    private final Map<String, Tuple<ParseField, T>> registry = new HashMap<String, Tuple<ParseField, T>>();
    private final String registryName;

    public ParseFieldRegistry(String registryName) {
        this.registryName = registryName;
    }

    public Set<String> getNames() {
        return this.registry.keySet();
    }

    public void register(T value, String name) {
        this.register(value, new ParseField(name, new String[0]));
    }

    public void register(T value, ParseField parseField) {
        Tuple<ParseField, T> parseFieldParserTuple = new Tuple<ParseField, T>(parseField, value);
        for (String name : parseField.getAllNamesIncludedDeprecated()) {
            Tuple<ParseField, T> previousValue = this.registry.putIfAbsent(name, parseFieldParserTuple);
            if (previousValue == null) continue;
            throw new IllegalArgumentException("[" + String.valueOf(previousValue.v2()) + "] already registered for [" + this.registryName + "][" + name + "] while trying to register [" + String.valueOf(value) + "]");
        }
    }

    public T lookup(String name, XContentLocation xContentLocation, DeprecationHandler deprecationHandler) {
        T value = this.lookupReturningNullIfNotFound(name, deprecationHandler);
        if (value == null) {
            throw new ParsingException(xContentLocation, "no [" + this.registryName + "] registered for [" + name + "]", new Object[0]);
        }
        return value;
    }

    public T lookupReturningNullIfNotFound(String name, DeprecationHandler deprecationHandler) {
        Tuple<ParseField, T> parseFieldAndValue = this.registry.get(name);
        if (parseFieldAndValue == null) {
            return null;
        }
        ParseField parseField = parseFieldAndValue.v1();
        T value = parseFieldAndValue.v2();
        boolean match = parseField.match(name, deprecationHandler);
        assert (match) : "ParseField did not match registered name [" + name + "][" + this.registryName + "]";
        return value;
    }
}

