/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.autoforcemerge;

import org.opensearch.common.unit.TimeValue;
import org.opensearch.node.resource.tracker.AverageCpuUsageTracker;
import org.opensearch.node.resource.tracker.AverageMemoryUsageTracker;
import org.opensearch.threadpool.ThreadPool;

public class ResourceTrackerProvider {
    public static final TimeValue SHORT_POLL_INTERVAL = TimeValue.timeValueSeconds(6L);
    public static final TimeValue LONG_POLL_INTERVAL = TimeValue.timeValueSeconds(30L);
    public static final TimeValue SHORT_AVERAGE_WINDOW = TimeValue.timeValueMinutes(1L);
    public static final TimeValue LONG_AVERAGE_WINDOW = TimeValue.timeValueMinutes(5L);
    public static ResourceTrackers resourceTrackers;

    public static ResourceTrackers create(ThreadPool threadPool) {
        resourceTrackers = new ResourceTrackers(new AverageCpuUsageTracker(threadPool, SHORT_POLL_INTERVAL, SHORT_AVERAGE_WINDOW), new AverageCpuUsageTracker(threadPool, LONG_POLL_INTERVAL, LONG_AVERAGE_WINDOW), new AverageMemoryUsageTracker(threadPool, SHORT_POLL_INTERVAL, SHORT_AVERAGE_WINDOW), new AverageMemoryUsageTracker(threadPool, LONG_POLL_INTERVAL, LONG_AVERAGE_WINDOW));
        return resourceTrackers;
    }

    public static class ResourceTrackers {
        public final AverageCpuUsageTracker cpuOneMinute;
        public final AverageCpuUsageTracker cpuFiveMinute;
        public final AverageMemoryUsageTracker jvmOneMinute;
        public final AverageMemoryUsageTracker jvmFiveMinute;

        ResourceTrackers(AverageCpuUsageTracker cpuOneMinute, AverageCpuUsageTracker cpuFiveMinute, AverageMemoryUsageTracker jvmOneMinute, AverageMemoryUsageTracker jvmFiveMinute) {
            this.cpuOneMinute = cpuOneMinute;
            this.cpuFiveMinute = cpuFiveMinute;
            this.jvmOneMinute = jvmOneMinute;
            this.jvmFiveMinute = jvmFiveMinute;
        }

        public void start() {
            this.cpuOneMinute.start();
            this.cpuFiveMinute.start();
            this.jvmOneMinute.start();
            this.jvmFiveMinute.start();
        }

        public void stop() {
            this.cpuOneMinute.stop();
            this.cpuFiveMinute.stop();
            this.jvmOneMinute.stop();
            this.jvmFiveMinute.stop();
        }
    }
}

