/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.comparators.TermOrdValComparator;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.util.BigArrays;
import org.opensearch.index.fielddata.AbstractSortedDocValues;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexOrdinalsFieldData;
import org.opensearch.index.fielddata.LeafOrdinalsFieldData;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.MultiValueMode;
import org.opensearch.search.sort.BucketedSort;
import org.opensearch.search.sort.SortOrder;

public class BytesRefFieldComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexFieldData<?> indexFieldData;

    public BytesRefFieldComparatorSource(IndexFieldData<?> indexFieldData, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        super(missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.STRING;
    }

    @Override
    public Object missingValue(boolean reversed) {
        if (this.sortMissingFirst(this.missingValue) || this.sortMissingLast(this.missingValue)) {
            if (this.sortMissingLast(this.missingValue) ^ reversed) {
                return SortField.STRING_LAST;
            }
            return SortField.STRING_FIRST;
        }
        return null;
    }

    protected SortedBinaryDocValues getValues(LeafReaderContext context) throws IOException {
        return this.indexFieldData.load(context).getBytesValues();
    }

    protected void setScorer(Scorable scorer, LeafReaderContext context) {
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning pruning, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        boolean sortMissingLast = this.sortMissingLast(this.missingValue) ^ reversed;
        final BytesRef missingBytes = (BytesRef)this.missingObject(this.missingValue, reversed);
        if (this.indexFieldData instanceof IndexOrdinalsFieldData) {
            TermOrdValComparator cmp = new TermOrdValComparator(this, numHits, this.indexFieldData.getFieldName(), sortMissingLast, reversed, this.filterPruning(pruning)){
                final /* synthetic */ BytesRefFieldComparatorSource this$0;
                {
                    this.this$0 = this$0;
                    super(numHits, field, sortMissingLast, reverse, pruning);
                }

                @Override
                protected SortedDocValues getSortedDocValues(LeafReaderContext context, String field) throws IOException {
                    SortedDocValues selectedValues;
                    SortedSetDocValues values = ((LeafOrdinalsFieldData)((IndexOrdinalsFieldData)this.this$0.indexFieldData).load(context)).getOrdinalsValues();
                    if (this.this$0.nested == null) {
                        selectedValues = this.this$0.sortMode.select(values);
                    } else {
                        BitSet rootDocs = this.this$0.nested.rootDocs(context);
                        DocIdSetIterator innerDocs = this.this$0.nested.innerDocs(context);
                        int maxChildren = this.this$0.nested.getNestedSort() != null ? this.this$0.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
                        selectedValues = this.this$0.sortMode.select(values, rootDocs, innerDocs, maxChildren);
                    }
                    if (this.this$0.sortMissingFirst(this.this$0.missingValue) || this.this$0.sortMissingLast(this.this$0.missingValue)) {
                        return selectedValues;
                    }
                    return new ReplaceMissing(selectedValues, missingBytes);
                }
            };
            ((FieldComparator)cmp).disableSkipping();
            return cmp;
        }
        return new FieldComparator.TermValComparator(this, numHits, null, sortMissingLast){
            LeafReaderContext leafReaderContext;
            final /* synthetic */ BytesRefFieldComparatorSource this$0;
            {
                this.this$0 = this$0;
                super(numHits, field, sortMissingLast);
            }

            @Override
            protected BinaryDocValues getBinaryDocValues(LeafReaderContext context, String field) throws IOException {
                BinaryDocValues selectedValues;
                this.leafReaderContext = context;
                SortedBinaryDocValues values = this.this$0.getValues(context);
                if (this.this$0.nested == null) {
                    selectedValues = this.this$0.sortMode.select(values, missingBytes);
                } else {
                    BitSet rootDocs = this.this$0.nested.rootDocs(context);
                    DocIdSetIterator innerDocs = this.this$0.nested.innerDocs(context);
                    int maxChildren = this.this$0.nested.getNestedSort() != null ? this.this$0.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
                    selectedValues = this.this$0.sortMode.select(values, missingBytes, rootDocs, innerDocs, context.reader().maxDoc(), maxChildren);
                }
                return selectedValues;
            }

            @Override
            public void setScorer(Scorable scorer) {
                this.this$0.setScorer(scorer, this.leafReaderContext);
            }
        };
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("only supported on numeric fields");
    }

    static class ReplaceMissing
    extends AbstractSortedDocValues {
        final SortedDocValues in;
        final int substituteOrd;
        final BytesRef substituteTerm;
        final boolean exists;
        boolean hasValue;

        ReplaceMissing(SortedDocValues in, BytesRef term) throws IOException {
            this.in = in;
            this.substituteTerm = term;
            int sub = in.lookupTerm(term);
            if (sub < 0) {
                this.substituteOrd = -sub - 1;
                this.exists = false;
            } else {
                this.substituteOrd = sub;
                this.exists = true;
            }
        }

        @Override
        public int ordValue() throws IOException {
            if (!this.hasValue) {
                return this.substituteOrd;
            }
            int ord = this.in.ordValue();
            if (!this.exists && ord >= this.substituteOrd) {
                return ord + 1;
            }
            return ord;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.hasValue = this.in.advanceExact(target);
            return true;
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int getValueCount() {
            if (this.exists) {
                return this.in.getValueCount();
            }
            return this.in.getValueCount() + 1;
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            if (ord == this.substituteOrd) {
                return this.substituteTerm;
            }
            if (!this.exists && ord > this.substituteOrd) {
                return this.in.lookupOrd(ord - 1);
            }
            return this.in.lookupOrd(ord);
        }
    }
}

