/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata.ordinals;

import java.io.IOException;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;

final class GlobalOrdinalMapping
extends SortedSetDocValues {
    private final SortedSetDocValues values;
    private final OrdinalMap ordinalMap;
    private final LongValues mapping;
    private final TermsEnum[] lookups;
    private int docValueCount = 0;
    private int nextOrd = 0;

    GlobalOrdinalMapping(OrdinalMap ordinalMap, SortedSetDocValues values, TermsEnum[] lookups, int segmentIndex) {
        this.values = values;
        this.lookups = lookups;
        this.ordinalMap = ordinalMap;
        this.mapping = ordinalMap.getGlobalOrds(segmentIndex);
    }

    @Override
    public long getValueCount() {
        return this.ordinalMap.getValueCount();
    }

    public long getGlobalOrd(long segmentOrd) {
        return this.mapping.get(segmentOrd);
    }

    @Override
    public boolean advanceExact(int target) throws IOException {
        this.nextOrd = 0;
        this.docValueCount = 0;
        if (this.values.advanceExact(target)) {
            this.docValueCount = this.values.docValueCount();
            return true;
        }
        return false;
    }

    @Override
    public long nextOrd() throws IOException {
        if (++this.nextOrd > this.docValueCount) {
            return Integer.MAX_VALUE;
        }
        long segmentOrd = this.values.nextOrd();
        if (segmentOrd == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return this.getGlobalOrd(segmentOrd);
    }

    @Override
    public BytesRef lookupOrd(long globalOrd) throws IOException {
        long segmentOrd = this.ordinalMap.getFirstSegmentOrd(globalOrd);
        int readerIndex = this.ordinalMap.getFirstSegmentNumber(globalOrd);
        this.lookups[readerIndex].seekExact(segmentOrd);
        return this.lookups[readerIndex].term();
    }

    @Override
    public int docID() {
        return this.values.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.values.nextDoc();
    }

    @Override
    public int advance(int target) throws IOException {
        return this.values.advance(target);
    }

    @Override
    public long cost() {
        return this.values.cost();
    }

    @Override
    public int docValueCount() {
        return this.values.docValueCount();
    }
}

