/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.io.IOException;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.opensearch.Version;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.routing.OperationRouting;
import org.opensearch.common.lucene.search.Queries;
import org.opensearch.index.mapper.Uid;

final class ShardSplittingQuery
extends Query {
    private final IndexMetadata indexMetadata;
    private final int shardId;
    private final BitSetProducer nestedParentBitSetProducer;

    ShardSplittingQuery(IndexMetadata indexMetadata, int shardId, boolean hasNested) {
        this.indexMetadata = indexMetadata;
        this.shardId = shardId;
        this.nestedParentBitSetProducer = hasNested ? ShardSplittingQuery.newParentDocBitSetProducer(indexMetadata.getCreationVersion()) : null;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) {
        return new ConstantScoreWeight(this, this, boost){
            final /* synthetic */ ShardSplittingQuery this$0;
            {
                this.this$0 = this$0;
                super(query, score);
            }

            public String toString() {
                return "weight(delete docs query)";
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                LeafReader leafReader = context.reader();
                FixedBitSet bitSet = new FixedBitSet(leafReader.maxDoc());
                Terms terms = leafReader.terms("_routing");
                Predicate<BytesRef> includeInShard = ref -> {
                    int targetShardId = OperationRouting.generateShardId(this.this$0.indexMetadata, Uid.decodeId(ref.bytes, ref.offset, ref.length), null);
                    return this.this$0.shardId == targetShardId;
                };
                if (terms == null) {
                    assert (!this.this$0.indexMetadata.isRoutingPartitionedIndex());
                    ShardSplittingQuery.findSplitDocs("_id", includeInShard, leafReader, bitSet::set);
                } else {
                    BitSet parentBitSet;
                    if (this.this$0.nestedParentBitSetProducer == null) {
                        parentBitSet = null;
                    } else {
                        parentBitSet = this.this$0.nestedParentBitSetProducer.getBitSet(context);
                        if (parentBitSet == null) {
                            return null;
                        }
                    }
                    if (this.this$0.indexMetadata.isRoutingPartitionedIndex()) {
                        Visitor visitor = this.this$0.new Visitor(leafReader);
                        TwoPhaseIterator twoPhaseIterator = parentBitSet == null ? new RoutingPartitionedDocIdSetIterator(visitor) : new NestedRoutingPartitionedDocIdSetIterator(visitor, parentBitSet);
                        ConstantScoreScorer scorer = new ConstantScoreScorer(this.score(), scoreMode, twoPhaseIterator);
                        return new Weight.DefaultScorerSupplier(scorer);
                    }
                    Function<IntConsumer, IntConsumer> maybeWrapConsumer = consumer -> {
                        if (parentBitSet != null) {
                            return docId -> {
                                if (parentBitSet.get(docId)) {
                                    consumer.accept(docId);
                                }
                            };
                        }
                        return consumer;
                    };
                    ShardSplittingQuery.findSplitDocs("_routing", ref -> {
                        int targetShardId = OperationRouting.generateShardId(this.this$0.indexMetadata, null, ref.utf8ToString());
                        return this.this$0.shardId == targetShardId;
                    }, leafReader, maybeWrapConsumer.apply(bitSet::set));
                    if (terms.getDocCount() != leafReader.maxDoc()) {
                        FixedBitSet hasRoutingValue = new FixedBitSet(leafReader.maxDoc());
                        ShardSplittingQuery.findSplitDocs("_routing", ref -> false, leafReader, maybeWrapConsumer.apply(hasRoutingValue::set));
                        IntConsumer bitSetConsumer = maybeWrapConsumer.apply(bitSet::set);
                        ShardSplittingQuery.findSplitDocs("_id", includeInShard, leafReader, docId -> {
                            if (!hasRoutingValue.get(docId)) {
                                bitSetConsumer.accept(docId);
                            }
                        });
                    }
                    if (parentBitSet != null) {
                        this.this$0.markChildDocs(parentBitSet, bitSet);
                    }
                }
                ConstantScoreScorer scorer = new ConstantScoreScorer(this.score(), scoreMode, new BitSetIterator(bitSet, bitSet.length()));
                return new Weight.DefaultScorerSupplier(scorer);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }

    private void markChildDocs(BitSet parentDocs, BitSet matchingDocs) {
        for (int currentDeleted = 0; currentDeleted < matchingDocs.length() && (currentDeleted = matchingDocs.nextSetBit(currentDeleted)) != Integer.MAX_VALUE; ++currentDeleted) {
            int previousParent = parentDocs.prevSetBit(Math.max(0, currentDeleted - 1));
            for (int i = previousParent + 1; i < currentDeleted; ++i) {
                matchingDocs.set(i);
            }
        }
    }

    @Override
    public String toString(String field) {
        return "shard_splitting_query";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardSplittingQuery that = (ShardSplittingQuery)o;
        if (this.shardId != that.shardId) {
            return false;
        }
        return this.indexMetadata.equals(that.indexMetadata);
    }

    @Override
    public int hashCode() {
        int result = this.indexMetadata.hashCode();
        result = 31 * result + this.shardId;
        return this.classHash() ^ result;
    }

    private static void findSplitDocs(String idField, Predicate<BytesRef> includeInShard, LeafReader leafReader, IntConsumer consumer) throws IOException {
        BytesRef idTerm;
        Terms terms = leafReader.terms(idField);
        TermsEnum iterator = terms.iterator();
        PostingsEnum postingsEnum = null;
        while ((idTerm = iterator.next()) != null) {
            int doc;
            if (includeInShard.test(idTerm)) continue;
            postingsEnum = iterator.postings(postingsEnum);
            while ((doc = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                consumer.accept(doc);
            }
        }
    }

    private static BitSetProducer newParentDocBitSetProducer(Version indexVersionCreated) {
        return context -> {
            Query query = Queries.newNonNestedFilter();
            IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext(context);
            IndexSearcher searcher = new IndexSearcher(topLevelContext);
            searcher.setQueryCache(null);
            Weight weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            Scorer s = weight.scorer(context);
            return s == null ? null : BitSet.of(s.iterator(), context.reader().maxDoc());
        };
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }

    private static final class NestedRoutingPartitionedDocIdSetIterator
    extends TwoPhaseIterator {
        private final Visitor visitor;
        private final BitSet parentDocs;
        private int nextParent = -1;
        private boolean nextParentMatches;

        NestedRoutingPartitionedDocIdSetIterator(Visitor visitor, BitSet parentDocs) {
            super(DocIdSetIterator.all(visitor.leafReader.maxDoc()));
            this.parentDocs = parentDocs;
            this.visitor = visitor;
        }

        @Override
        public boolean matches() throws IOException {
            int doc = this.approximation.docID();
            if (doc > this.nextParent) {
                this.nextParent = this.parentDocs.nextSetBit(doc);
                this.nextParentMatches = this.visitor.matches(this.nextParent);
            }
            return this.nextParentMatches;
        }

        @Override
        public float matchCost() {
            return 42.0f;
        }
    }

    private static final class RoutingPartitionedDocIdSetIterator
    extends TwoPhaseIterator {
        private final Visitor visitor;

        RoutingPartitionedDocIdSetIterator(Visitor visitor) {
            super(DocIdSetIterator.all(visitor.leafReader.maxDoc()));
            this.visitor = visitor;
        }

        @Override
        public boolean matches() throws IOException {
            return this.visitor.matches(this.approximation.docID());
        }

        @Override
        public float matchCost() {
            return 42.0f;
        }
    }

    private final class Visitor
    extends StoredFieldVisitor {
        final LeafReader leafReader;
        private int leftToVisit = 2;
        private final BytesRef spare = new BytesRef();
        private String routing;
        private String id;

        Visitor(LeafReader leafReader) {
            this.leafReader = leafReader;
        }

        @Override
        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            switch (fieldInfo.name) {
                case "_id": {
                    this.id = Uid.decodeId(value);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected field: " + fieldInfo.name);
                }
            }
        }

        @Override
        public void stringField(FieldInfo fieldInfo, String value) throws IOException {
            switch (fieldInfo.name) {
                case "_routing": {
                    this.routing = value;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected field: " + fieldInfo.name);
                }
            }
        }

        @Override
        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            switch (fieldInfo.name) {
                case "_id": 
                case "_routing": {
                    --this.leftToVisit;
                    return StoredFieldVisitor.Status.YES;
                }
            }
            return this.leftToVisit == 0 ? StoredFieldVisitor.Status.STOP : StoredFieldVisitor.Status.NO;
        }

        boolean matches(int doc) throws IOException {
            this.id = null;
            this.routing = null;
            this.leftToVisit = 2;
            this.leafReader.storedFields().document(doc, this);
            assert (this.id != null) : "docID must not be null - we might have hit a nested document";
            int targetShardId = OperationRouting.generateShardId(ShardSplittingQuery.this.indexMetadata, this.id, this.routing);
            return targetShardId != ShardSplittingQuery.this.shardId;
        }
    }
}

