/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.filecache;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.opensearch.index.store.remote.filecache.FileCache;

public class FileCachedIndexInput
extends IndexInput
implements RandomAccessInput {
    protected final FileCache cache;
    protected Path filePath;
    protected IndexInput luceneIndexInput;
    protected final boolean isClone;
    protected volatile boolean closed = false;

    public FileCachedIndexInput(FileCache cache, Path filePath, IndexInput underlyingIndexInput) {
        this(cache, filePath, underlyingIndexInput, false);
    }

    FileCachedIndexInput(FileCache cache, Path filePath, IndexInput underlyingIndexInput, boolean isClone) {
        super("FileCachedIndexInput (path=" + filePath.toString() + ")");
        this.cache = cache;
        this.filePath = filePath;
        this.luceneIndexInput = underlyingIndexInput;
        this.isClone = isClone;
    }

    @Override
    public long getFilePointer() {
        return this.luceneIndexInput.getFilePointer();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.luceneIndexInput.seek(pos);
    }

    @Override
    public long length() {
        return this.luceneIndexInput.length();
    }

    @Override
    public byte readByte() throws IOException {
        return this.luceneIndexInput.readByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.luceneIndexInput.readShort();
    }

    @Override
    public int readInt() throws IOException {
        return this.luceneIndexInput.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.luceneIndexInput.readLong();
    }

    @Override
    public final int readVInt() throws IOException {
        return this.luceneIndexInput.readVInt();
    }

    @Override
    public final long readVLong() throws IOException {
        return this.luceneIndexInput.readVLong();
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.luceneIndexInput.readBytes(b, offset, len);
    }

    @Override
    public byte readByte(long pos) throws IOException {
        return ((RandomAccessInput)((Object)this.luceneIndexInput)).readByte(pos);
    }

    @Override
    public short readShort(long pos) throws IOException {
        return ((RandomAccessInput)((Object)this.luceneIndexInput)).readShort(pos);
    }

    @Override
    public int readInt(long pos) throws IOException {
        return ((RandomAccessInput)((Object)this.luceneIndexInput)).readInt(pos);
    }

    @Override
    public long readLong(long pos) throws IOException {
        return ((RandomAccessInput)((Object)this.luceneIndexInput)).readLong(pos);
    }

    @Override
    public FileCachedIndexInput clone() {
        this.cache.incRef(this.filePath);
        return new FileCachedIndexInput(this.cache, this.filePath, this.luceneIndexInput.clone(), true);
    }

    @Override
    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        throw new UnsupportedOperationException("FileCachedIndexInput couldn't be sliced.");
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.luceneIndexInput.close();
            this.luceneIndexInput = null;
            if (this.isClone) {
                this.cache.decRef(this.filePath);
            }
            this.closed = true;
        }
    }
}

