/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.metadata;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Version;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.store.RemoteSegmentStoreDirectory;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;

@PublicApi(since="2.6.0")
public class RemoteSegmentMetadata {
    public static final int VERSION_ONE = 1;
    public static final int VERSION_TWO = 2;
    public static final int CURRENT_VERSION = 2;
    public static final String METADATA_CODEC = "segment_md";
    private final Map<String, RemoteSegmentStoreDirectory.UploadedSegmentMetadata> metadata;
    private final byte[] segmentInfosBytes;
    private final ReplicationCheckpoint replicationCheckpoint;

    public RemoteSegmentMetadata(Map<String, RemoteSegmentStoreDirectory.UploadedSegmentMetadata> metadata, byte[] segmentInfosBytes, ReplicationCheckpoint replicationCheckpoint) {
        this.metadata = metadata;
        this.segmentInfosBytes = segmentInfosBytes;
        this.replicationCheckpoint = replicationCheckpoint;
    }

    public Map<String, RemoteSegmentStoreDirectory.UploadedSegmentMetadata> getMetadata() {
        return this.metadata;
    }

    public byte[] getSegmentInfosBytes() {
        return this.segmentInfosBytes;
    }

    public long getGeneration() {
        return this.replicationCheckpoint.getSegmentsGen();
    }

    public long getPrimaryTerm() {
        return this.replicationCheckpoint.getPrimaryTerm();
    }

    public ReplicationCheckpoint getReplicationCheckpoint() {
        return this.replicationCheckpoint;
    }

    public Map<String, String> toMapOfStrings() {
        return this.metadata.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((RemoteSegmentStoreDirectory.UploadedSegmentMetadata)entry.getValue()).toString()));
    }

    public static Map<String, RemoteSegmentStoreDirectory.UploadedSegmentMetadata> fromMapOfStrings(Map<String, String> segmentMetadata) {
        return segmentMetadata.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> RemoteSegmentStoreDirectory.UploadedSegmentMetadata.fromString((String)entry.getValue())));
    }

    public void write(IndexOutput out) throws IOException {
        out.writeMapOfStrings(this.toMapOfStrings());
        RemoteSegmentMetadata.writeCheckpointToIndexOutput(this.replicationCheckpoint, out);
        out.writeLong(this.segmentInfosBytes.length);
        out.writeBytes(this.segmentInfosBytes, this.segmentInfosBytes.length);
    }

    public static RemoteSegmentMetadata read(IndexInput indexInput, int version) throws IOException {
        Map<String, String> metadata = indexInput.readMapOfStrings();
        Map<String, RemoteSegmentStoreDirectory.UploadedSegmentMetadata> uploadedSegmentMetadataMap = RemoteSegmentMetadata.fromMapOfStrings(metadata);
        ReplicationCheckpoint replicationCheckpoint = RemoteSegmentMetadata.readCheckpointFromIndexInput(indexInput, uploadedSegmentMetadataMap, version);
        int byteArraySize = (int)indexInput.readLong();
        byte[] segmentInfosBytes = new byte[byteArraySize];
        indexInput.readBytes(segmentInfosBytes, 0, byteArraySize);
        return new RemoteSegmentMetadata(uploadedSegmentMetadataMap, segmentInfosBytes, replicationCheckpoint);
    }

    public static void writeCheckpointToIndexOutput(ReplicationCheckpoint replicationCheckpoint, IndexOutput out) throws IOException {
        ShardId shardId = replicationCheckpoint.getShardId();
        out.writeString(shardId.getIndex().getName());
        out.writeString(shardId.getIndex().getUUID());
        out.writeVInt(shardId.getId());
        out.writeLong(replicationCheckpoint.getPrimaryTerm());
        out.writeLong(replicationCheckpoint.getSegmentsGen());
        out.writeLong(replicationCheckpoint.getSegmentInfosVersion());
        out.writeLong(replicationCheckpoint.getLength());
        out.writeString(replicationCheckpoint.getCodec());
        out.writeLong(replicationCheckpoint.getCreatedTimeStamp());
    }

    private static ReplicationCheckpoint readCheckpointFromIndexInput(IndexInput in, Map<String, RemoteSegmentStoreDirectory.UploadedSegmentMetadata> uploadedSegmentMetadataMap, int version) throws IOException {
        return new ReplicationCheckpoint(new ShardId(new Index(in.readString(), in.readString()), in.readVInt()), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readString(), RemoteSegmentMetadata.toStoreFileMetadata(uploadedSegmentMetadataMap), version >= 2 ? in.readLong() : 0L);
    }

    private static Map<String, StoreFileMetadata> toStoreFileMetadata(Map<String, RemoteSegmentStoreDirectory.UploadedSegmentMetadata> metadata) {
        return metadata.entrySet().stream().map(entry -> new StoreFileMetadata((String)entry.getKey(), ((RemoteSegmentStoreDirectory.UploadedSegmentMetadata)entry.getValue()).getLength(), ((RemoteSegmentStoreDirectory.UploadedSegmentMetadata)entry.getValue()).getChecksum(), Version.LATEST)).collect(Collectors.toMap(StoreFileMetadata::name, Function.identity()));
    }
}

