/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.index.engine.EngineConfig;
import org.opensearch.index.engine.TranslogLeafReader;
import org.opensearch.index.fieldvisitor.FieldsVisitor;
import org.opensearch.index.translog.Translog;

@PublicApi(since="3.1.0")
public abstract class TranslogOperationHelper {
    private static final Logger logger = LogManager.getLogger(TranslogOperationHelper.class);
    public static final TranslogOperationHelper DEFAULT = new TranslogOperationHelper(){};

    private TranslogOperationHelper() {
    }

    public static TranslogOperationHelper create(final EngineConfig engineConfig) {
        return new TranslogOperationHelper(){

            @Override
            public boolean hasSameIndexOperation(Translog.Index op1, Translog.Index op2) {
                boolean hasSameOp;
                boolean bl = hasSameOp = Objects.equals(op1.id(), op2.id()) && Objects.equals(op1.routing(), op2.routing()) && op1.primaryTerm() == op2.primaryTerm() && op1.seqNo() == op2.seqNo() && op1.version() == op2.version();
                hasSameOp = engineConfig.getIndexSettings().isDerivedSourceEnabled() ? (hasSameOp &= 2.compareSourcesWithOrder(TranslogOperationHelper.deriveSource(op1, engineConfig), op2.source()) || 2.compareSourcesWithOrder(op1.source(), TranslogOperationHelper.deriveSource(op2, engineConfig))) : (hasSameOp &= Objects.equals(op1.source(), op2.source()));
                return hasSameOp;
            }
        };
    }

    public boolean hasSameIndexOperation(Translog.Index op1, Translog.Index op2) {
        return Objects.equals(op1.id(), op2.id()) && Objects.equals(op1.source(), op2.source()) && Objects.equals(op1.routing(), op2.routing()) && op1.primaryTerm() == op2.primaryTerm() && op1.seqNo() == op2.seqNo() && op1.version() == op2.version();
    }

    private static BytesReference deriveSource(Translog.Index op, EngineConfig engineConfig) {
        BytesReference bytesReference;
        TranslogLeafReader leafReader = new TranslogLeafReader(op, engineConfig);
        try {
            FieldsVisitor visitor = new FieldsVisitor(true);
            leafReader.storedFields().document(0, visitor);
            bytesReference = visitor.source();
        }
        catch (Throwable throwable) {
            try {
                try {
                    leafReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        leafReader.close();
        return bytesReference;
    }

    public static boolean compareSourcesWithOrder(BytesReference source1, BytesReference source2) {
        if (source1 == null && source2 == null) {
            return true;
        }
        if (source1 == null || source2 == null) {
            return false;
        }
        try {
            Map<String, Object> map1 = XContentHelper.convertToMap(source1, true).v2();
            Map<String, Object> map2 = XContentHelper.convertToMap(source2, true).v2();
            return Objects.deepEquals(map1, map2);
        }
        catch (Exception e) {
            logger.error("Failed to convert source to map", (Throwable)e);
            return false;
        }
    }
}

