/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.join.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.OpenSearchException;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.join.mapper.ParentIdFieldMapper;
import org.opensearch.join.mapper.ParentJoinFieldMapper;
import org.opensearch.search.SearchService;

public final class ParentIdQueryBuilder
extends AbstractQueryBuilder<ParentIdQueryBuilder> {
    public static final String NAME = "parent_id";
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField ID_FIELD = new ParseField("id", new String[0]);
    private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final String type;
    private final String id;
    private boolean ignoreUnmapped = false;

    public ParentIdQueryBuilder(String type, String id) {
        this.type = type;
        this.id = id;
    }

    public ParentIdQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.type = in.readString();
        this.id = in.readString();
        this.ignoreUnmapped = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public ParentIdQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(TYPE_FIELD.getPreferredName(), this.type);
        builder.field(ID_FIELD.getPreferredName(), this.id);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static ParentIdQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        float boost = 1.0f;
        String type = null;
        String id = null;
        String queryName = null;
        String currentFieldName = null;
        boolean ignoreUnmapped = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    type = parser.text();
                    continue;
                }
                if (ID_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    id = parser.text();
                    continue;
                }
                if (IGNORE_UNMAPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    ignoreUnmapped = parser.booleanValue();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    boost = parser.floatValue();
                    continue;
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryName = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[parent_id] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[parent_id] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        ParentIdQueryBuilder queryBuilder = new ParentIdQueryBuilder(type, id);
        queryBuilder.queryName(queryName);
        queryBuilder.boost(boost);
        queryBuilder.ignoreUnmapped(ignoreUnmapped);
        return queryBuilder;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        if (!context.allowExpensiveQueries()) {
            throw new OpenSearchException("[joining] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        ParentJoinFieldMapper joinFieldMapper = ParentJoinFieldMapper.getMapper(context.getMapperService());
        if (joinFieldMapper == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            String indexName = context.getIndexSettings().getIndex().getName();
            throw new QueryShardException(context, "[parent_id] no join field found for index [" + indexName + "]", new Object[0]);
        }
        ParentIdFieldMapper childMapper = joinFieldMapper.getParentIdFieldMapper(this.type, false);
        if (childMapper == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(context, "[parent_id] no relation found for child [" + this.type + "]", new Object[0]);
        }
        return new BooleanQuery.Builder().add(childMapper.fieldType().termQuery(this.id, context), BooleanClause.Occur.MUST).add(joinFieldMapper.fieldType().termQuery(this.type, context), BooleanClause.Occur.FILTER).build();
    }

    @Override
    protected boolean doEquals(ParentIdQueryBuilder that) {
        return Objects.equals(this.type, that.type) && Objects.equals(this.id, that.id) && Objects.equals(this.ignoreUnmapped, that.ignoreUnmapped);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.type, this.id, this.ignoreUnmapped);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

