/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.lucene.util;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;
import org.opensearch.common.Numbers;

public final class UnsignedLongHashSet
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(UnsignedLongHashSet.class);
    private static final long MISSING = Numbers.MIN_UNSIGNED_LONG_VALUE_AS_LONG;
    final long[] table;
    final int mask;
    final boolean hasMissingValue;
    final int size;
    public final long minValue;
    public final long maxValue;

    public UnsignedLongHashSet(long[] values) {
        int tableSize = Math.toIntExact((long)values.length * 3L / 2L);
        tableSize = 1 << PackedInts.bitsRequired(tableSize);
        assert ((long)tableSize >= (long)values.length * 3L / 2L);
        this.table = new long[tableSize];
        Arrays.fill(this.table, MISSING);
        this.mask = tableSize - 1;
        boolean hasMissingValue = false;
        int size = 0;
        long previousValue = Numbers.MIN_UNSIGNED_LONG_VALUE_AS_LONG;
        for (long value : values) {
            if (value == MISSING) {
                size += hasMissingValue ? 0 : 1;
                hasMissingValue = true;
            } else if (this.add(value)) {
                ++size;
            }
            assert (Long.compareUnsigned(value, previousValue) >= 0) : " values must be provided in sorted order";
            previousValue = value;
        }
        this.hasMissingValue = hasMissingValue;
        this.size = size;
        this.minValue = values.length == 0 ? Numbers.MAX_UNSIGNED_LONG_VALUE_AS_LONG : values[0];
        this.maxValue = values.length == 0 ? Numbers.MIN_UNSIGNED_LONG_VALUE_AS_LONG : values[values.length - 1];
    }

    private boolean add(long l) {
        int slot;
        assert (l != MISSING);
        int i = slot = Long.hashCode(l) & this.mask;
        while (true) {
            if (this.table[i] == MISSING) {
                this.table[i] = l;
                return true;
            }
            if (this.table[i] == l) {
                return false;
            }
            i = i + 1 & this.mask;
        }
    }

    public boolean contains(long l) {
        int slot;
        if (l == MISSING) {
            return this.hasMissingValue;
        }
        int i = slot = Long.hashCode(l) & this.mask;
        while (this.table[i] != MISSING) {
            if (this.table[i] == l) {
                return true;
            }
            i = i + 1 & this.mask;
        }
        return false;
    }

    public LongStream stream() {
        LongStream stream = Arrays.stream(this.table).filter(v -> v != MISSING);
        if (this.hasMissingValue) {
            stream = LongStream.concat(LongStream.of(MISSING), stream);
        }
        return stream;
    }

    public int hashCode() {
        return Objects.hash(this.size, this.minValue, this.maxValue, this.mask, this.hasMissingValue, Arrays.hashCode(this.table));
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof UnsignedLongHashSet) {
            UnsignedLongHashSet that = (UnsignedLongHashSet)obj;
            return this.size == that.size && this.minValue == that.minValue && this.maxValue == that.maxValue && this.mask == that.mask && this.hasMissingValue == that.hasMissingValue && Arrays.equals(this.table, that.table);
        }
        return false;
    }

    public String toString() {
        return this.stream().mapToObj(Long::toUnsignedString).collect(Collectors.joining(", ", "[", "]"));
    }

    public int size() {
        return this.size;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.table);
    }
}

