/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugins;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.RequestValidators;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.support.ActionFilter;
import org.opensearch.action.support.TransportAction;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.Strings;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestHeaderDefinition;

public interface ActionPlugin {
    default public List<ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Collections.emptyList();
    }

    default public List<ActionType<? extends ActionResponse>> getClientActions() {
        return this.getActions().stream().map(a -> a.action).collect(Collectors.toList());
    }

    default public List<ActionFilter> getActionFilters() {
        return Collections.emptyList();
    }

    default public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Collections.emptyList();
    }

    default public Collection<RestHeaderDefinition> getRestHeaders() {
        return Collections.emptyList();
    }

    default public Collection<String> getTaskHeaders() {
        return Collections.emptyList();
    }

    default public UnaryOperator<RestHandler> getRestHandlerWrapper(ThreadContext threadContext) {
        return null;
    }

    default public Collection<RequestValidators.RequestValidator<PutMappingRequest>> mappingRequestValidators() {
        return Collections.emptyList();
    }

    default public Collection<RequestValidators.RequestValidator<IndicesAliasesRequest>> indicesAliasesRequestValidators() {
        return Collections.emptyList();
    }

    public static final class ActionHandler<Request extends ActionRequest, Response extends ActionResponse> {
        private final ActionType<Response> action;
        private final Class<? extends TransportAction<Request, Response>> transportAction;
        private final Class<?>[] supportTransportActions;

        public ActionHandler(ActionType<Response> action, Class<? extends TransportAction<Request, Response>> transportAction, Class<?> ... supportTransportActions) {
            this.action = action;
            this.transportAction = transportAction;
            this.supportTransportActions = supportTransportActions;
        }

        public ActionType<Response> getAction() {
            return this.action;
        }

        public Class<? extends TransportAction<Request, Response>> getTransportAction() {
            return this.transportAction;
        }

        public Class<?>[] getSupportTransportActions() {
            return this.supportTransportActions;
        }

        public String toString() {
            StringBuilder b = new StringBuilder().append(this.action.name()).append(" is handled by ").append(this.transportAction.getName());
            if (this.supportTransportActions.length > 0) {
                b.append('[').append(Strings.arrayToCommaDelimitedString(this.supportTransportActions)).append(']');
            }
            return b.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != ActionHandler.class) {
                return false;
            }
            ActionHandler other = (ActionHandler)obj;
            return Objects.equals(this.action, other.action) && Objects.equals(this.transportAction, other.transportAction) && Objects.deepEquals(this.supportTransportActions, other.supportTransportActions);
        }

        public int hashCode() {
            return Objects.hash(this.action, this.transportAction, this.supportTransportActions);
        }
    }
}

