/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script.mustache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.CompositeIndicesRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.script.mustache.SearchTemplateRequest;
import org.opensearch.script.mustache.SearchTemplateRequestBuilder;

public class MultiSearchTemplateRequest
extends ActionRequest
implements CompositeIndicesRequest {
    private int maxConcurrentSearchRequests = 0;
    private List<SearchTemplateRequest> requests = new ArrayList<SearchTemplateRequest>();
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpenAndForbidClosedIgnoreThrottled();

    public MultiSearchTemplateRequest() {
    }

    public MultiSearchTemplateRequest(StreamInput in) throws IOException {
        super(in);
        this.maxConcurrentSearchRequests = in.readVInt();
        this.requests = in.readList(SearchTemplateRequest::new);
    }

    public MultiSearchTemplateRequest add(SearchTemplateRequestBuilder request) {
        this.requests.add((SearchTemplateRequest)request.request());
        return this;
    }

    public MultiSearchTemplateRequest add(SearchTemplateRequest request) {
        this.requests.add(request);
        return this;
    }

    public int maxConcurrentSearchRequests() {
        return this.maxConcurrentSearchRequests;
    }

    public MultiSearchTemplateRequest maxConcurrentSearchRequests(int maxConcurrentSearchRequests) {
        if (maxConcurrentSearchRequests < 1) {
            throw new IllegalArgumentException("maxConcurrentSearchRequests must be positive");
        }
        this.maxConcurrentSearchRequests = maxConcurrentSearchRequests;
        return this;
    }

    public List<SearchTemplateRequest> requests() {
        return this.requests;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("no requests added", validationException);
        }
        for (SearchTemplateRequest request : this.requests) {
            ActionRequestValidationException ex = request.validate();
            if (ex == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors(ex.validationErrors());
        }
        return validationException;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public MultiSearchTemplateRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.maxConcurrentSearchRequests);
        out.writeList(this.requests);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiSearchTemplateRequest that = (MultiSearchTemplateRequest)o;
        return this.maxConcurrentSearchRequests == that.maxConcurrentSearchRequests && Objects.equals(this.requests, that.requests) && Objects.equals(this.indicesOptions, that.indicesOptions);
    }

    public int hashCode() {
        return Objects.hash(this.maxConcurrentSearchRequests, this.requests, this.indicesOptions);
    }

    public static byte[] writeMultiLineFormat(MultiSearchTemplateRequest multiSearchTemplateRequest, XContent xContent) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        for (SearchTemplateRequest templateRequest : multiSearchTemplateRequest.requests()) {
            SearchRequest searchRequest = templateRequest.getRequest();
            try (XContentBuilder xContentBuilder = XContentBuilder.builder(xContent);){
                MultiSearchRequest.writeSearchRequestParams(searchRequest, xContentBuilder);
                BytesReference.bytes(xContentBuilder).writeTo(output);
            }
            output.write(xContent.streamSeparator());
            xContentBuilder = XContentBuilder.builder(xContent);
            try {
                templateRequest.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
                BytesReference.bytes(xContentBuilder).writeTo(output);
            }
            finally {
                if (xContentBuilder != null) {
                    xContentBuilder.close();
                }
            }
            output.write(xContent.streamSeparator());
        }
        return output.toByteArray();
    }
}

