/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.adjacency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.Rewriteable;
import org.opensearch.search.aggregations.AbstractAggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.bucket.adjacency.AdjacencyMatrixAggregator;
import org.opensearch.search.aggregations.bucket.adjacency.AdjacencyMatrixAggregatorFactory;

public class AdjacencyMatrixAggregationBuilder
extends AbstractAggregationBuilder<AdjacencyMatrixAggregationBuilder> {
    public static final String NAME = "adjacency_matrix";
    private static final String DEFAULT_SEPARATOR = "&";
    private static final ParseField SEPARATOR_FIELD = new ParseField("separator", new String[0]);
    private static final ParseField FILTERS_FIELD = new ParseField("filters", new String[0]);
    private static final ParseField SHOW_ONLY_INTERSECTING = new ParseField("show_only_intersecting", new String[0]);
    private List<AdjacencyMatrixAggregator.KeyedFilter> filters;
    private boolean showOnlyIntersecting = false;
    private String separator = "&";
    private static final ObjectParser<AdjacencyMatrixAggregationBuilder, String> PARSER = ObjectParser.fromBuilder("adjacency_matrix", AdjacencyMatrixAggregationBuilder::new);

    public static AggregationBuilder parse(XContentParser parser, String name) throws IOException {
        AdjacencyMatrixAggregationBuilder result = PARSER.parse(parser, name);
        result.checkConsistency();
        return result;
    }

    protected AdjacencyMatrixAggregationBuilder(String name) {
        super(name);
    }

    public AdjacencyMatrixAggregationBuilder(String name, Map<String, QueryBuilder> filters) {
        this(name, DEFAULT_SEPARATOR, filters);
    }

    protected AdjacencyMatrixAggregationBuilder(AdjacencyMatrixAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.filters = new ArrayList<AdjacencyMatrixAggregator.KeyedFilter>(clone.filters);
        this.separator = clone.separator;
        this.showOnlyIntersecting = clone.showOnlyIntersecting;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new AdjacencyMatrixAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public AdjacencyMatrixAggregationBuilder(String name, String separator, Map<String, QueryBuilder> filters) {
        super(name);
        this.separator = separator;
        this.setFiltersAsMap(filters);
    }

    public AdjacencyMatrixAggregationBuilder(String name, Map<String, QueryBuilder> filters, boolean showOnlyIntersecting) {
        this(name, DEFAULT_SEPARATOR, filters, showOnlyIntersecting);
    }

    public AdjacencyMatrixAggregationBuilder(String name, String separator, Map<String, QueryBuilder> filters, boolean showOnlyIntersecting) {
        this(name, separator, filters);
        this.showOnlyIntersecting = showOnlyIntersecting;
    }

    public AdjacencyMatrixAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        int filtersSize = in.readVInt();
        this.separator = in.readString();
        if (in.getVersion().onOrAfter(Version.V_2_19_0)) {
            this.showOnlyIntersecting = in.readBoolean();
        }
        this.filters = new ArrayList<AdjacencyMatrixAggregator.KeyedFilter>(filtersSize);
        for (int i = 0; i < filtersSize; ++i) {
            this.filters.add(new AdjacencyMatrixAggregator.KeyedFilter(in));
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.filters.size());
        out.writeString(this.separator);
        if (out.getVersion().onOrAfter(Version.V_2_19_0)) {
            out.writeBoolean(this.showOnlyIntersecting);
        }
        for (AdjacencyMatrixAggregator.KeyedFilter keyedFilter : this.filters) {
            keyedFilter.writeTo(out);
        }
    }

    private void checkConsistency() {
        if (this.filters == null || this.filters.size() == 0) {
            throw new IllegalStateException("[" + this.name + "] is missing : " + FILTERS_FIELD.getPreferredName() + " parameter");
        }
    }

    private void setFiltersAsMap(Map<String, QueryBuilder> filters) {
        this.filters = new ArrayList<AdjacencyMatrixAggregator.KeyedFilter>(filters.size());
        for (Map.Entry<String, QueryBuilder> kv : filters.entrySet()) {
            this.filters.add(new AdjacencyMatrixAggregator.KeyedFilter(kv.getKey(), kv.getValue()));
        }
        Collections.sort(this.filters, Comparator.comparing(AdjacencyMatrixAggregator.KeyedFilter::key));
    }

    private AdjacencyMatrixAggregationBuilder setFiltersAsList(List<AdjacencyMatrixAggregator.KeyedFilter> filters) {
        this.filters = new ArrayList<AdjacencyMatrixAggregator.KeyedFilter>(filters);
        Collections.sort(this.filters, Comparator.comparing(AdjacencyMatrixAggregator.KeyedFilter::key));
        return this;
    }

    public AdjacencyMatrixAggregationBuilder setShowOnlyIntersecting(boolean showOnlyIntersecting) {
        this.showOnlyIntersecting = showOnlyIntersecting;
        return this;
    }

    public AdjacencyMatrixAggregationBuilder separator(String separator) {
        if (separator == null) {
            throw new IllegalArgumentException("[separator] must not be null: [" + this.name + "]");
        }
        this.separator = separator;
        return this;
    }

    public String separator() {
        return this.separator;
    }

    public Map<String, QueryBuilder> filters() {
        HashMap<String, QueryBuilder> result = new HashMap<String, QueryBuilder>(this.filters.size());
        for (AdjacencyMatrixAggregator.KeyedFilter keyedFilter : this.filters) {
            result.put(keyedFilter.key(), keyedFilter.filter());
        }
        return result;
    }

    public boolean isShowOnlyIntersecting() {
        return this.showOnlyIntersecting;
    }

    @Override
    protected AdjacencyMatrixAggregationBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        boolean modified = false;
        ArrayList<AdjacencyMatrixAggregator.KeyedFilter> rewrittenFilters = new ArrayList<AdjacencyMatrixAggregator.KeyedFilter>(this.filters.size());
        for (AdjacencyMatrixAggregator.KeyedFilter kf : this.filters) {
            QueryBuilder rewritten = Rewriteable.rewrite(kf.filter(), queryShardContext);
            modified = modified || rewritten != kf.filter();
            rewrittenFilters.add(new AdjacencyMatrixAggregator.KeyedFilter(kf.key(), rewritten));
        }
        if (modified) {
            return new AdjacencyMatrixAggregationBuilder(this.name).separator(this.separator).setFiltersAsList(rewrittenFilters).setShowOnlyIntersecting(this.showOnlyIntersecting);
        }
        return this;
    }

    @Override
    protected AggregatorFactory doBuild(QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        int maxFilters = queryShardContext.getIndexSettings().getMaxAdjacencyMatrixFilters();
        if (this.filters.size() > maxFilters) {
            throw new IllegalArgumentException("Number of filters is too large, must be less than or equal to: [" + maxFilters + "] but was [" + this.filters.size() + "].This limit can be set by changing the [" + IndexSettings.MAX_ADJACENCY_MATRIX_FILTERS_SETTING.getKey() + "] index level setting.");
        }
        return new AdjacencyMatrixAggregatorFactory(this.name, this.filters, this.showOnlyIntersecting, this.separator, queryShardContext, parent, subFactoriesBuilder, this.metadata);
    }

    @Override
    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SEPARATOR_FIELD.getPreferredName(), this.separator);
        builder.field(SHOW_ONLY_INTERSECTING.getPreferredName(), this.showOnlyIntersecting);
        builder.startObject(FILTERS_FIELD.getPreferredName());
        for (AdjacencyMatrixAggregator.KeyedFilter keyedFilter : this.filters) {
            builder.field(keyedFilter.key(), keyedFilter.filter());
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.filters, this.showOnlyIntersecting, this.separator);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AdjacencyMatrixAggregationBuilder other = (AdjacencyMatrixAggregationBuilder)obj;
        return Objects.equals(this.filters, other.filters) && Objects.equals(this.separator, other.separator) && Objects.equals(this.showOnlyIntersecting, other.showOnlyIntersecting);
    }

    @Override
    public String getType() {
        return NAME;
    }

    static {
        PARSER.declareString(AdjacencyMatrixAggregationBuilder::separator, SEPARATOR_FIELD);
        PARSER.declareNamedObjects(AdjacencyMatrixAggregationBuilder::setFiltersAsList, AdjacencyMatrixAggregator.KeyedFilter.PARSER, FILTERS_FIELD);
        PARSER.declareBoolean(AdjacencyMatrixAggregationBuilder::setShowOnlyIntersecting, SHOW_ONLY_INTERSECTING);
    }
}

