/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.PriorityQueue;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.opensearch.search.aggregations.InternalOrder;
import org.opensearch.search.aggregations.bucket.LocalBucketCountThresholds;
import org.opensearch.search.aggregations.bucket.terms.InternalTerms;
import org.opensearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;

enum BucketSelectionStrategy {
    PRIORITY_QUEUE{

        @Override
        public <B extends InternalMultiBucketAggregation.InternalBucket> SelectionResult<B> selectTopBuckets(SelectionInput<B> input) throws IOException {
            PriorityQueue ordered = input.buildPriorityQueue.buildPriorityQueue(input.size);
            InternalMultiBucketAggregation.InternalBucket spare = null;
            long otherDocCount = 0L;
            while (input.ordsEnum.next()) {
                long docCount = input.bucketDocCountFunction.bucketDocCount(input.ordsEnum.ord());
                otherDocCount += docCount;
                if (docCount < input.localBucketCountThresholds.getMinDocCount()) continue;
                if (spare == null) {
                    spare = (InternalMultiBucketAggregation.InternalBucket)input.emptyBucketBuilder.get();
                }
                input.bucketUpdateFunction.updateBucket(spare, input.ordsEnum, docCount);
                spare = ordered.insertWithOverflow(spare);
            }
            InternalMultiBucketAggregation.InternalBucket[] topBuckets = (InternalMultiBucketAggregation.InternalBucket[])input.bucketArrayBuilder.buildBuckets(ordered.size());
            if (InternalOrder.isKeyOrder(input.order)) {
                for (int b = ordered.size() - 1; b >= 0; --b) {
                    topBuckets[b] = (InternalMultiBucketAggregation.InternalBucket)ordered.pop();
                    otherDocCount -= topBuckets[b].getDocCount();
                }
            } else {
                Iterator itr = ordered.iterator();
                for (int b = ordered.size() - 1; b >= 0; --b) {
                    topBuckets[b] = (InternalMultiBucketAggregation.InternalBucket)itr.next();
                    otherDocCount -= topBuckets[b].getDocCount();
                }
            }
            return new SelectionResult(topBuckets, otherDocCount, "priority_queue");
        }
    }
    ,
    QUICK_SELECT_OR_SELECT_ALL{

        @Override
        public <B extends InternalMultiBucketAggregation.InternalBucket> SelectionResult<B> selectTopBuckets(SelectionInput<B> input) throws IOException {
            String actualStrategy;
            InternalMultiBucketAggregation.InternalBucket[] topBuckets;
            InternalMultiBucketAggregation.InternalBucket[] bucketsForOrd = (InternalMultiBucketAggregation.InternalBucket[])input.bucketArrayBuilder.buildBuckets((int)input.bucketsInOrd);
            int validBucketCount = 0;
            long otherDocCount = 0L;
            while (input.ordsEnum.next()) {
                long docCount = input.bucketDocCountFunction.bucketDocCount(input.ordsEnum.ord());
                otherDocCount += docCount;
                if (docCount < input.localBucketCountThresholds.getMinDocCount()) continue;
                InternalMultiBucketAggregation.InternalBucket spare = (InternalMultiBucketAggregation.InternalBucket)input.emptyBucketBuilder.get();
                input.bucketUpdateFunction.updateBucket(spare, input.ordsEnum, docCount);
                bucketsForOrd[validBucketCount++] = spare;
            }
            if (validBucketCount > input.size) {
                ArrayUtil.select(bucketsForOrd, 0, validBucketCount, input.size, (b1, b2) -> input.partiallyBuiltBucketComparator.compare((InternalTerms.Bucket)b1, (InternalTerms.Bucket)b2));
                topBuckets = Arrays.copyOf(bucketsForOrd, input.size);
                for (int b = 0; b < input.size; ++b) {
                    otherDocCount -= topBuckets[b].getDocCount();
                }
                actualStrategy = "quick_select";
            } else {
                topBuckets = Arrays.copyOf(bucketsForOrd, validBucketCount);
                otherDocCount = 0L;
                actualStrategy = "select_all";
            }
            return new SelectionResult(topBuckets, otherDocCount, actualStrategy);
        }
    };


    public static BucketSelectionStrategy determine(int size, long bucketsInOrd, BucketOrder order, Comparator<InternalTerms.Bucket<?>> partiallyBuiltBucketComparator, int factor) {
        if ((long)size * (long)factor < bucketsInOrd || InternalOrder.isKeyOrder(order) || partiallyBuiltBucketComparator == null) {
            return PRIORITY_QUEUE;
        }
        return QUICK_SELECT_OR_SELECT_ALL;
    }

    public abstract <B extends InternalMultiBucketAggregation.InternalBucket> SelectionResult<B> selectTopBuckets(SelectionInput<B> var1) throws IOException;

    @FunctionalInterface
    public static interface PriorityQueueBuilder<B> {
        public PriorityQueue<B> buildPriorityQueue(int var1);
    }

    @FunctionalInterface
    public static interface BucketArrayBuilder<B> {
        public B[] buildBuckets(int var1);
    }

    @FunctionalInterface
    public static interface BucketUpdateFunction<B> {
        public void updateBucket(B var1, LongKeyedBucketOrds.BucketOrdsEnum var2, long var3) throws IOException;
    }

    @FunctionalInterface
    public static interface BucketDocCountFunction {
        public long bucketDocCount(long var1) throws IOException;
    }

    public static class SelectionResult<B extends InternalMultiBucketAggregation.InternalBucket> {
        public final B[] topBuckets;
        public final long otherDocCount;
        public final String actualStrategyUsed;

        public SelectionResult(B[] topBuckets, long otherDocCount, String actualStrategyUsed) {
            this.topBuckets = topBuckets;
            this.otherDocCount = otherDocCount;
            this.actualStrategyUsed = actualStrategyUsed;
        }
    }

    public static class SelectionInput<B extends InternalMultiBucketAggregation.InternalBucket> {
        public final int size;
        public final long bucketsInOrd;
        public final LongKeyedBucketOrds.BucketOrdsEnum ordsEnum;
        public final Supplier<B> emptyBucketBuilder;
        public final LocalBucketCountThresholds localBucketCountThresholds;
        public final int ordIdx;
        public final BucketOrder order;
        public final PriorityQueueBuilder<B> buildPriorityQueue;
        public final BucketArrayBuilder<B> bucketArrayBuilder;
        public final BucketUpdateFunction<B> bucketUpdateFunction;
        public final BucketDocCountFunction bucketDocCountFunction;
        public final Comparator<InternalTerms.Bucket<?>> partiallyBuiltBucketComparator;

        public SelectionInput(int size, long bucketsInOrd, LongKeyedBucketOrds.BucketOrdsEnum ordsEnum, Supplier<B> emptyBucketBuilder, LocalBucketCountThresholds localBucketCountThresholds, int ordIdx, BucketOrder order, PriorityQueueBuilder<B> buildPriorityQueue, BucketArrayBuilder<B> bucketArrayBuilder, BucketUpdateFunction<B> bucketUpdateFunction, BucketDocCountFunction bucketDocCountFunction, Comparator<InternalTerms.Bucket<?>> partiallyBuiltBucketComparator) {
            this.size = size;
            this.bucketsInOrd = bucketsInOrd;
            this.ordsEnum = ordsEnum;
            this.emptyBucketBuilder = emptyBucketBuilder;
            this.localBucketCountThresholds = localBucketCountThresholds;
            this.ordIdx = ordIdx;
            this.order = order;
            this.buildPriorityQueue = buildPriorityQueue;
            this.bucketArrayBuilder = bucketArrayBuilder;
            this.bucketUpdateFunction = bucketUpdateFunction;
            this.bucketDocCountFunction = bucketDocCountFunction;
            this.partiallyBuiltBucketComparator = partiallyBuiltBucketComparator;
        }
    }
}

