/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.ParsedAggregation;
import org.opensearch.search.aggregations.metrics.Cardinality;

public class ParsedCardinality
extends ParsedAggregation
implements Cardinality {
    private long cardinalityValue;
    private static final ObjectParser<ParsedCardinality, Void> PARSER = new ObjectParser(ParsedCardinality.class.getSimpleName(), true, ParsedCardinality::new);

    @Override
    public String getValueAsString() {
        return Double.toString(this.cardinalityValue);
    }

    @Override
    public double value() {
        return this.getValue();
    }

    @Override
    public long getValue() {
        return this.cardinalityValue;
    }

    @Override
    public String getType() {
        return "cardinality";
    }

    public static ParsedCardinality fromXContent(XContentParser parser, String name) {
        ParsedCardinality cardinality = PARSER.apply(parser, null);
        cardinality.setName(name);
        return cardinality;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.cardinalityValue);
        return builder;
    }

    static {
        ParsedCardinality.declareAggregationFields(PARSER);
        PARSER.declareLong((agg, value) -> {
            agg.cardinalityValue = value;
        }, Aggregation.CommonFields.VALUE);
    }
}

